/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.schema.validator.v3;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.openapi4j.core.model.v3.OAI3;
import org.openapi4j.core.validation.ValidationException;
import org.openapi4j.core.validation.ValidationResult;
import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.core.validation.ValidationSeverity;
import org.openapi4j.schema.validator.BaseJsonValidator;
import org.openapi4j.schema.validator.ValidationContext;
import org.openapi4j.schema.validator.ValidationData;
import org.openapi4j.schema.validator.v3.SchemaValidator;

class DependenciesValidator
extends BaseJsonValidator<OAI3> {
    private static final ValidationResult ERR = new ValidationResult(ValidationSeverity.ERROR, Integer.valueOf(1002), "Missing dependency '%s' from '%s' definition.");
    private static final ValidationResults.CrumbInfo CRUMB_INFO = new ValidationResults.CrumbInfo("dependencies", true);
    private final Map<String, Collection<String>> arrayDependencies = new HashMap<String, Collection<String>>();
    private final Map<String, SchemaValidator> objectDependencies = new HashMap<String, SchemaValidator>();

    DependenciesValidator(ValidationContext<OAI3> context, JsonNode schemaNode, JsonNode schemaParentNode, SchemaValidator parentSchema) {
        super(context, schemaNode, schemaParentNode, parentSchema);
        Iterator fieldNames = schemaNode.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            JsonNode fieldSchemaVal = schemaNode.get(fieldName);
            if (fieldSchemaVal.isObject()) {
                this.objectDependencies.put(fieldName, new SchemaValidator(context, new ValidationResults.CrumbInfo(fieldName, false), fieldSchemaVal, schemaParentNode, parentSchema));
                continue;
            }
            if (!fieldSchemaVal.isArray()) continue;
            Collection values = this.arrayDependencies.computeIfAbsent(fieldName, k -> new ArrayList());
            for (int i = 0; i < fieldSchemaVal.size(); ++i) {
                values.add(fieldSchemaVal.get(i).asText());
            }
        }
    }

    @Override
    public boolean validate(JsonNode valueNode, ValidationData<?> validation) {
        Iterator fieldNames = valueNode.fieldNames();
        this.validate(() -> {
            while (fieldNames.hasNext()) {
                String fieldName = (String)fieldNames.next();
                Collection<String> values = this.arrayDependencies.get(fieldName);
                if (values != null) {
                    this.validateArray(valueNode, values, validation);
                    continue;
                }
                this.validateObject(valueNode, this.objectDependencies.get(fieldName), validation);
            }
        });
        return false;
    }

    private void validateArray(JsonNode valueNode, Collection<String> values, ValidationData<?> validation) {
        for (String field : values) {
            if (valueNode.get(field) != null) continue;
            validation.add(CRUMB_INFO, ERR, field, this.arrayDependencies.toString());
        }
    }

    private void validateObject(JsonNode valueNode, SchemaValidator schema, ValidationData<?> validation) throws ValidationException {
        if (schema != null) {
            schema.validateWithContext(valueNode, validation);
        }
    }
}

