/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.schema.validator.v3;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openapi4j.core.model.v3.OAI3;
import org.openapi4j.core.validation.ValidationResult;
import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.core.validation.ValidationSeverity;
import org.openapi4j.schema.validator.BaseJsonValidator;
import org.openapi4j.schema.validator.ValidationContext;
import org.openapi4j.schema.validator.ValidationData;
import org.openapi4j.schema.validator.v3.SchemaValidator;

class AdditionalPropertiesValidator
extends BaseJsonValidator<OAI3> {
    private static final ValidationResult ERR = new ValidationResult(ValidationSeverity.ERROR, Integer.valueOf(1000), "Additional property '%s' is not allowed.");
    private static final ValidationResults.CrumbInfo CRUMB_INFO = new ValidationResults.CrumbInfo("additionalProperties", true);
    private final Set<String> allowedProperties;
    private final Set<Pattern> allowedPatternProperties;
    private final Boolean additionalPropertiesAllowed;
    private final SchemaValidator additionalPropertiesSchema;

    AdditionalPropertiesValidator(ValidationContext<OAI3> context, JsonNode schemaNode, JsonNode schemaParentNode, SchemaValidator parentSchema) {
        super(context, schemaNode, schemaParentNode, parentSchema);
        if (schemaNode.isBoolean()) {
            this.additionalPropertiesAllowed = schemaNode.booleanValue();
            this.additionalPropertiesSchema = null;
        } else {
            this.additionalPropertiesAllowed = false;
            this.additionalPropertiesSchema = new SchemaValidator(context, CRUMB_INFO, schemaNode, schemaParentNode, parentSchema);
        }
        if (Boolean.TRUE.equals(this.additionalPropertiesAllowed)) {
            this.allowedProperties = null;
            this.allowedPatternProperties = null;
        } else {
            JsonNode propertiesNode = schemaParentNode.get("properties");
            this.allowedProperties = this.setupAllowedProperties(propertiesNode);
            JsonNode patternPropertiesNode = schemaParentNode.get("patternProperties");
            this.allowedPatternProperties = this.setupAllowedPatternProperties(patternPropertiesNode);
        }
    }

    @Override
    public boolean validate(JsonNode valueNode, ValidationData<?> validation) {
        if (Boolean.TRUE.equals(this.additionalPropertiesAllowed)) {
            return false;
        }
        this.validate(() -> {
            Iterator it = valueNode.fieldNames();
            while (it.hasNext()) {
                String fieldName = (String)it.next();
                if (this.checkAgainstPatternProperties(fieldName) || this.checkAgainstProperties(fieldName)) continue;
                if (this.additionalPropertiesSchema != null) {
                    this.additionalPropertiesSchema.validateWithContext(valueNode.get(fieldName), validation);
                    continue;
                }
                validation.add(CRUMB_INFO, ERR, fieldName);
            }
        });
        return false;
    }

    private Set<String> setupAllowedProperties(JsonNode propertiesNode) {
        HashSet<String> values;
        if (propertiesNode != null) {
            values = new HashSet<String>();
            Iterator it = propertiesNode.fieldNames();
            while (it.hasNext()) {
                values.add((String)it.next());
            }
        } else {
            values = null;
        }
        return values;
    }

    private Set<Pattern> setupAllowedPatternProperties(JsonNode patternPropertiesNode) {
        HashSet<Pattern> values;
        if (patternPropertiesNode != null) {
            values = new HashSet<Pattern>();
            Iterator it = patternPropertiesNode.fieldNames();
            while (it.hasNext()) {
                values.add(Pattern.compile((String)it.next()));
            }
        } else {
            values = null;
        }
        return values;
    }

    private boolean checkAgainstPatternProperties(String fieldName) {
        if (this.allowedPatternProperties != null) {
            for (Pattern pattern : this.allowedPatternProperties) {
                Matcher m = pattern.matcher(fieldName);
                if (!m.find()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkAgainstProperties(String fieldName) {
        return this.allowedProperties != null && this.allowedProperties.contains(fieldName);
    }
}

