/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.parser.validation.v3;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openapi4j.core.validation.ValidationResult;
import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.core.validation.ValidationSeverity;
import org.openapi4j.parser.model.v3.OpenApi3;
import org.openapi4j.parser.model.v3.SecurityRequirement;
import org.openapi4j.parser.validation.ValidationContext;
import org.openapi4j.parser.validation.Validator;
import org.openapi4j.parser.validation.v3.Validator3Base;

class SecurityRequirementValidator
extends Validator3Base<OpenApi3, SecurityRequirement> {
    private static final ValidationResult SCHEME_NOT_DEFINED = new ValidationResult(ValidationSeverity.ERROR, Integer.valueOf(139), "Security scheme '%s' is not defined in components");
    private static final ValidationResult SEC_REQ_NOT_ALLOWED = new ValidationResult(ValidationSeverity.ERROR, Integer.valueOf(140), "Security requirement parameters in '%s' not allowed with scheme type '%s'");
    private static final Validator<OpenApi3, SecurityRequirement> INSTANCE = new SecurityRequirementValidator();

    private SecurityRequirementValidator() {
    }

    public static Validator<OpenApi3, SecurityRequirement> instance() {
        return INSTANCE;
    }

    @Override
    public void validate(ValidationContext<OpenApi3> context, OpenApi3 api, SecurityRequirement securityRequirement, ValidationResults results) {
        Set<String> schemes = api.getComponents().getSecuritySchemes().keySet();
        for (Map.Entry<String, List<String>> entry : securityRequirement.getRequirements().entrySet()) {
            if (!schemes.contains(entry.getKey())) {
                results.add(SCHEME_NOT_DEFINED, new Object[]{entry.getKey()});
                continue;
            }
            String type = api.getComponents().getSecurityScheme(entry.getKey()).getType();
            if (type == null || "oauth2".equals(type) || "openIdConnect".equals(type) || entry.getValue().isEmpty()) continue;
            results.add(SEC_REQ_NOT_ALLOWED, new Object[]{entry.getKey(), type});
        }
    }
}

