/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.parser.validation.v3;

import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.parser.model.v3.OpenApi3;
import org.openapi4j.parser.model.v3.Response;
import org.openapi4j.parser.validation.ValidationContext;
import org.openapi4j.parser.validation.Validator;
import org.openapi4j.parser.validation.v3.HeaderValidator;
import org.openapi4j.parser.validation.v3.LinkValidator;
import org.openapi4j.parser.validation.v3.MediaTypeValidator;
import org.openapi4j.parser.validation.v3.OAI3Keywords;
import org.openapi4j.parser.validation.v3.Regexes;
import org.openapi4j.parser.validation.v3.Validator3Base;

class ResponseValidator
extends Validator3Base<OpenApi3, Response> {
    private static final Validator<OpenApi3, Response> INSTANCE = new ResponseValidator();

    private ResponseValidator() {
    }

    public static Validator<OpenApi3, Response> instance() {
        return INSTANCE;
    }

    @Override
    public void validate(ValidationContext<OpenApi3> context, OpenApi3 api, Response response, ValidationResults results) {
        if (response.isRef()) {
            this.validateReference(context, api, response, results, OAI3Keywords.CRUMB_$REF, ResponseValidator.instance(), Response.class);
        } else {
            this.validateRequired(response.getDescription(), results, true, OAI3Keywords.CRUMB_DESCRIPTION);
            this.validateMap(context, api, response.getHeaders(), results, false, OAI3Keywords.CRUMB_HEADERS, null, HeaderValidator.instance());
            this.validateMap(context, api, response.getContentMediaTypes(), results, false, OAI3Keywords.CRUMB_CONTENT, Regexes.NOEXT_REGEX, MediaTypeValidator.instance());
            this.validateMap(context, api, response.getLinks(), results, false, OAI3Keywords.CRUMB_LINKS, Regexes.NOEXT_NAME_REGEX, LinkValidator.instance());
            this.validateMap(context, api, response.getExtensions(), results, false, OAI3Keywords.CRUMB_EXTENSIONS, Regexes.EXT_REGEX, null);
        }
    }
}

