/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.parser.validation.v3;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openapi4j.core.validation.ValidationResult;
import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.core.validation.ValidationSeverity;
import org.openapi4j.parser.model.v3.OpenApi3;
import org.openapi4j.parser.model.v3.Operation;
import org.openapi4j.parser.model.v3.Parameter;
import org.openapi4j.parser.model.v3.Path;
import org.openapi4j.parser.validation.ValidationContext;
import org.openapi4j.parser.validation.Validator;
import org.openapi4j.parser.validation.v3.OAI3Keywords;
import org.openapi4j.parser.validation.v3.OperationValidator;
import org.openapi4j.parser.validation.v3.ParameterValidator;
import org.openapi4j.parser.validation.v3.Regexes;
import org.openapi4j.parser.validation.v3.ServerValidator;
import org.openapi4j.parser.validation.v3.Validator3Base;

class PathValidator
extends Validator3Base<OpenApi3, Path> {
    private static final Validator<OpenApi3, Path> INSTANCE = new PathValidator();
    private static final ValidationResult REQUIRED_PATH_PARAM = new ValidationResult(ValidationSeverity.ERROR, Integer.valueOf(122), "Parameter '%s' in path '%s' must have 'required' property set to true");
    private static final ValidationResult UNEXPECTED_PATH_PARAM = new ValidationResult(ValidationSeverity.ERROR, Integer.valueOf(123), "Path parameter '%s' in path '%s' is unexpected");
    private static final ValidationResult MISMATCH_PATH_PARAM = new ValidationResult(ValidationSeverity.ERROR, Integer.valueOf(124), "Path parameter '%s' in path '%s' is expected but undefined");
    private static final Pattern PATTERN_PATH_PARAM = Pattern.compile("\\{[.;?*+]*([^{}.;?*+]+)[^}]*}");

    private PathValidator() {
    }

    public static Validator<OpenApi3, Path> instance() {
        return INSTANCE;
    }

    @Override
    public void validate(ValidationContext<OpenApi3> context, OpenApi3 api, Path path, ValidationResults results) {
        if (path.isRef()) {
            this.validateReference(context, api, path, results, OAI3Keywords.CRUMB_$REF, PathValidator.instance(), Path.class);
        } else {
            this.validateMap(context, api, path.getExtensions(), results, false, OAI3Keywords.CRUMB_EXTENSIONS, Regexes.EXT_REGEX, null);
            this.validateMap(context, api, path.getOperations(), results, false, null, Regexes.METHOD_REGEX, OperationValidator.instance());
            this.validateList(context, api, path.getParameters(), results, false, 0, OAI3Keywords.CRUMB_PARAMETERS, ParameterValidator.instance());
            this.validateList(context, api, path.getServers(), results, false, 0, OAI3Keywords.CRUMB_SERVERS, ServerValidator.instance());
            this.checkPathParams(api, path, results);
        }
    }

    private void checkPathParams(OpenApi3 api, Path pathItem, ValidationResults results) {
        String path = this.getPathKey(api, api.getPaths(), pathItem, results);
        if (path != null) {
            List<String> pathParams = this.getPathParams(path);
            Map<String, Operation> operations = pathItem.getOperations();
            if (operations == null) {
                this.discoverAndCheckParams(path, pathParams, pathItem.getParametersIn(api.getContext(), "path"), results);
            } else {
                for (Operation operation : operations.values()) {
                    List<Parameter> params = this.mergePathParameters(api, pathItem, operation);
                    this.discoverAndCheckParams(path, pathParams, params, results);
                }
            }
        }
    }

    private String getPathKey(OpenApi3 api, Map<String, Path> map, Path value, ValidationResults results) {
        for (Map.Entry<String, Path> entry : map.entrySet()) {
            Path pathItem = entry.getValue();
            if (pathItem.isRef()) {
                pathItem = this.getReferenceContent(api, pathItem, results, OAI3Keywords.CRUMB_$REF, Path.class);
            }
            if (!pathItem.equals(value)) continue;
            return entry.getKey();
        }
        return null;
    }

    private List<Parameter> mergePathParameters(OpenApi3 api, Path path, Operation operation) {
        List<Parameter> opParams = operation.getParametersIn(api.getContext(), "path");
        if (opParams.isEmpty()) {
            return path.getParametersIn(api.getContext(), "path");
        }
        List<Parameter> pathParams = path.getParametersIn(api.getContext(), "path");
        return Stream.concat(opParams.stream(), pathParams.stream()).distinct().collect(Collectors.toList());
    }

    private void discoverAndCheckParams(String path, List<String> pathParams, Collection<Parameter> parameters, ValidationResults results) {
        ArrayList<String> discoveredPathParameters = new ArrayList<String>();
        if (parameters != null) {
            for (Parameter parameter : parameters) {
                String paramName = this.checkPathParam(path, parameter, pathParams, results);
                if (paramName == null) continue;
                discoveredPathParameters.add(paramName);
            }
        }
        this.validatePathParametersMatching(path, pathParams, discoveredPathParameters, results);
    }

    private String checkPathParam(String path, Parameter parameter, List<String> pathParams, ValidationResults results) {
        if (!parameter.isRequired()) {
            results.add(OAI3Keywords.CRUMB_REQUIRED, REQUIRED_PATH_PARAM, new Object[]{parameter.getName(), path});
        }
        if (parameter.getName() == null) {
            return null;
        }
        if (!pathParams.contains(parameter.getName())) {
            results.add(OAI3Keywords.CRUMB_NAME, UNEXPECTED_PATH_PARAM, new Object[]{parameter.getName(), path});
        }
        return parameter.getName();
    }

    private List<String> getPathParams(String path) {
        Matcher matcher = PATTERN_PATH_PARAM.matcher(path);
        ArrayList<String> pathParams = new ArrayList<String>();
        while (matcher.find()) {
            pathParams.add(matcher.group(1));
        }
        return pathParams;
    }

    private void validatePathParametersMatching(String path, List<String> refParams, List<String> discoveredParams, ValidationResults results) {
        for (String name : refParams) {
            if (discoveredParams.contains(name)) continue;
            results.add(OAI3Keywords.CRUMB_NAME, MISMATCH_PATH_PARAM, new Object[]{name, path});
        }
    }
}

