/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.parser.validation.v3;

import java.util.regex.Pattern;
import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.parser.model.v3.OpenApi3;
import org.openapi4j.parser.validation.ValidationContext;
import org.openapi4j.parser.validation.Validator;
import org.openapi4j.parser.validation.v3.ComponentsValidator;
import org.openapi4j.parser.validation.v3.ExternalDocsValidator;
import org.openapi4j.parser.validation.v3.InfoValidator;
import org.openapi4j.parser.validation.v3.OAI3Keywords;
import org.openapi4j.parser.validation.v3.PathValidator;
import org.openapi4j.parser.validation.v3.Regexes;
import org.openapi4j.parser.validation.v3.SecurityRequirementValidator;
import org.openapi4j.parser.validation.v3.ServerValidator;
import org.openapi4j.parser.validation.v3.TagValidator;
import org.openapi4j.parser.validation.v3.Validator3Base;

class OpenApiValidator
extends Validator3Base<OpenApi3, OpenApi3> {
    private static final Pattern PATTERN_OAI3 = Pattern.compile("3\\.\\d+(\\.\\d+.*)?");
    private static final Validator<OpenApi3, OpenApi3> INSTANCE = new OpenApiValidator();

    private OpenApiValidator() {
    }

    public static Validator<OpenApi3, OpenApi3> instance() {
        return INSTANCE;
    }

    @Override
    public void validate(ValidationContext<OpenApi3> context, OpenApi3 root, OpenApi3 api, ValidationResults results) {
        this.validateString(api.getOpenapi(), results, true, PATTERN_OAI3, OAI3Keywords.CRUMB_OPENAPI);
        this.validateField(context, api, api.getInfo(), results, true, OAI3Keywords.CRUMB_INFO, InfoValidator.instance());
        this.validateList(context, api, api.getServers(), results, false, 0, OAI3Keywords.CRUMB_SERVERS, ServerValidator.instance());
        this.validateMap(context, api, api.getPaths(), results, true, OAI3Keywords.CRUMB_PATHS, Regexes.PATH_REGEX, PathValidator.instance());
        this.validateField(context, api, api.getComponents(), results, false, OAI3Keywords.CRUMB_COMPONENTS, ComponentsValidator.instance());
        this.validateList(context, api, api.getSecurityRequirements(), results, false, 0, OAI3Keywords.CRUMB_SECURITY, SecurityRequirementValidator.instance());
        this.validateList(context, api, api.getTags(), results, false, 0, OAI3Keywords.CRUMB_TAGS, TagValidator.instance());
        this.validateField(context, api, api.getExternalDocs(), results, false, OAI3Keywords.CRUMB_EXTERNALDOCS, ExternalDocsValidator.instance());
        this.validateMap(context, api, api.getExtensions(), results, false, OAI3Keywords.CRUMB_EXTENSIONS, Regexes.EXT_REGEX, null);
    }
}

