/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.parser.model.v3;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashMap;
import java.util.Map;
import org.openapi4j.parser.model.v3.AbsExtendedOpenApiSchema;
import org.openapi4j.parser.model.v3.ServerVariable;

public class Server
extends AbsExtendedOpenApiSchema<Server> {
    private String url;
    private String description;
    private Map<String, ServerVariable> variables;

    public String getUrl() {
        return this.url;
    }

    public Server setUrl(String url) {
        this.url = url;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Server setDescription(String description) {
        this.description = description;
        return this;
    }

    public Map<String, ServerVariable> getVariables() {
        return this.variables;
    }

    public Server setVariables(Map<String, ServerVariable> variables) {
        this.variables = variables;
        return this;
    }

    public boolean hasVariable(String name) {
        return this.mapHas(this.variables, name);
    }

    public ServerVariable getVariable(String name) {
        return this.mapGet(this.variables, name);
    }

    public Server setVariable(String name, ServerVariable serverVariable) {
        if (this.variables == null) {
            this.variables = new HashMap<String, ServerVariable>();
        }
        this.variables.put(name, serverVariable);
        return this;
    }

    public Server removeVariable(String name) {
        this.mapRemove(this.variables, name);
        return this;
    }

    @JsonIgnore
    public String getDefaultUrl() {
        String result = this.url;
        if (this.getVariables() != null) {
            for (Map.Entry<String, ServerVariable> entry : this.getVariables().entrySet()) {
                result = result.replace("{" + entry.getKey() + "}", entry.getValue().getDefault());
            }
        }
        return result;
    }

    @Override
    public Server copy() {
        Server copy = new Server();
        copy.setUrl(this.getUrl());
        copy.setDescription(this.getDescription());
        copy.setVariables(this.copyMap(this.getVariables()));
        copy.setExtensions(this.copySimpleMap(this.getExtensions()));
        return copy;
    }
}

