/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.parser.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import java.net.URL;
import org.openapi4j.core.model.OAIContext;
import org.openapi4j.core.model.reference.Reference;
import org.openapi4j.parser.model.AbsOpenApiSchema;
import org.openapi4j.parser.model.OpenApiSchema;

public abstract class AbsRefOpenApiSchema<M extends OpenApiSchema<M>>
extends AbsOpenApiSchema<M> {
    @JsonProperty(value="$ref")
    private String ref;
    @JsonProperty(value="abs$ref")
    @JsonView(value={AbsOpenApiSchema.Views.Internal.class})
    private String canonicalRef;

    public String getRef() {
        return this.ref;
    }

    public boolean isRef() {
        return this.ref != null;
    }

    protected void setRef(String ref) {
        this.ref = ref;
    }

    protected void setCanonicalRef(String canonicalRef) {
        this.canonicalRef = canonicalRef;
    }

    public String getCanonicalRef() {
        return this.canonicalRef;
    }

    public Reference getReference(OAIContext context) {
        return context.getReferenceRegistry().getRef(this.canonicalRef != null ? this.canonicalRef : this.ref);
    }

    public Reference setReference(OAIContext context, URL url, String ref) {
        Reference reference = context.getReferenceRegistry().addRef(url, ref);
        this.setRef(reference.getRef());
        this.setCanonicalRef(reference.getCanonicalRef());
        return reference;
    }
}

