/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.parser;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.openapi4j.core.exception.ResolutionException;
import org.openapi4j.core.model.AuthOption;
import org.openapi4j.core.model.OAI;
import org.openapi4j.core.validation.ValidationException;

public abstract class OpenApiParser<O extends OAI> {
    private static final String INVALID_FILE = "File must be specified";
    private static final String INVALID_URL = "Unable to read from url";

    public O parse(File specFile, boolean validate) throws ResolutionException, ValidationException {
        if (specFile == null) {
            throw new ResolutionException(INVALID_FILE);
        }
        try {
            return this.parse(specFile.toURI().toURL(), validate);
        }
        catch (MalformedURLException e) {
            throw new ResolutionException(INVALID_URL, (Throwable)e);
        }
    }

    public O parse(URL url, boolean validate) throws ResolutionException, ValidationException {
        return this.parse(url, null, validate);
    }

    public abstract O parse(URL var1, List<AuthOption> var2, boolean var3) throws ResolutionException, ValidationException;
}

