/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.parser.validation.v3;

import java.util.regex.Pattern;
import org.openapi4j.core.validation.ValidationResult;
import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.core.validation.ValidationSeverity;
import org.openapi4j.parser.model.v3.Header;
import org.openapi4j.parser.model.v3.OpenApi3;
import org.openapi4j.parser.validation.ValidationContext;
import org.openapi4j.parser.validation.Validator;
import org.openapi4j.parser.validation.v3.MediaTypeValidator;
import org.openapi4j.parser.validation.v3.OAI3Keywords;
import org.openapi4j.parser.validation.v3.Regexes;
import org.openapi4j.parser.validation.v3.SchemaValidator;
import org.openapi4j.parser.validation.v3.Validator3Base;

class HeaderValidator
extends Validator3Base<OpenApi3, Header> {
    private static final ValidationResult CONTENT_ONY_ONE_ERR = new ValidationResult(ValidationSeverity.ERROR, Integer.valueOf(113), "Content can only contain one media type.");
    private static final ValidationResult CONTENT_SCHEMA_EXCLUSIVE_ERR = new ValidationResult(ValidationSeverity.ERROR, Integer.valueOf(114), "Content and schema are mutually exclusive.");
    private static final Validator<OpenApi3, Header> INSTANCE = new HeaderValidator();

    private HeaderValidator() {
    }

    public static Validator<OpenApi3, Header> instance() {
        return INSTANCE;
    }

    @Override
    public void validate(ValidationContext<OpenApi3> context, OpenApi3 api, Header header, ValidationResults results) {
        if (header.isRef()) {
            this.validateReference(context, api, header, results, OAI3Keywords.CRUMB_$REF, HeaderValidator.instance(), Header.class);
        } else {
            this.validateString(header.getStyle(), results, false, Pattern.compile("simple"), OAI3Keywords.CRUMB_STYLE);
            this.validateField(context, api, header.getSchema(), results, false, OAI3Keywords.CRUMB_SCHEMA, SchemaValidator.instance());
            this.validateMap(context, api, header.getContentMediaTypes(), results, false, OAI3Keywords.CRUMB_CONTENT, Regexes.NOEXT_REGEX, MediaTypeValidator.instance());
            this.validateMap(context, api, header.getExtensions(), results, false, OAI3Keywords.CRUMB_EXTENSIONS, Regexes.EXT_REGEX, null);
            if (header.getContentMediaTypes() != null && header.getSchema() != null) {
                results.add(CONTENT_SCHEMA_EXCLUSIVE_ERR, new Object[0]);
            }
            if (header.getContentMediaTypes() != null && header.getContentMediaTypes().size() > 1) {
                results.add(CONTENT_ONY_ONE_ERR, new Object[0]);
            }
        }
    }
}

