/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.parser.validation.v3;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openapi4j.core.exception.DecodeException;
import org.openapi4j.core.model.OAIContext;
import org.openapi4j.core.validation.ValidationResult;
import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.core.validation.ValidationSeverity;
import org.openapi4j.parser.model.v3.MediaType;
import org.openapi4j.parser.model.v3.OpenApi3;
import org.openapi4j.parser.model.v3.Operation;
import org.openapi4j.parser.model.v3.Parameter;
import org.openapi4j.parser.model.v3.RequestBody;
import org.openapi4j.parser.model.v3.Response;
import org.openapi4j.parser.model.v3.Schema;
import org.openapi4j.parser.validation.v3.Validator3Base;

abstract class ExpressionValidator<M>
extends Validator3Base<OpenApi3, M> {
    private static final ValidationResult PARAM_NOT_FOUND_ERR = new ValidationResult(ValidationSeverity.ERROR, Integer.valueOf(111), "Parameter '%s' not found in operation.");
    private static final ValidationResult PARAM_PATH_EXCEPTION_ERR = new ValidationResult(ValidationSeverity.ERROR, Integer.valueOf(112), "Path '%s' is malformed.\n'%s'");
    private static final Pattern PARAM_PATTERN = Pattern.compile("\\{(.*?)}");
    private static final Pattern PATTERN_REQUEST_PARAM = Pattern.compile("^(\\$request)(?:\\.)(query(?=\\.)|path(?=\\.)|header(?=\\.)|body(?=#/))(?:\\.|#/)(.+)");
    private static final Pattern PATTERN_RESPONSE_PARAM = Pattern.compile("^(\\$response)(?:\\.)(header(?=\\.)|body(?=#/))(?:\\.|#/)(.+)");

    ExpressionValidator() {
    }

    void validateExpression(OpenApi3 api, Operation operation, String expression, ValidationResults results) {
        boolean paramFound = false;
        Matcher matcher = PARAM_PATTERN.matcher(expression);
        while (matcher.find()) {
            paramFound = true;
            if (this.checkRequestParameter(api, operation, matcher.group(1), results)) continue;
            this.checkResponseParameter(api, operation, matcher.group(1), results);
        }
        if (!paramFound && !this.checkRequestParameter(api, operation, expression, results)) {
            this.checkResponseParameter(api, operation, expression, results);
        }
    }

    private boolean checkRequestParameter(OpenApi3 api, Operation operation, String propValue, ValidationResults results) {
        Matcher matcher = PATTERN_REQUEST_PARAM.matcher(propValue);
        boolean matches = matcher.matches();
        if (matches) {
            if (matcher.group(2).equals("body")) {
                RequestBody reqBody = operation.getRequestBody();
                if (reqBody != null && this.hasBodyProperty(api, matcher.group(3), reqBody.getContentMediaTypes(), results)) {
                    return true;
                }
                results.add(PARAM_NOT_FOUND_ERR, new Object[]{propValue});
            } else if (this.checkParameterIn(matcher.group(2), matcher.group(3), api.getContext(), operation, results)) {
                return true;
            }
        }
        return matches;
    }

    private boolean checkResponseParameter(OpenApi3 api, Operation operation, String propValue, ValidationResults results) {
        if (operation.getResponses() == null) {
            return false;
        }
        Matcher matcher = PATTERN_RESPONSE_PARAM.matcher(propValue);
        boolean matches = matcher.matches();
        if (matches) {
            if (matcher.group(2).equals("body")) {
                for (Response response : operation.getResponses().values()) {
                    if (!this.hasBodyProperty(api, matcher.group(3), response.getContentMediaTypes(), results)) continue;
                    return true;
                }
                results.add(PARAM_NOT_FOUND_ERR, new Object[]{propValue});
            } else {
                for (Response response : operation.getResponses().values()) {
                    if (response.getHeaders() == null) continue;
                    for (String header : response.getHeaders().keySet()) {
                        if (!header.equalsIgnoreCase(matcher.group(3))) continue;
                        return true;
                    }
                }
                results.add(PARAM_NOT_FOUND_ERR, new Object[]{propValue});
                return false;
            }
        }
        return matches;
    }

    private boolean hasBodyProperty(OpenApi3 api, String propValue, Map<String, MediaType> contentMediaTypes, ValidationResults results) {
        if (contentMediaTypes == null) {
            return false;
        }
        String[] pathFragments = propValue.split("/");
        for (Map.Entry<String, MediaType> entry : contentMediaTypes.entrySet()) {
            try {
                if (!this.hasBodyProperty(api, entry.getValue().getSchema(), pathFragments, 0)) continue;
                return true;
            }
            catch (DecodeException e) {
                results.add(PARAM_PATH_EXCEPTION_ERR, new Object[]{propValue, e.getMessage()});
            }
        }
        return false;
    }

    private boolean hasBodyProperty(OpenApi3 api, Schema schema, String[] pathFragments, int index) throws DecodeException {
        if (schema == null) {
            return false;
        }
        if (pathFragments.length > index) {
            if (schema.isRef()) {
                schema = (Schema)schema.getReference(api.getContext()).getMappedContent(Schema.class);
            }
            if ("array".equals(schema.getType())) {
                return this.hasBodyProperty(api, schema.getItemsSchema(), pathFragments, index);
            }
            Schema subSchema = schema.getProperty(pathFragments[index]);
            if (subSchema == null) {
                return false;
            }
            return pathFragments.length == ++index || this.hasBodyProperty(api, subSchema, pathFragments, index);
        }
        return false;
    }

    private boolean checkParameterIn(String in, String propName, OAIContext context, Operation operation, ValidationResults results) {
        for (Parameter param : operation.getParametersIn(context, in)) {
            if (!param.getName().equals(propName)) continue;
            return true;
        }
        results.add(PARAM_NOT_FOUND_ERR, new Object[]{propName});
        return false;
    }
}

