/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.parser.model.v3;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import org.openapi4j.core.model.OAIContext;
import org.openapi4j.parser.model.v3.AbsExtendedRefOpenApiSchema;
import org.openapi4j.parser.model.v3.Operation;
import org.openapi4j.parser.model.v3.Parameter;
import org.openapi4j.parser.model.v3.ParameterUtil;
import org.openapi4j.parser.model.v3.Server;

public class Path
extends AbsExtendedRefOpenApiSchema<Path> {
    private String description;
    @JsonAlias(value={"get", "put", "post", "delete", "options", "head", "patch", "trace"})
    @JsonIgnore
    private Map<String, Operation> operations;
    private List<Parameter> parameters;
    private List<Server> servers;
    private String summary;

    public Operation getGet() {
        return this.mapGet(this.operations, "get");
    }

    public Path setGet(Operation get) {
        this.operations = this.mapPut(this.operations, "get", get);
        return this;
    }

    public Operation getPut() {
        return this.mapGet(this.operations, "put");
    }

    public Path setPut(Operation put) {
        this.operations = this.mapPut(this.operations, "put", put);
        return this;
    }

    public Operation getPost() {
        return this.mapGet(this.operations, "post");
    }

    public Path setPost(Operation post) {
        this.operations = this.mapPut(this.operations, "post", post);
        return this;
    }

    public Operation getDelete() {
        return this.mapGet(this.operations, "delete");
    }

    public Path setDelete(Operation delete) {
        this.operations = this.mapPut(this.operations, "delete", delete);
        return this;
    }

    public Operation getOptions() {
        return this.mapGet(this.operations, "options");
    }

    public Path setOptions(Operation options) {
        this.operations = this.mapPut(this.operations, "options", options);
        return this;
    }

    public Operation getHead() {
        return this.mapGet(this.operations, "head");
    }

    public Path setHead(Operation head) {
        this.operations = this.mapPut(this.operations, "head", head);
        return this;
    }

    public Operation getPatch() {
        return this.mapGet(this.operations, "patch");
    }

    public Path setPatch(Operation patch) {
        this.operations = this.mapPut(this.operations, "patch", patch);
        return this;
    }

    public Operation getTrace() {
        return this.mapGet(this.operations, "trace");
    }

    public Path setTrace(Operation trace) {
        this.operations = this.mapPut(this.operations, "trace", trace);
        return this;
    }

    public String getSummary() {
        return this.summary;
    }

    public Path setSummary(String summary) {
        this.summary = summary;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Path setDescription(String description) {
        this.description = description;
        return this;
    }

    public Map<String, Operation> getOperations() {
        return this.operations;
    }

    public Path setOperations(Map<String, Operation> operations) {
        this.operations = operations;
        return this;
    }

    public boolean hasOperation(String httpMethod) {
        return this.mapHas(this.operations, httpMethod);
    }

    public Operation getOperation(String httpMethod) {
        return this.mapGet(this.operations, httpMethod);
    }

    public Path setOperation(String httpMethod, Operation operation) {
        this.operations = this.mapPut(this.operations, httpMethod, operation);
        return this;
    }

    public Path removeOperation(String httpMethod) {
        this.mapRemove(this.operations, httpMethod);
        return this;
    }

    public List<Server> getServers() {
        return this.servers;
    }

    public Path setServers(List<Server> servers) {
        this.servers = servers;
        return this;
    }

    public boolean hasServers() {
        return this.servers != null;
    }

    public Path addServer(Server server) {
        this.servers = this.listAdd(this.servers, server);
        return this;
    }

    public Path insertServer(int index, Server server) {
        this.servers = this.listAdd(this.servers, index, server);
        return this;
    }

    public Path removeServer(Server value) {
        this.listRemove(this.servers, value);
        return this;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public Path setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    public boolean hasParameters() {
        return this.parameters != null;
    }

    public Path addParameter(Parameter parameter) {
        this.parameters = this.listAdd(this.parameters, parameter);
        return this;
    }

    public Path insertParameter(int index, Parameter parameter) {
        this.parameters = this.listAdd(this.parameters, index, parameter);
        return this;
    }

    public Path removeParameter(Parameter value) {
        this.listRemove(this.parameters, value);
        return this;
    }

    public List<Parameter> getParametersIn(OAIContext context, String in) {
        return ParameterUtil.getIn(context, this.parameters, in);
    }

    @Override
    public Path copy() {
        Path copy = new Path();
        if (this.isRef()) {
            copy.setRef(this.getRef());
            copy.setCanonicalRef(this.getCanonicalRef());
        } else {
            copy.setSummary(this.getSummary());
            copy.setDescription(this.getDescription());
            copy.setOperations(this.copyMap(this.getOperations()));
            copy.setServers(this.copyList(this.getServers()));
            copy.setParameters(this.copyList(this.getParameters()));
            copy.setExtensions(this.copySimpleMap(this.getExtensions()));
        }
        return copy;
    }
}

