/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.util;

import java.lang.reflect.Array;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.Converter;
import org.ocpsoft.rewrite.param.Validator;

public final class ValueHolderUtil {
    public static boolean validates(Rewrite event, EvaluationContext context, Validator<?> validator, Object value) {
        if (validator != null) {
            if (value != null && value.getClass().isArray()) {
                Object[] values = (Object[])value;
                for (int i = 0; i < values.length; ++i) {
                    if (validator.isValid(event, context, values[i])) continue;
                    return false;
                }
            } else {
                return validator.isValid(event, context, value);
            }
        }
        return true;
    }

    public static Object convert(Rewrite event, EvaluationContext context, Converter<?> converter, Object value) {
        if (converter != null) {
            if (value != null && value.getClass().isArray()) {
                Object[] values = (Object[])value;
                Object[] convertedValues = new Object[values.length];
                for (int i = 0; i < convertedValues.length; ++i) {
                    convertedValues[i] = converter.convert(event, context, values[i]);
                }
                Class type = Object.class;
                for (Object object : convertedValues) {
                    if (object == null) continue;
                    type = object.getClass();
                    break;
                }
                Object[] result = (Object[])Array.newInstance(type, convertedValues.length);
                System.arraycopy(convertedValues, 0, result, 0, result.length);
                return result;
            }
            return converter.convert(event, context, value);
        }
        return value;
    }
}

