/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.ocpsoft.common.util.Streams;
import org.ocpsoft.common.util.Strings;
import org.ocpsoft.rewrite.config.ConditionBuilder;
import org.ocpsoft.rewrite.config.OperationBuilder;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.exception.RewriteException;
import org.ocpsoft.rewrite.servlet.RewriteWrappedResponse;
import org.ocpsoft.rewrite.servlet.config.HttpCondition;
import org.ocpsoft.rewrite.servlet.config.HttpOperation;
import org.ocpsoft.rewrite.servlet.config.Lifecycle;
import org.ocpsoft.rewrite.servlet.config.response.GZipResponseContentInterceptor;
import org.ocpsoft.rewrite.servlet.config.response.GZipResponseStreamWrapper;
import org.ocpsoft.rewrite.servlet.config.response.ResponseContentInterceptor;
import org.ocpsoft.rewrite.servlet.config.response.ResponseStreamWrapper;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;

public abstract class Response
extends HttpOperation {
    public static OperationBuilder withOutputInterceptedBy(final ResponseContentInterceptor ... buffers) throws IllegalStateException {
        return new Response(){

            @Override
            public void performHttp(HttpServletRewrite event, EvaluationContext context) {
                for (ResponseContentInterceptor buffer : buffers) {
                    RewriteWrappedResponse.getCurrentInstance(event.getRequest()).addContentInterceptor(buffer);
                }
            }

            public String toString() {
                return "Response.withOutputInterceptedBy(" + Strings.join(Arrays.asList(buffers), ", ") + ")";
            }
        };
    }

    public static OperationBuilder withOutputStreamWrappedBy(final ResponseStreamWrapper ... wrappers) throws IllegalStateException {
        return new Response(){

            @Override
            public void performHttp(HttpServletRewrite event, EvaluationContext context) {
                for (ResponseStreamWrapper wrapper : wrappers) {
                    RewriteWrappedResponse.getCurrentInstance(event.getRequest()).addStreamWrapper(wrapper);
                }
            }

            public String toString() {
                return "Response.withOutputStreamWrappedBy(" + Strings.join(Arrays.asList(wrappers), ", ") + ")";
            }
        };
    }

    public static OperationBuilder addHeader(final String name, final String value) {
        return new Response(){

            @Override
            public void performHttp(HttpServletRewrite event, EvaluationContext context) {
                ((HttpServletResponse)event.getResponse()).addHeader(name, value);
            }

            public String toString() {
                return "Response.addHeader(\"" + name + "\", " + value + ")";
            }
        };
    }

    public static OperationBuilder addDateHeader(final String name, final long value) {
        return new Response(){

            @Override
            public void performHttp(HttpServletRewrite event, EvaluationContext context) {
                ((HttpServletResponse)event.getResponse()).addDateHeader(name, value);
            }

            public String toString() {
                return "Response.addDateHeader(\"" + name + "\", " + value + ")";
            }
        };
    }

    public static OperationBuilder setContentType(final String contentType) {
        return new Response(){

            @Override
            public void performHttp(HttpServletRewrite event, EvaluationContext context) {
                ((HttpServletResponse)event.getResponse()).setContentType(contentType);
            }

            public String toString() {
                return "Response.setContentType(\"" + contentType + "\")";
            }
        };
    }

    public static OperationBuilder addIntHeader(final String name, final int value) {
        return new Response(){

            @Override
            public void performHttp(HttpServletRewrite event, EvaluationContext context) {
                ((HttpServletResponse)event.getResponse()).addIntHeader(name, value);
            }

            public String toString() {
                return "Response.addIntHeader(\"" + name + "\", " + value + ")";
            }
        };
    }

    public static OperationBuilder addCookie(final Cookie cookie) {
        return new Response(){

            @Override
            public void performHttp(HttpServletRewrite event, EvaluationContext context) {
                ((HttpServletResponse)event.getResponse()).addCookie(cookie);
            }

            public String toString() {
                return "Response.addCookie(" + cookie + ")";
            }
        };
    }

    public static OperationBuilder gzipCompression() {
        return new Response(){

            @Override
            public void performHttp(HttpServletRewrite event, EvaluationContext context) {
                8.withOutputInterceptedBy(new GZipResponseContentInterceptor()).perform(event, context);
            }

            public String toString() {
                return "Response.gzipCompression()";
            }
        };
    }

    public static OperationBuilder gzipStreamCompression() {
        return new Response(){

            @Override
            public void performHttp(HttpServletRewrite event, EvaluationContext context) {
                9.withOutputStreamWrappedBy(new GZipResponseStreamWrapper()).perform(event, context);
            }

            public String toString() {
                return "Response.gzipCompression()";
            }
        };
    }

    public static OperationBuilder write(byte ... bytes) {
        return Response.write(new ByteArrayInputStream(bytes));
    }

    public static OperationBuilder write(final Object value) {
        return new Response(){

            @Override
            public void performHttp(HttpServletRewrite event, EvaluationContext context) {
                try {
                    if (value != null) {
                        ((HttpServletResponse)event.getResponse()).getWriter().write(value.toString());
                    }
                }
                catch (IOException e) {
                    throw new RewriteException("Could not write value [" + value + "] to response stream.", e);
                }
            }

            public String toString() {
                return "Response.write(\"" + value + "\")";
            }
        };
    }

    public static OperationBuilder write(final InputStream stream) {
        return new HttpOperation(){

            @Override
            public void performHttp(HttpServletRewrite event, EvaluationContext context) {
                try {
                    Streams.copy(stream, (OutputStream)((HttpServletResponse)event.getResponse()).getOutputStream());
                }
                catch (IOException e) {
                    throw new RewriteException("Could not write stream [" + stream + "] to response stream.", e);
                }
            }

            public String toString() {
                return "Response.write(" + stream + ")";
            }
        };
    }

    public static OperationBuilder setStatus(final int status) {
        return new HttpOperation(){

            @Override
            public void performHttp(HttpServletRewrite event, EvaluationContext context) {
                ((HttpServletResponse)event.getResponse()).setStatus(status);
            }

            public String toString() {
                return "Response.setStatus(" + status + ")";
            }
        };
    }

    public static OperationBuilder complete() {
        return Lifecycle.abort();
    }

    public static ConditionBuilder isCommitted() {
        return new HttpCondition(){

            @Override
            public boolean evaluateHttp(HttpServletRewrite event, EvaluationContext context) {
                return ((HttpServletResponse)event.getResponse()).isCommitted();
            }

            public String toString() {
                return "Response.isCommitted()";
            }
        };
    }
}

