/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.config;

import java.util.Arrays;
import java.util.List;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.ConditionBuilder;
import org.ocpsoft.rewrite.config.DefaultConditionBuilder;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;

public final class Conditions {
    public static final String NEGATION_COUNT_KEY = Conditions.class.getCanonicalName() + "_NotCount";

    public static boolean isNegated(EvaluationContext context) {
        return Conditions.getNegationCount(context) % 2 == 1;
    }

    public static int getNegationCount(EvaluationContext context) {
        if (context == null) {
            return 0;
        }
        Integer count = (Integer)context.get(NEGATION_COUNT_KEY);
        return count == null ? 0 : count;
    }

    static void incrementNegationCount(EvaluationContext context, int adjustment) {
        if (context == null) {
            return;
        }
        Integer count = Conditions.getNegationCount(context);
        count = count + adjustment;
        context.put(NEGATION_COUNT_KEY, count);
    }

    public static ConditionBuilder create() {
        return new DefaultConditionBuilder(){

            @Override
            public boolean evaluate(Rewrite event, EvaluationContext context) {
                return true;
            }

            public String toString() {
                return "";
            }
        };
    }

    public static ConditionBuilder wrap(final Condition condition) {
        if (condition == null) {
            return Conditions.create();
        }
        if (condition instanceof ConditionBuilder) {
            return (ConditionBuilder)condition;
        }
        return new DefaultConditionBuilder.DefaultConditionBuilderInternal(new Condition[]{condition}){

            @Override
            public boolean evaluate(Rewrite event, EvaluationContext context) {
                return condition.evaluate(event, context);
            }

            public String toString() {
                return condition.toString();
            }

            @Override
            public List<Condition> getConditions() {
                return Arrays.asList(condition);
            }
        };
    }
}

