/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.keymap;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.netbeans.modules.options.keymap.Utils;

public class ShortcutListener
implements KeyListener {
    private JTextField textField;
    private boolean enterConfirms;
    private KeyStroke backspaceKS = KeyStroke.getKeyStroke(8, 0);
    private KeyStroke enterKS = KeyStroke.getKeyStroke(10, 0);
    private String key = "";

    public ShortcutListener(boolean enterConfirms) {
        this.enterConfirms = enterConfirms;
    }

    public void clear() {
        this.key = "";
    }

    @Override
    public void keyTyped(KeyEvent e) {
        e.consume();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        boolean add;
        assert (e.getSource() instanceof JTextField);
        if (e.getKeyCode() == 40 || e.getKeyCode() == 38 || e.getKeyCode() == 27) {
            return;
        }
        this.textField = (JTextField)e.getSource();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(e.getKeyCode(), e.getModifiers());
        boolean bl = add = e.getKeyCode() != 16 && e.getKeyCode() != 17 && e.getKeyCode() != 18 && e.getKeyCode() != 157 && e.getKeyCode() != 65406;
        if (!this.enterConfirms || !keyStroke.equals(this.enterKS)) {
            if (keyStroke.equals(this.backspaceKS) && !this.key.equals("")) {
                int i = this.key.lastIndexOf(32);
                this.key = i < 0 ? "" : this.key.substring(0, i);
                this.textField.setText(this.key);
            } else {
                this.addKeyStroke(keyStroke, add);
            }
            e.consume();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        e.consume();
    }

    private void addKeyStroke(KeyStroke keyStroke, boolean add) {
        String k = Utils.getKeyStrokeAsText(keyStroke);
        if (this.key.equals("")) {
            this.textField.setText(k);
            if (add) {
                this.key = k;
            }
        } else {
            this.textField.setText(this.key + " " + k);
            if (add) {
                this.key = this.key + " " + k;
            }
        }
    }
}

