/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.openide.util.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EditableProperties
extends AbstractMap<String, String>
implements Cloneable {
    private State state;
    private final boolean alphabetize;
    private static final String INDENT = "    ";
    private static final int WAITING_FOR_KEY_VALUE = 1;
    private static final int READING_KEY_VALUE = 2;

    public EditableProperties(boolean bl) {
        this.alphabetize = bl;
        this.state = new State();
    }

    private EditableProperties(EditableProperties editableProperties) {
        this.alphabetize = editableProperties.alphabetize;
        this.state = editableProperties.state;
        this.state.shared = true;
    }

    private void writeOperation() {
        if (this.state.shared) {
            this.state = new State(this.state);
        }
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return new SetImpl();
    }

    public void load(InputStream inputStream) throws IOException {
        String string;
        int n = 1;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "ISO-8859-1"));
        LinkedList<String> linkedList = new LinkedList<String>();
        int n2 = 0;
        while (null != (string = bufferedReader.readLine())) {
            linkedList.add(string);
            boolean bl = EditableProperties.isEmpty(string);
            boolean bl2 = EditableProperties.isComment(string);
            if (n == 1) {
                if (bl) {
                    this.createNonKeyItem(linkedList);
                    n2 = 0;
                } else if (bl2) {
                    ++n2;
                } else {
                    n = 2;
                }
            }
            if (n != 2 || this.isContinue(string)) continue;
            this.createKeyItem(linkedList, n2);
            n = 1;
            n2 = 0;
        }
        if (linkedList.size() > 0) {
            if (n == 2) {
                this.createKeyItem(linkedList, n2);
            } else {
                this.createNonKeyItem(linkedList);
            }
        }
    }

    public void store(OutputStream outputStream) throws IOException {
        boolean bl = true;
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, "ISO-8859-1"));
        for (Item item : this.state.items) {
            if (item.isSeparate() && !bl) {
                bufferedWriter.newLine();
            }
            String string2 = null;
            for (String string2 : item.getRawData()) {
                bufferedWriter.write(string2);
                bufferedWriter.newLine();
            }
            if (string2 == null) continue;
            bl = EditableProperties.isEmpty(string2);
        }
        bufferedWriter.flush();
    }

    @Override
    public String get(Object object) {
        if (!(object instanceof String)) {
            return null;
        }
        Item item = this.state.itemIndex.get((String)object);
        return item != null ? item.getValue() : null;
    }

    @Override
    public String put(String string, String string2) {
        Parameters.notNull("key", string);
        Parameters.notNull(string, string2);
        this.writeOperation();
        Item item = this.state.itemIndex.get(string);
        String string3 = null;
        if (item != null) {
            string3 = item.getValue();
            item.setValue(string2);
        } else {
            item = new Item(string, string2);
            this.addItem(item, this.alphabetize);
        }
        return string3;
    }

    public String getProperty(String string) {
        return this.get(string);
    }

    public String setProperty(String string, String string2) {
        return this.put(string, string2);
    }

    public String setProperty(String string, String[] stringArray) {
        String string2 = this.get(string);
        if (string == null || stringArray == null) {
            throw new NullPointerException();
        }
        List<String> list = Arrays.asList(stringArray);
        this.writeOperation();
        Item item = this.state.itemIndex.get(string);
        if (item != null) {
            item.setValue(list);
        } else {
            this.addItem(new Item(string, list), this.alphabetize);
        }
        return string2;
    }

    public String[] getComment(String string) {
        Item item = this.state.itemIndex.get(string);
        if (item == null) {
            return new String[0];
        }
        return item.getComment();
    }

    public void setComment(String string, String[] stringArray, boolean bl) {
        this.writeOperation();
        Item item = this.state.itemIndex.get(string);
        if (item == null) {
            throw new IllegalArgumentException("Cannot set comment for non-existing property " + string);
        }
        item.setComment(stringArray, bl);
    }

    @Override
    public Object clone() {
        return this.cloneProperties();
    }

    public EditableProperties cloneProperties() {
        return new EditableProperties(this);
    }

    private void createNonKeyItem(List<String> list) {
        Item item;
        this.writeOperation();
        if (!this.state.items.isEmpty() && (item = this.state.items.getLast()).getKey() == null) {
            item.addCommentLines(list);
            list.clear();
            return;
        }
        item = new Item(list);
        this.addItem(item, false);
        list.clear();
    }

    private void createKeyItem(List<String> list, int n) {
        Item item = new Item(list.subList(0, n), list.subList(n, list.size()));
        this.addItem(item, false);
        list.clear();
    }

    private void addItem(Item item, boolean bl) {
        this.writeOperation();
        String string = item.getKey();
        if (bl) {
            assert (string != null);
            ListIterator<Item> listIterator = this.state.items.listIterator();
            while (listIterator.hasNext()) {
                String string2 = ((Item)listIterator.next()).getKey();
                if (string2 == null || string2.compareToIgnoreCase(string) <= 0) continue;
                listIterator.previous();
                listIterator.add(item);
                this.state.itemIndex.put(string, item);
                return;
            }
        }
        this.state.items.add(item);
        if (string != null) {
            this.state.itemIndex.put(string, item);
        }
    }

    private boolean isContinue(String string) {
        int n = 0;
        for (int i = string.length() - 1; i >= 0 && string.charAt(i) == '\\'; --i) {
            ++n;
        }
        return n % 2 != 0;
    }

    private static boolean isComment(String string) {
        if ((string = EditableProperties.trimLeft(string)).length() > 0) {
            switch (string.charAt(0)) {
                case '!': 
                case '#': {
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isEmpty(String string) {
        return EditableProperties.trimLeft(string).length() == 0;
    }

    private static String trimLeft(String string) {
        int n;
        int n2 = string.length();
        block3: for (n = 0; n < n2; ++n) {
            switch (string.charAt(n)) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
            }
            break;
        }
        return string.substring(n);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapEntryImpl
    implements Map.Entry<String, String> {
        private Item item;

        public MapEntryImpl(Item item) {
            this.item = item;
        }

        @Override
        public String getKey() {
            return this.item.getKey();
        }

        @Override
        public String getValue() {
            return this.item.getValue();
        }

        @Override
        public String setValue(String string) {
            EditableProperties.this.writeOperation();
            this.item = ((EditableProperties)EditableProperties.this).state.itemIndex.get(this.item.getKey());
            String string2 = this.item.getValue();
            this.item.setValue(string);
            return string2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IteratorImpl
    implements Iterator<Map.Entry<String, String>> {
        private ListIterator<Item> delegate;

        public IteratorImpl() {
            this.delegate = ((EditableProperties)EditableProperties.this).state.items.listIterator();
        }

        @Override
        public boolean hasNext() {
            return this.findNext() != null;
        }

        @Override
        public Map.Entry<String, String> next() {
            Item item = this.findNext();
            if (item == null) {
                throw new NoSuchElementException();
            }
            this.delegate.next();
            return new MapEntryImpl(item);
        }

        @Override
        public void remove() {
            this.delegate.previous();
            Item item = this.findNext();
            if (item == null) {
                throw new IllegalStateException();
            }
            int n = this.delegate.nextIndex();
            EditableProperties.this.writeOperation();
            Item item2 = ((EditableProperties)EditableProperties.this).state.items.remove(n);
            assert (item2.getKey().equals(item.getKey()));
            ((EditableProperties)EditableProperties.this).state.itemIndex.remove(item.getKey());
            this.delegate = ((EditableProperties)EditableProperties.this).state.items.listIterator(n);
        }

        private Item findNext() {
            while (this.delegate.hasNext()) {
                Item item = this.delegate.next();
                if (item.getKey() == null || item.getValue() == null) continue;
                this.delegate.previous();
                return item;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SetImpl
    extends AbstractSet<Map.Entry<String, String>> {
        @Override
        public Iterator<Map.Entry<String, String>> iterator() {
            return new IteratorImpl();
        }

        @Override
        public int size() {
            return ((EditableProperties)EditableProperties.this).state.items.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Item
    implements Cloneable {
        private List<String> commentLines;
        private List<String> keyValueLines;
        private String key;
        private String value;
        private boolean separate;

        private Item() {
        }

        public Item(List<String> list) {
            this.commentLines = new ArrayList<String>(list);
        }

        public Item(List<String> list, List<String> list2) {
            this.commentLines = new ArrayList<String>(list);
            this.keyValueLines = new ArrayList<String>(list2);
            this.parse(list2);
        }

        public Item(String string, String string2) {
            this.key = string;
            this.value = string2;
        }

        public Item(String string, List<String> list) {
            this.key = string;
            this.setValue(list);
        }

        void addCommentLines(List<String> list) {
            assert (this.key == null);
            this.commentLines.addAll(list);
        }

        public String[] getComment() {
            String[] stringArray = new String[this.commentLines.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = Item.decodeUnicode(this.commentLines.get(i));
            }
            return stringArray;
        }

        public void setComment(String[] stringArray, boolean bl) {
            this.separate = bl;
            this.commentLines = new ArrayList<String>(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                this.commentLines.add(Item.encodeUnicode(stringArray[i]));
            }
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String string) {
            this.value = string;
            this.keyValueLines = null;
        }

        public void setValue(List<String> list) {
            StringBuilder stringBuilder = new StringBuilder();
            ArrayList<String> arrayList = new ArrayList<String>();
            if (!list.isEmpty()) {
                arrayList.add(Item.encode(this.key, true) + "=\\");
                Iterator<String> iterator = list.iterator();
                while (iterator.hasNext()) {
                    String string = iterator.next();
                    stringBuilder.append(string);
                    string = Item.encode(string, false);
                    arrayList.add(iterator.hasNext() ? EditableProperties.INDENT + string + '\\' : EditableProperties.INDENT + string);
                }
            } else {
                arrayList.add(Item.encode(this.key, true) + '=');
            }
            this.value = stringBuilder.toString();
            this.keyValueLines = arrayList;
        }

        public boolean isSeparate() {
            return this.separate;
        }

        public List<String> getRawData() {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (this.commentLines != null) {
                arrayList.addAll(this.commentLines);
            }
            if (this.keyValueLines == null) {
                this.keyValueLines = new ArrayList<String>();
                if (this.key != null && this.value != null) {
                    this.keyValueLines.add(Item.encode(this.key, true) + "=" + Item.encode(this.value, false));
                }
            }
            arrayList.addAll(this.keyValueLines);
            return arrayList;
        }

        private void parse(List<String> list) {
            String string = Item.mergeLines(list);
            this.splitKeyValue(string);
        }

        private static String mergeLines(List<String> list) {
            if (list.size() == 1) {
                return EditableProperties.trimLeft(list.get(0));
            }
            StringBuilder stringBuilder = new StringBuilder();
            Iterator<String> iterator = list.iterator();
            while (iterator.hasNext()) {
                String string = EditableProperties.trimLeft(iterator.next());
                if (iterator.hasNext()) {
                    assert (string.endsWith("\\")) : list;
                    string = string.substring(0, string.length() - 1);
                }
                stringBuilder.append(string);
            }
            return stringBuilder.toString();
        }

        private void splitKeyValue(String string) {
            int n;
            int n2 = string.length();
            block6: for (n = 0; n < n2; ++n) {
                char c = string.charAt(n);
                if (c == '\\') {
                    ++n;
                    continue;
                }
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': 
                    case ':': 
                    case '=': {
                        break block6;
                    }
                    default: {
                        continue block6;
                    }
                }
            }
            this.key = Item.decode(string.substring(0, n));
            if ((string = EditableProperties.trimLeft(string.substring(n))).length() == 0) {
                this.value = "";
                return;
            }
            switch (string.charAt(0)) {
                case ':': 
                case '=': {
                    string = EditableProperties.trimLeft(string.substring(1));
                }
            }
            this.value = Item.decode(string);
        }

        private static String decode(String string) {
            if (string.indexOf(92) == -1) {
                return string;
            }
            int n = string.length();
            StringBuilder stringBuilder = new StringBuilder(n);
            for (int i = 0; i < n; ++i) {
                int n2 = string.charAt(i);
                if (n2 != 92) {
                    stringBuilder.append((char)n2);
                    continue;
                }
                if (++i == n) continue;
                n2 = string.charAt(i);
                if (n2 == 117) {
                    if (i + 5 > n) {
                        stringBuilder.append(string.substring(i - 1));
                        i += 4;
                        continue;
                    }
                    String string2 = string.substring(i + 1, i + 5);
                    try {
                        stringBuilder.append((char)Integer.parseInt(string2, 16));
                    }
                    catch (NumberFormatException numberFormatException) {
                        stringBuilder.append(string.substring(i - 1, i + 5));
                    }
                    i += 4;
                    continue;
                }
                if (n2 == 116) {
                    n2 = 9;
                } else if (n2 == 114) {
                    n2 = 13;
                } else if (n2 == 110) {
                    n2 = 10;
                } else if (n2 == 102) {
                    n2 = 12;
                }
                stringBuilder.append((char)n2);
            }
            return stringBuilder.toString();
        }

        private static String encode(String string, boolean bl) {
            int n = string.length();
            StringBuilder stringBuilder = new StringBuilder(n * 2);
            block10: for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case ' ': {
                        if (i == 0 || bl) {
                            stringBuilder.append('\\');
                        }
                        stringBuilder.append(c);
                        continue block10;
                    }
                    case '#': {
                        if (i == 0) {
                            stringBuilder.append('\\');
                        }
                        stringBuilder.append(c);
                        continue block10;
                    }
                    case '\\': {
                        stringBuilder.append("\\\\");
                        continue block10;
                    }
                    case '\t': {
                        stringBuilder.append("\\t");
                        continue block10;
                    }
                    case '\n': {
                        stringBuilder.append("\\n");
                        continue block10;
                    }
                    case '\r': {
                        stringBuilder.append("\\r");
                        continue block10;
                    }
                    case '\f': {
                        stringBuilder.append("\\f");
                        continue block10;
                    }
                    case ':': 
                    case '=': {
                        if (bl) {
                            stringBuilder.append('\\');
                        }
                        stringBuilder.append(c);
                        continue block10;
                    }
                    default: {
                        if (c < ' ' || c > '~') {
                            stringBuilder.append("\\u");
                            String string2 = Integer.toHexString(c);
                            for (int j = 0; j < 4 - string2.length(); ++j) {
                                stringBuilder.append('0');
                            }
                            stringBuilder.append(string2);
                            continue block10;
                        }
                        stringBuilder.append(c);
                    }
                }
            }
            return stringBuilder.toString();
        }

        private static String decodeUnicode(String string) {
            int n = string.length();
            StringBuilder stringBuilder = new StringBuilder(n);
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c != '\\') {
                    stringBuilder.append(c);
                    continue;
                }
                if (++i == n) continue;
                c = string.charAt(i);
                if (c == 'u') {
                    if (i + 5 > n) {
                        stringBuilder.append(string.substring(i - 1));
                        i += 4;
                        continue;
                    }
                    String string2 = string.substring(i + 1, i + 5);
                    try {
                        stringBuilder.append((char)Integer.parseInt(string2, 16));
                    }
                    catch (NumberFormatException numberFormatException) {
                        stringBuilder.append(string.substring(i - 1, i + 5));
                    }
                    i += 4;
                    continue;
                }
                stringBuilder.append(c);
            }
            return stringBuilder.toString();
        }

        private static String encodeUnicode(String string) {
            int n = string.length();
            StringBuilder stringBuilder = new StringBuilder(n * 2);
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c < ' ' || c > '~') {
                    stringBuilder.append("\\u");
                    String string2 = Integer.toHexString(c);
                    for (int j = 0; j < 4 - string2.length(); ++j) {
                        stringBuilder.append('0');
                    }
                    stringBuilder.append(string2);
                    continue;
                }
                stringBuilder.append(c);
            }
            return stringBuilder.toString();
        }

        public Object clone() {
            Item item = new Item();
            if (this.keyValueLines != null) {
                item.keyValueLines = new ArrayList<String>(this.keyValueLines);
            }
            if (this.commentLines != null) {
                item.commentLines = new ArrayList<String>(this.commentLines);
            }
            item.key = this.key;
            item.value = this.value;
            item.separate = this.separate;
            return item;
        }
    }

    private static class State {
        boolean shared;
        final LinkedList<Item> items = new LinkedList();
        final Map<String, Item> itemIndex;

        State() {
            this.itemIndex = new HashMap<String, Item>();
        }

        State(State state) {
            this.itemIndex = new HashMap<String, Item>(state.items.size() * 4 / 3 + 1);
            for (Item item : state.items) {
                Item item2 = (Item)item.clone();
                this.items.add(item2);
                this.itemIndex.put(item2.getKey(), item2);
            }
        }
    }
}

