/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup.implspi;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ActiveQueue {
    private static final Logger LOGGER = Logger.getLogger(ActiveQueue.class.getName());
    private static final ReferenceQueue<Impl> ACTIVE = new ReferenceQueue();
    private static Reference<Impl> activeReferenceQueue = new WeakReference<Object>(null);

    private ActiveQueue() {
    }

    public static synchronized ReferenceQueue<Object> queue() {
        Impl impl = activeReferenceQueue.get();
        if (impl == null) {
            impl = new Impl();
            activeReferenceQueue = new WeakReference<Impl>(impl, ACTIVE);
            Daemon.ping();
        }
        return impl;
    }

    private static <T extends Throwable> T reportError(T ex) throws IllegalStateException {
        LOGGER.log(Level.WARNING, "Cannot hack ReferenceQueue to fix bug #206621!", ex);
        return ex;
    }

    private static final class Daemon
    extends Thread {
        private static Daemon running;

        public Daemon() {
            super("Active Reference Queue Daemon");
        }

        static synchronized void ping() {
            if (running == null) {
                Daemon t = new Daemon();
                t.setPriority(1);
                t.setDaemon(true);
                t.start();
                LOGGER.fine("starting thread");
                running = t;
            }
        }

        static synchronized boolean isActive() {
            return running != null;
        }

        static synchronized void wakeUp() {
            if (running != null) {
                running.interrupt();
            }
        }

        static synchronized Impl obtainQueue() {
            Impl impl = (Impl)activeReferenceQueue.get();
            if (impl == null) {
                running = null;
            }
            return impl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) lbl-1000:
                    // 6 sources

                    {
                        if ((impl = Daemon.obtainQueue()) == null) {
                            return;
                        }
                        var3_4 = impl.lock();
                        synchronized (var3_4) {
                            ref = impl.pollSuper();
                            impl = null;
                            if (ref == null) {
                                ActiveQueue.access$100().remove(0x7FFFFFFFL);
                                continue;
                            }
                        }
                        ActiveQueue.access$200().finer("dequeued reference");
                        if (!(ref instanceof Runnable)) {
                            ActiveQueue.access$200().log(Level.WARNING, "A reference not implementing runnable has been added to the Utilities.activeReferenceQueue(): {0}", ref.getClass());
                            continue;
                        }
                        try {
                            ((Runnable)ref).run();
                        }
                        catch (ThreadDeath td) {
                            throw td;
                        }
                        catch (Throwable t) {
                            ActiveQueue.access$200().log(Level.WARNING, "Cannot process " + ref, t);
                        }
                        finally {
                            ref = null;
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException ex) {
                    continue;
                }
                ** GOTO lbl-1000
                break;
            }
        }
    }

    private static final class Impl
    extends ReferenceQueue<Object> {
        private static final Field LOCK;
        private final Object myLock;

        Impl() {
            Object l = this;
            try {
                if (LOCK != null) {
                    l = LOCK.get(ACTIVE);
                    LOCK.set(this, l);
                }
            }
            catch (IllegalArgumentException ex) {
                ActiveQueue.reportError(ex);
            }
            catch (IllegalAccessException ex) {
                ActiveQueue.reportError(ex);
            }
            this.myLock = l;
        }

        @Override
        public Reference<Object> poll() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Reference<Object> remove(long timeout) throws IllegalArgumentException, InterruptedException {
            throw new InterruptedException();
        }

        @Override
        public Reference<Object> remove() throws InterruptedException {
            throw new InterruptedException();
        }

        final Object lock() {
            return this.myLock;
        }

        final Reference<? extends Object> pollSuper() throws IllegalArgumentException, InterruptedException {
            return super.poll();
        }

        static {
            Field f = null;
            try {
                f = ReferenceQueue.class.getDeclaredField("lock");
                f.setAccessible(true);
            }
            catch (NoSuchFieldException ex) {
                ActiveQueue.reportError(ex);
            }
            catch (SecurityException ex) {
                ActiveQueue.reportError(ex);
            }
            LOCK = f;
        }
    }
}

