/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems.annotations;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import javax.tools.StandardLocation;
import org.openide.filesystems.annotations.LayerGenerationException;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class LayerBuilder {
    private final Document doc;
    private final Element originatingElement;
    private final ProcessingEnvironment processingEnv;
    private final List<File> unwrittenFiles = new LinkedList<File>();

    LayerBuilder(Document document, Element originatingElement, ProcessingEnvironment processingEnv) {
        this.doc = document;
        this.originatingElement = originatingElement;
        this.processingEnv = processingEnv;
    }

    public File file(String path) {
        File f = new File(path, false);
        this.unwrittenFiles.add(f);
        return f;
    }

    public File folder(String path) {
        File f = new File(path, true);
        this.unwrittenFiles.add(f);
        return f;
    }

    void close() {
        for (File f : this.unwrittenFiles) {
            if (f.getPath().startsWith("dummy/")) continue;
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "layer file " + f.getPath() + " was never written");
        }
        this.unwrittenFiles.clear();
    }

    public File instanceFile(String path, String name, Class type) throws IllegalArgumentException, LayerGenerationException {
        String basename;
        String[] clazzOrMethod = this.instantiableClassOrMethod(type);
        String clazz = clazzOrMethod[0];
        String method = clazzOrMethod[1];
        if (name == null) {
            basename = clazz.replace('.', '-');
            if (method != null) {
                basename = basename + "-" + method;
            }
        } else {
            basename = name;
        }
        File f = this.file(path + "/" + basename + ".instance");
        if (method != null) {
            f.methodvalue("instanceCreate", clazz, method);
        } else if (name != null) {
            f.stringvalue("instanceClass", clazz);
        }
        return f;
    }

    public File instanceFile(String path, String name) throws IllegalArgumentException, LayerGenerationException {
        String basename;
        String[] clazzOrMethod = this.instantiableClassOrMethod(null);
        String clazz = clazzOrMethod[0];
        String method = clazzOrMethod[1];
        if (name == null) {
            basename = clazz.replace('.', '-');
            if (method != null) {
                basename = basename + "-" + method;
            }
        } else {
            basename = name;
        }
        return this.file(path + "/" + basename + ".instance");
    }

    private String[] instantiableClassOrMethod(Class type) throws IllegalArgumentException, LayerGenerationException {
        if (this.originatingElement == null) {
            throw new IllegalArgumentException("Only applicable to builders with exactly one associated element");
        }
        DeclaredType typeMirror = type != null ? this.processingEnv.getTypeUtils().getDeclaredType(this.processingEnv.getElementUtils().getTypeElement(type.getName().replace('$', '.')), new TypeMirror[0]) : null;
        switch (this.originatingElement.getKind()) {
            case CLASS: {
                String clazz = this.processingEnv.getElementUtils().getBinaryName((TypeElement)this.originatingElement).toString();
                if (this.originatingElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                    throw new LayerGenerationException(clazz + " must not be abstract", this.originatingElement);
                }
                boolean hasDefaultCtor = false;
                for (ExecutableElement constructor : ElementFilter.constructorsIn(this.originatingElement.getEnclosedElements())) {
                    if (!constructor.getParameters().isEmpty()) continue;
                    hasDefaultCtor = true;
                    break;
                }
                if (!hasDefaultCtor) {
                    throw new LayerGenerationException(clazz + " must have a no-argument constructor", this.originatingElement);
                }
                if (typeMirror != null && !this.processingEnv.getTypeUtils().isAssignable(this.originatingElement.asType(), typeMirror)) {
                    throw new LayerGenerationException(clazz + " is not assignable to " + typeMirror, this.originatingElement);
                }
                if (!this.originatingElement.getModifiers().contains((Object)Modifier.PUBLIC)) {
                    throw new LayerGenerationException(clazz + " is not public", this.originatingElement);
                }
                return new String[]{clazz, null};
            }
            case METHOD: {
                String clazz = this.processingEnv.getElementUtils().getBinaryName((TypeElement)this.originatingElement.getEnclosingElement()).toString();
                String method = this.originatingElement.getSimpleName().toString();
                if (!this.originatingElement.getModifiers().contains((Object)Modifier.STATIC)) {
                    throw new LayerGenerationException(clazz + "." + method + " must be static", this.originatingElement);
                }
                if (!((ExecutableElement)this.originatingElement).getParameters().isEmpty()) {
                    throw new LayerGenerationException(clazz + "." + method + " must not take arguments", this.originatingElement);
                }
                if (typeMirror != null && !this.processingEnv.getTypeUtils().isAssignable(((ExecutableElement)this.originatingElement).getReturnType(), typeMirror)) {
                    throw new LayerGenerationException(clazz + "." + method + " is not assignable to " + typeMirror, this.originatingElement);
                }
                return new String[]{clazz, method};
            }
        }
        throw new IllegalArgumentException("Annotated element is not loadable as an instance: " + this.originatingElement);
    }

    public File shadowFile(String target, String folder, String name) {
        if (name == null) {
            name = target.replaceFirst("^.+/", "").replaceFirst("\\.[^./]+$", "");
        }
        return this.file(folder + "/" + name + ".shadow").stringvalue("originalFile", target);
    }

    public final class File {
        private final String path;
        private final boolean folder;
        private final Map<String, String[]> attrs = new LinkedHashMap<String, String[]>();
        private String contents;
        private String url;

        File(String path, boolean folder) {
            this.path = path;
            this.folder = folder;
        }

        public String getPath() {
            return this.path;
        }

        public File contents(String contents) {
            if (this.contents != null || this.url != null || contents == null || this.folder) {
                throw new IllegalArgumentException();
            }
            this.contents = contents;
            return this;
        }

        public File url(String url) {
            if (this.contents != null || this.url != null || url == null || this.folder) {
                throw new IllegalArgumentException();
            }
            this.url = url;
            return this;
        }

        public File stringvalue(String attr, String value) {
            this.attrs.put(attr, new String[]{"stringvalue", value});
            return this;
        }

        public File bytevalue(String attr, byte value) {
            this.attrs.put(attr, new String[]{"bytevalue", Byte.toString(value)});
            return this;
        }

        public File shortvalue(String attr, short value) {
            this.attrs.put(attr, new String[]{"shortvalue", Short.toString(value)});
            return this;
        }

        public File intvalue(String attr, int value) {
            this.attrs.put(attr, new String[]{"intvalue", Integer.toString(value)});
            return this;
        }

        public File longvalue(String attr, long value) {
            this.attrs.put(attr, new String[]{"longvalue", Long.toString(value)});
            return this;
        }

        public File floatvalue(String attr, float value) {
            this.attrs.put(attr, new String[]{"floatvalue", Float.toString(value)});
            return this;
        }

        public File doublevalue(String attr, double value) {
            this.attrs.put(attr, new String[]{"doublevalue", Double.toString(value)});
            return this;
        }

        public File boolvalue(String attr, boolean value) {
            this.attrs.put(attr, new String[]{"boolvalue", Boolean.toString(value)});
            return this;
        }

        public File charvalue(String attr, char value) {
            this.attrs.put(attr, new String[]{"charvalue", Character.toString(value)});
            return this;
        }

        public File urlvalue(String attr, URI value) throws LayerGenerationException {
            if (value.isOpaque()) {
                throw new LayerGenerationException("Cannot use an opaque URI: " + value, LayerBuilder.this.originatingElement);
            }
            this.attrs.put(attr, new String[]{"urlvalue", value.toString()});
            return this;
        }

        public File urlvalue(String attr, String value) throws LayerGenerationException {
            try {
                return this.urlvalue(attr, URI.create(value));
            }
            catch (IllegalArgumentException x) {
                throw new LayerGenerationException(x.getLocalizedMessage(), LayerBuilder.this.originatingElement);
            }
        }

        public File methodvalue(String attr, String clazz, String method) {
            this.attrs.put(attr, new String[]{"methodvalue", clazz + "." + method});
            return this;
        }

        public File newvalue(String attr, String clazz) {
            this.attrs.put(attr, new String[]{"newvalue", clazz});
            return this;
        }

        public File instanceAttribute(String attr, Class type) throws IllegalArgumentException, LayerGenerationException {
            String[] clazzOrMethod = LayerBuilder.this.instantiableClassOrMethod(type);
            if (clazzOrMethod[1] == null) {
                this.newvalue(attr, clazzOrMethod[0]);
            } else {
                this.methodvalue(attr, clazzOrMethod[0], clazzOrMethod[1]);
            }
            return this;
        }

        public File bundlevalue(String attr, String bundle, String key) {
            this.attrs.put(attr, new String[]{"bundlevalue", bundle + "#" + key});
            return this;
        }

        public File bundlevalue(String attr, String label) throws LayerGenerationException {
            String javaIdentifier = "(?:\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)";
            Matcher m = Pattern.compile("((?:" + javaIdentifier + "\\.)+[^\\s.#]+)?#(\\S*)").matcher(label);
            if (m.matches()) {
                String bundle = m.group(1);
                String key = m.group(2);
                if (bundle == null) {
                    Element referenceElement;
                    for (referenceElement = LayerBuilder.this.originatingElement; referenceElement != null && referenceElement.getKind() != ElementKind.PACKAGE; referenceElement = referenceElement.getEnclosingElement()) {
                    }
                    if (referenceElement == null) {
                        throw new LayerGenerationException("No reference element to determine package in '" + label + "'", LayerBuilder.this.originatingElement);
                    }
                    bundle = ((PackageElement)referenceElement).getQualifiedName() + ".Bundle";
                }
                this.verifyBundleKey(bundle, key, m.group(1) == null);
                this.bundlevalue(attr, bundle, key);
            } else {
                this.stringvalue(attr, label);
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void verifyBundleKey(String bundle, String key, boolean samePackage) throws LayerGenerationException {
            if (LayerBuilder.this.processingEnv == null) {
                return;
            }
            if (samePackage) {
                for (Element e = LayerBuilder.this.originatingElement; e != null; e = e.getEnclosingElement()) {
                    NbBundle.Messages m = e.getAnnotation(NbBundle.Messages.class);
                    if (m == null) continue;
                    for (String kv : m.value()) {
                        if (!kv.startsWith(key + "=")) continue;
                        return;
                    }
                }
            }
            String resource = bundle.replace('.', '/') + ".properties";
            try {
                InputStream is;
                try {
                    is = LayerBuilder.this.processingEnv.getFiler().getResource(StandardLocation.SOURCE_PATH, "", resource).openInputStream();
                }
                catch (FileNotFoundException x) {
                    try {
                        is = LayerBuilder.this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", resource).openInputStream();
                    }
                    catch (IOException x2) {
                        throw x;
                    }
                }
                try {
                    Properties p = new Properties();
                    p.load(is);
                    if (p.getProperty(key) == null) {
                        throw new LayerGenerationException("No key '" + key + "' found in " + resource, LayerBuilder.this.originatingElement);
                    }
                }
                finally {
                    is.close();
                }
            }
            catch (IOException x) {
                throw new LayerGenerationException("Could not open " + resource + ": " + x, LayerBuilder.this.originatingElement);
            }
        }

        public File serialvalue(String attr, byte[] data) {
            StringBuilder buf = new StringBuilder(data.length * 2);
            for (int n : data) {
                if (n >= 0 && n < 16) {
                    buf.append('0');
                }
                buf.append(Integer.toHexString(n < 0 ? n + 256 : n));
            }
            this.attrs.put(attr, new String[]{"serialvalue", buf.toString().toUpperCase(Locale.ENGLISH)});
            return this;
        }

        public File position(int position) {
            if (position != Integer.MAX_VALUE) {
                this.intvalue("position", position);
            }
            return this;
        }

        public LayerBuilder write() {
            LayerBuilder.this.unwrittenFiles.remove(this);
            org.w3c.dom.Element e = LayerBuilder.this.doc.getDocumentElement();
            String[] pieces = this.path.split("/");
            for (String piece : Arrays.asList(pieces).subList(0, pieces.length - 1)) {
                org.w3c.dom.Element kid = this.find(e, piece, "file|folder");
                if (kid != null) {
                    if (!kid.getNodeName().equals("folder")) {
                        throw new IllegalArgumentException(this.path);
                    }
                    e = kid;
                    continue;
                }
                e = (org.w3c.dom.Element)e.appendChild(LayerBuilder.this.doc.createElement("folder"));
                e.setAttribute("name", piece);
            }
            String piece = pieces[pieces.length - 1];
            org.w3c.dom.Element file = this.find(e, piece, "file|folder");
            if (this.folder) {
                if (file == null) {
                    file = (org.w3c.dom.Element)e.appendChild(LayerBuilder.this.doc.createElement("folder"));
                }
            } else {
                if (file != null) {
                    e.removeChild(file);
                }
                file = (org.w3c.dom.Element)e.appendChild(LayerBuilder.this.doc.createElement("file"));
            }
            file.setAttribute("name", piece);
            NodeList oldComments = file.getChildNodes();
            int i = 0;
            while (i < oldComments.getLength()) {
                Node node = oldComments.item(i);
                if (node.getNodeType() == 8) {
                    file.removeChild(node);
                    continue;
                }
                ++i;
            }
            if (LayerBuilder.this.originatingElement != null) {
                String name;
                switch (LayerBuilder.this.originatingElement.getKind()) {
                    case METHOD: 
                    case CONSTRUCTOR: 
                    case ENUM_CONSTANT: 
                    case FIELD: 
                    case INSTANCE_INIT: 
                    case STATIC_INIT: {
                        name = LayerBuilder.this.originatingElement.getEnclosingElement() + "." + LayerBuilder.this.originatingElement;
                        break;
                    }
                    default: {
                        name = LayerBuilder.this.originatingElement.toString();
                    }
                }
                file.appendChild(LayerBuilder.this.doc.createComment(name));
            }
            for (Map.Entry<String, String[]> entry : this.attrs.entrySet()) {
                org.w3c.dom.Element former = this.find(file, entry.getKey(), "attr");
                if (former != null) {
                    file.removeChild(former);
                }
                org.w3c.dom.Element attr = (org.w3c.dom.Element)file.appendChild(LayerBuilder.this.doc.createElement("attr"));
                attr.setAttribute("name", entry.getKey());
                attr.setAttribute(entry.getValue()[0], entry.getValue()[1]);
            }
            if (this.url != null) {
                file.setAttribute("url", this.url);
            } else if (this.contents != null) {
                file.appendChild(LayerBuilder.this.doc.createCDATASection(this.contents));
            }
            return LayerBuilder.this;
        }

        private org.w3c.dom.Element find(org.w3c.dom.Element parent, String name, String kindRx) {
            NodeList nl = parent.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                org.w3c.dom.Element e;
                Node item = nl.item(i);
                if (item.getNodeType() != 1 || !(e = (org.w3c.dom.Element)item).getAttribute("name").equals(name) || !e.getNodeName().matches(kindRx)) continue;
                return e;
            }
            return null;
        }
    }
}

