/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.project.libraries.support;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.project.libraries.DefaultLibraryImplementation;
import org.netbeans.modules.project.libraries.LibraryTypeRegistry;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.netbeans.spi.project.libraries.LibraryImplementation3;
import org.netbeans.spi.project.libraries.LibraryTypeProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.Parameters;
import org.openide.util.Utilities;

public final class LibrariesSupport {
    private LibrariesSupport() {
    }

    @NonNull
    public static LibraryImplementation3 createLibraryImplementation3(@NonNull String libraryType, String ... volumeTypes) {
        return new DefaultLibraryImplementation(libraryType, volumeTypes);
    }

    public static LibraryImplementation createLibraryImplementation(String libraryType, String[] volumeTypes) {
        return LibrariesSupport.createLibraryImplementation3(libraryType, volumeTypes);
    }

    public static LibraryTypeProvider getLibraryTypeProvider(String libraryType) {
        return LibraryTypeRegistry.getDefault().getLibraryTypeProvider(libraryType);
    }

    public static LibraryTypeProvider[] getLibraryTypeProviders() {
        return LibraryTypeRegistry.getDefault().getLibraryTypeProviders();
    }

    public static URI convertFilePathToURI(@NonNull String path) {
        Parameters.notNull((CharSequence)"path", (Object)path);
        try {
            File f = new File(path);
            if (f.isAbsolute()) {
                return Utilities.toURI((File)f);
            }
            return new URI(null, null, path.replace('\\', '/'), null);
        }
        catch (URISyntaxException ex) {
            IllegalArgumentException y = new IllegalArgumentException();
            y.initCause(ex);
            throw y;
        }
    }

    public static String convertURIToFilePath(URI uri) {
        if (uri.isAbsolute()) {
            return Utilities.toFile((URI)uri).getPath();
        }
        return uri.getPath().replace('/', File.separatorChar);
    }

    public static FileObject resolveLibraryEntryFileObject(URL libraryLocation, URI libraryEntry) {
        URI u = LibrariesSupport.resolveLibraryEntryURI(libraryLocation, libraryEntry);
        try {
            return URLMapper.findFileObject((URL)u.toURL());
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public static URI resolveLibraryEntryURI(URL libraryLocation, URI libraryEntry) {
        URI resolved;
        Parameters.notNull((CharSequence)"libraryEntry", (Object)libraryEntry);
        if (libraryEntry.isAbsolute()) {
            return libraryEntry;
        }
        if (libraryLocation == null) {
            throw new IllegalArgumentException("cannot resolve relative URL without library location");
        }
        if (!"file".equals(libraryLocation.getProtocol())) {
            throw new IllegalArgumentException("not file: protocol - " + libraryLocation.toExternalForm());
        }
        if (!libraryLocation.getPath().endsWith(".properties")) {
            throw new IllegalArgumentException("library location must be a file - " + libraryLocation.toExternalForm());
        }
        try {
            resolved = libraryLocation.toURI().resolve(libraryEntry);
        }
        catch (URISyntaxException x) {
            throw new AssertionError((Object)x);
        }
        if (libraryEntry.getPath().contains("!/")) {
            return URI.create("jar:" + resolved);
        }
        return resolved;
    }

    public static URI getArchiveFile(URI uri) {
        String u = uri.toString();
        int index = u.indexOf("!/");
        if (index != -1) {
            try {
                return new URI(u.substring(u.startsWith("jar:") ? 4 : 0, index));
            }
            catch (URISyntaxException e) {
                throw new AssertionError((Object)e);
            }
        }
        return null;
    }

    public static URI getArchiveRoot(URI uri) {
        assert (!uri.toString().contains("!/")) : uri;
        try {
            return new URI((uri.isAbsolute() ? "jar:" : "") + uri.toString() + "!/");
        }
        catch (URISyntaxException ex) {
            throw new AssertionError((Object)ex);
        }
    }
}

