/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.spi;

import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.impl.CurrentDocumentScheduler;
import org.netbeans.modules.parsing.impl.CursorSensitiveScheduler;
import org.netbeans.modules.parsing.impl.SchedulerAccessor;
import org.netbeans.modules.parsing.impl.SelectedNodesScheduler;
import org.netbeans.modules.parsing.impl.SourceAccessor;
import org.netbeans.modules.parsing.impl.SourceCache;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.parsing.spi.SourceModificationEvent;
import org.openide.util.RequestProcessor;

public abstract class Scheduler {
    public static final int DEFAULT_REPARSE_DELAY = 500;
    int reparseDelay = 500;
    private Source source;
    public static final Class<? extends Scheduler> CURSOR_SENSITIVE_TASK_SCHEDULER = CursorSensitiveScheduler.class;
    public static final Class<? extends Scheduler> EDITOR_SENSITIVE_TASK_SCHEDULER = CurrentDocumentScheduler.class;
    public static final Class<? extends Scheduler> SELECTED_NODES_SENSITIVE_TASK_SCHEDULER = SelectedNodesScheduler.class;
    private RequestProcessor requestProcessor;
    private RequestProcessor.Task task;

    protected final synchronized void schedule(SchedulerEvent event) {
        if (this.source != null) {
            this.schedule(this.source, event);
        }
    }

    protected final synchronized void schedule(final Source source, final SchedulerEvent event) {
        if (this.task != null) {
            this.task.cancel();
        }
        this.task = null;
        if (this.requestProcessor == null) {
            this.requestProcessor = new RequestProcessor();
        }
        if (this.source != source && this.source != null) {
            SourceCache cache = SourceAccessor.getINSTANCE().getCache(this.source);
            cache.unscheduleTasks(this.getClass());
        }
        if (source == null) {
            this.source = null;
            return;
        }
        this.source = source;
        this.task = this.requestProcessor.create(new Runnable(){

            @Override
            public void run() {
                SourceCache cache = SourceAccessor.getINSTANCE().getCache(source);
                SourceAccessor.getINSTANCE().setSchedulerEvent(source, Scheduler.this, event);
                cache.scheduleTasks(Scheduler.this.getClass());
            }
        });
        this.task.schedule(this.reparseDelay);
    }

    protected abstract SchedulerEvent createSchedulerEvent(SourceModificationEvent var1);

    static {
        SchedulerAccessor.set(new Accessor());
    }

    private static class Accessor
    extends SchedulerAccessor {
        private Accessor() {
        }

        @Override
        public SchedulerEvent createSchedulerEvent(Scheduler scheduler, SourceModificationEvent event) {
            return scheduler.createSchedulerEvent(event);
        }
    }
}

