/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source;

import com.sun.tools.javac.code.Symbol;
import java.awt.EventQueue;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.swing.text.ChangedCharSetException;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.JavadocForBinaryQuery;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.modules.java.source.indexing.JavaIndex;
import org.netbeans.modules.java.source.parsing.CachingArchiveProvider;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.parsing.lucene.support.Convertor;
import org.netbeans.modules.parsing.lucene.support.Convertors;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;

public class JavadocHelper {
    private static final Logger LOG = Logger.getLogger(JavadocHelper.class.getName());
    private static final RequestProcessor RP = new RequestProcessor(JavadocHelper.class.getName(), 1);
    private static final Map<Element, TextStream> cachedJavadoc = new WeakHashMap<Element, TextStream>();
    private static final String PACKAGE_SUMMARY = "package-summary";
    private static final Set<String> knownGoodRoots = Collections.synchronizedSet(new HashSet());

    private JavadocHelper() {
    }

    private static boolean isRemote(URL url) {
        return url.getProtocol().startsWith("http");
    }

    public static InputStream openStream(URL url) throws IOException {
        FileObject f;
        if (url.getProtocol().equals("jar") && (f = URLMapper.findFileObject((URL)url)) != null) {
            return f.getInputStream();
        }
        if (JavadocHelper.isRemote(url)) {
            LOG.log(Level.FINE, "opening network stream: {0}", url);
        }
        return url.openStream();
    }

    public static TextStream getJavadoc(Element element, @NullAllowed Callable<Boolean> cancel) {
        return JavadocHelper.getJavadoc(element, true, cancel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TextStream getJavadoc(Element element, boolean allowRemoteJavadoc, @NullAllowed Callable<Boolean> cancel) {
        Map<Element, TextStream> map = cachedJavadoc;
        synchronized (map) {
            TextStream result = cachedJavadoc.get(element);
            if (result != null) {
                LOG.log(Level.FINE, "cache hit on {0}", result.getLocation());
                return result;
            }
        }
        TextStream result = JavadocHelper.doGetJavadoc(element, allowRemoteJavadoc, cancel);
        Map<Element, TextStream> map2 = cachedJavadoc;
        synchronized (map2) {
            cachedJavadoc.put(element, result);
        }
        return result;
    }

    public static TextStream getJavadoc(Element element) {
        return JavadocHelper.getJavadoc(element, null);
    }

    @CheckForNull
    public static String getCharSet(ChangedCharSetException e) {
        String spec = e.getCharSetSpec();
        if (e.keyEqualsCharSet()) {
            return spec;
        }
        int index = spec.indexOf(";");
        if (index != -1) {
            spec = spec.substring(index + 1);
        }
        spec = spec.toLowerCase();
        StringTokenizer st = new StringTokenizer(spec, " \t=", true);
        boolean foundCharSet = false;
        boolean foundEquals = false;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals(" ") || token.equals("\t")) continue;
            if (!foundCharSet && !foundEquals && token.equals("charset")) {
                foundCharSet = true;
                continue;
            }
            if (!foundEquals && token.equals("=")) {
                foundEquals = true;
                continue;
            }
            if (foundEquals && foundCharSet) {
                return token;
            }
            foundCharSet = false;
            foundEquals = false;
        }
        return null;
    }

    @SuppressWarnings(value={"DMI_COLLECTION_OF_URLS"}, justification="URLs have never host part")
    private static TextStream doGetJavadoc(Element element, final boolean allowRemoteJavadoc, Callable<Boolean> cancel) {
        String pageName;
        String pkgName;
        if (element == null) {
            throw new IllegalArgumentException("Cannot pass null as an argument of the SourceUtils.getJavadoc");
        }
        Symbol.ClassSymbol clsSym = null;
        boolean buildFragment = false;
        if (element.getKind() == ElementKind.PACKAGE) {
            List<? extends Element> els = element.getEnclosedElements();
            for (Element element2 : els) {
                if (!element2.getKind().isClass() && !element2.getKind().isInterface()) continue;
                clsSym = (Symbol.ClassSymbol)element2;
                break;
            }
            if (clsSym == null) {
                return null;
            }
            pkgName = FileObjects.convertPackage2Folder(((PackageElement)element).getQualifiedName().toString());
            pageName = PACKAGE_SUMMARY;
        } else {
            Element e = element;
            StringBuilder sb = new StringBuilder();
            while (e.getKind() != ElementKind.PACKAGE) {
                if (e.getKind().isClass() || e.getKind().isInterface()) {
                    if (sb.length() > 0) {
                        sb.insert(0, '.');
                    }
                    sb.insert(0, e.getSimpleName());
                    if (clsSym == null) {
                        clsSym = (Symbol.ClassSymbol)e;
                    }
                }
                e = e.getEnclosingElement();
            }
            if (clsSym == null) {
                return null;
            }
            pkgName = FileObjects.convertPackage2Folder(((PackageElement)e).getQualifiedName().toString());
            pageName = sb.toString();
            boolean bl = buildFragment = element != clsSym;
        }
        if (clsSym.completer != null) {
            clsSym.complete();
        }
        if (clsSym.classfile != null) {
            try {
                Collection<Object> fragment;
                final URL classFile = clsSym.classfile.toUri().toURL();
                final String pkgNameF = pkgName;
                final String string = pageName;
                Collection<Object> collection = fragment = buildFragment ? JavadocHelper.getFragment(element) : Collections.emptySet();
                if (cancel == null) {
                    return JavadocHelper.findJavadoc(classFile, pkgName, string, fragment, allowRemoteJavadoc);
                }
                Future future = RP.submit((Callable)new Callable<TextStream>(){

                    @Override
                    public TextStream call() throws Exception {
                        return JavadocHelper.findJavadoc(classFile, pkgNameF, string, fragment, allowRemoteJavadoc);
                    }
                });
                while (true) {
                    if (cancel != null && cancel.call().booleanValue()) {
                        future.cancel(false);
                        break;
                    }
                    try {
                        return (TextStream)future.get(100L, TimeUnit.MILLISECONDS);
                    }
                    catch (TimeoutException timeOut) {
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                LOG.log(Level.INFO, null, e);
            }
        }
        return null;
    }

    private static TextStream findJavadoc(@NonNull URL classFile, @NonNull String pkgName, @NonNull String pageName, @NonNull Collection<? extends CharSequence> fragment, boolean allowRemoteJavadoc) {
        URL sourceRoot = null;
        HashSet<URL> binaries = new HashSet<URL>();
        try {
            FileObject sourceFo;
            FileObject fo = URLMapper.findFileObject((URL)classFile);
            StringTokenizer tk = new StringTokenizer(pkgName, "/");
            for (int i = 0; fo != null && i <= tk.countTokens(); fo = fo.getParent(), ++i) {
            }
            if (fo != null) {
                URL url = CachingArchiveProvider.getDefault().mapCtSymToJar(fo.toURL());
                sourceRoot = JavaIndex.getSourceRootForClassFolder(url);
                if (sourceRoot == null) {
                    binaries.add(url);
                } else {
                    binaries.add(sourceRoot);
                }
            }
            if (sourceRoot != null && (sourceFo = URLMapper.findFileObject(sourceRoot)) != null) {
                ClassPath exec = ClassPath.getClassPath((FileObject)sourceFo, (String)"classpath/execute");
                ClassPath compile = ClassPath.getClassPath((FileObject)sourceFo, (String)"classpath/compile");
                ClassPath source = ClassPath.getClassPath((FileObject)sourceFo, (String)"classpath/source");
                if (exec == null) {
                    exec = compile;
                    compile = null;
                }
                if (exec != null && source != null) {
                    HashSet<URL> roots = new HashSet<URL>();
                    for (ClassPath.Entry e : exec.entries()) {
                        roots.add(e.getURL());
                    }
                    if (compile != null) {
                        for (ClassPath.Entry e : compile.entries()) {
                            roots.remove(e.getURL());
                        }
                    }
                    List<FileObject> sourceRoots = Arrays.asList(source.getRoots());
                    block11: for (URL e : roots) {
                        FileObject[] res;
                        for (FileObject r : res = SourceForBinaryQuery.findSourceRoots((URL)e).getRoots()) {
                            if (!sourceRoots.contains(r)) continue;
                            binaries.add(e);
                            continue block11;
                        }
                    }
                }
            }
            for (URL binary : binaries) {
                URL[] result;
                JavadocForBinaryQuery.Result javadocResult = JavadocForBinaryQuery.findJavadoc((URL)binary);
                for (URL root : result = javadocResult.getRoots()) {
                    InputStream is;
                    URL url;
                    block27: {
                        boolean useKnownGoodRoots;
                        if (!root.toExternalForm().endsWith("/")) {
                            LOG.log(Level.WARNING, "JavadocForBinaryQuery.Result: {0} returned non-folder URL: {1}, ignoring", new Object[]{javadocResult.getClass(), root.toExternalForm()});
                            continue;
                        }
                        if (!allowRemoteJavadoc && JavadocHelper.isRemote(root)) continue;
                        url = new URL(root, pkgName + "/" + pageName + ".html");
                        is = null;
                        String rootS = root.toString();
                        boolean bl = useKnownGoodRoots = result.length == 1 && JavadocHelper.isRemote(url);
                        if (useKnownGoodRoots && knownGoodRoots.contains(rootS)) {
                            LOG.log(Level.FINE, "assumed valid Javadoc stream at {0}", url);
                        } else {
                            try {
                                is = JavadocHelper.openStream(url);
                                if (!useKnownGoodRoots) break block27;
                                knownGoodRoots.add(rootS);
                                LOG.log(Level.FINE, "found valid Javadoc stream at {0}", url);
                            }
                            catch (IOException x) {
                                LOG.log(Level.FINE, "invalid Javadoc stream at {0}: {1}", new Object[]{url, x});
                                continue;
                            }
                        }
                    }
                    if (!fragment.isEmpty()) {
                        try {
                            ArrayList<URL> urls = new ArrayList<URL>(fragment.size());
                            for (CharSequence charSequence : fragment) {
                                String encodedfragment = URLEncoder.encode(charSequence.toString(), "UTF-8").replace("+", "%20");
                                urls.add(new URI(url.toExternalForm() + '#' + encodedfragment).toURL());
                            }
                            return new TextStream(urls, is);
                        }
                        catch (URISyntaxException x) {
                            LOG.log(Level.INFO, null, x);
                        }
                        catch (UnsupportedEncodingException x) {
                            LOG.log(Level.INFO, null, x);
                        }
                        catch (MalformedURLException x) {
                            LOG.log(Level.INFO, null, x);
                        }
                    }
                    return new TextStream(Collections.singleton(url), is);
                }
            }
        }
        catch (MalformedURLException x) {
            LOG.log(Level.INFO, null, x);
        }
        return null;
    }

    @NonNull
    private static Collection<? extends CharSequence> getFragment(Element e) {
        FragmentBuilder fb = new FragmentBuilder();
        if (!e.getKind().isClass() && !e.getKind().isInterface()) {
            if (e.getKind() == ElementKind.CONSTRUCTOR) {
                fb.append(e.getEnclosingElement().getSimpleName());
            } else {
                fb.append(e.getSimpleName());
            }
            if (e.getKind() == ElementKind.METHOD || e.getKind() == ElementKind.CONSTRUCTOR) {
                ExecutableElement ee = (ExecutableElement)e;
                fb.append("(");
                Iterator<? extends VariableElement> it = ee.getParameters().iterator();
                while (it.hasNext()) {
                    VariableElement param = it.next();
                    JavadocHelper.appendType(fb, param.asType(), ee.isVarArgs() && !it.hasNext());
                    if (!it.hasNext()) continue;
                    fb.append(", ");
                }
                fb.append(")");
            }
        }
        return fb.getFragments();
    }

    private static void appendType(FragmentBuilder fb, TypeMirror type, boolean varArg) {
        switch (type.getKind()) {
            case ARRAY: {
                JavadocHelper.appendType(fb, ((ArrayType)type).getComponentType(), false);
                fb.append(varArg ? "..." : "[]");
                break;
            }
            case DECLARED: {
                fb.append(((TypeElement)((DeclaredType)type).asElement()).getQualifiedName());
                break;
            }
            default: {
                fb.append(type.toString());
            }
        }
    }

    private static final class FragmentBuilder {
        private static final List<Convertor<CharSequence, CharSequence>> FILTERS;
        private final StringBuilder[] sbs = new StringBuilder[FILTERS.size()];

        FragmentBuilder() {
            for (int i = 0; i < this.sbs.length; ++i) {
                this.sbs[i] = new StringBuilder();
            }
        }

        @NonNull
        FragmentBuilder append(@NonNull CharSequence text) {
            for (int i = 0; i < this.sbs.length; ++i) {
                this.sbs[i].append((CharSequence)FILTERS.get(i).convert((Object)text));
            }
            return this;
        }

        @NonNull
        Collection<? extends CharSequence> getFragments() {
            ArrayList<String> res = new ArrayList<String>(this.sbs.length);
            for (StringBuilder sb : this.sbs) {
                res.add(sb.toString());
            }
            return Collections.unmodifiableCollection(res);
        }

        static {
            ArrayList<Convertor> tmp = new ArrayList<Convertor>();
            tmp.add(Convertors.identity());
            tmp.add(new JDoc8025633());
            FILTERS = Collections.unmodifiableList(tmp);
        }

        private static final class JDoc8025633
        implements Convertor<CharSequence, CharSequence> {
            private JDoc8025633() {
            }

            @NonNull
            public CharSequence convert(@NonNull CharSequence text) {
                StringBuilder sb = new StringBuilder();
                block7: for (int i = 0; i < text.length(); ++i) {
                    char c = text.charAt(i);
                    switch (c) {
                        case '(': 
                        case ')': 
                        case ',': 
                        case '<': 
                        case '>': {
                            sb.append('-');
                            continue block7;
                        }
                        case ' ': 
                        case '[': {
                            continue block7;
                        }
                        case ']': {
                            sb.append(":A");
                            continue block7;
                        }
                        case '$': {
                            if (i == 0) {
                                sb.append("Z:Z");
                            }
                            sb.append(":D");
                            continue block7;
                        }
                        case '_': {
                            if (i == 0) {
                                sb.append("Z:Z");
                            }
                        }
                        default: {
                            sb.append(c);
                        }
                    }
                }
                return sb.toString();
            }
        }
    }

    public static final class TextStream {
        private final List<? extends URL> urls;
        private final AtomicReference<InputStream> stream = new AtomicReference();
        private byte[] cache;

        public TextStream(@NonNull URL url) {
            Parameters.notNull((CharSequence)"url", (Object)url);
            this.urls = Collections.singletonList(url);
        }

        TextStream(@NonNull Collection<? extends URL> urls) {
            Parameters.notNull((CharSequence)"urls", urls);
            ArrayList<URL> tmpUrls = new ArrayList<URL>(urls.size());
            for (URL uRL : urls) {
                Parameters.notNull((CharSequence)"urls[]", (Object)uRL);
                tmpUrls.add(uRL);
            }
            if (tmpUrls.isEmpty()) {
                throw new IllegalArgumentException("At least one URL has to be given.");
            }
            this.urls = Collections.unmodifiableList(tmpUrls);
        }

        TextStream(@NonNull Collection<? extends URL> urls, InputStream stream) {
            this(urls);
            this.stream.set(stream);
        }

        @CheckForNull
        public URL getLocation() {
            return this.urls.iterator().next();
        }

        @NonNull
        public List<? extends URL> getLocations() {
            return this.urls;
        }

        public void close() {
            InputStream is = this.stream.getAndSet(null);
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException x) {
                    LOG.log(Level.INFO, null, x);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized InputStream openStream() throws IOException {
            if (this.cache != null) {
                LOG.log(Level.FINE, "loaded cached content for {0}", this.getLocation());
                return new ByteArrayInputStream(this.cache);
            }
            assert (!this.isRemote() || !EventQueue.isDispatchThread());
            InputStream uncached = this.stream.getAndSet(null);
            if (uncached == null) {
                uncached = JavadocHelper.openStream(this.getLocation());
            }
            if (this.isRemote()) {
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream(20480);
                    FileUtil.copy((InputStream)uncached, (OutputStream)baos);
                    this.cache = baos.toByteArray();
                }
                finally {
                    uncached.close();
                }
                LOG.log(Level.FINE, "cached content for {0} ({1}k)", new Object[]{this.getLocation(), this.cache.length / 1024});
                return new ByteArrayInputStream(this.cache);
            }
            return uncached;
        }

        public boolean isRemote() {
            return JavadocHelper.isRemote(this.getLocation());
        }
    }
}

