/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.source.util.SourcePositions;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.modules.java.source.parsing.DocPositionRegion;
import org.netbeans.modules.java.source.usages.Pair;

class FindMethodRegionsVisitor
extends SimpleTreeVisitor<Void, Void> {
    private final Document doc;
    private final SourcePositions pos;
    private final AtomicBoolean canceled;
    private CompilationUnitTree cu;
    private final List<Pair<DocPositionRegion, MethodTree>> posRegions = new LinkedList<Pair<DocPositionRegion, MethodTree>>();

    public FindMethodRegionsVisitor(Document doc, SourcePositions pos, AtomicBoolean canceled) {
        assert (doc != null);
        assert (pos != null);
        assert (canceled != null);
        this.doc = doc;
        this.pos = pos;
        this.canceled = canceled;
    }

    public List<Pair<DocPositionRegion, MethodTree>> getResult() {
        if (this.canceled.get()) {
            this.posRegions.clear();
        }
        return this.posRegions;
    }

    @Override
    public Void visitCompilationUnit(CompilationUnitTree node, Void p) {
        this.cu = node;
        for (Tree tree : node.getTypeDecls()) {
            this.visit(tree, p);
        }
        return null;
    }

    @Override
    public Void visitClass(ClassTree node, Void p) {
        for (Tree tree : node.getMembers()) {
            this.visit(tree, p);
        }
        return null;
    }

    @Override
    public Void visitMethod(MethodTree node, Void p) {
        assert (this.cu != null);
        if (!this.canceled.get()) {
            int startPos = (int)this.pos.getStartPosition(this.cu, node.getBody());
            int endPos = (int)this.pos.getEndPosition(this.cu, node.getBody());
            if (startPos >= 0) {
                try {
                    this.posRegions.add(Pair.of(new DocPositionRegion(this.doc, startPos, endPos), node));
                }
                catch (BadLocationException e) {
                    this.posRegions.clear();
                }
            }
        }
        return null;
    }
}

