/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.classpath;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.java.source.indexing.JavaIndex;
import org.openide.util.Exceptions;
import org.openide.util.Parameters;
import org.openide.util.Utilities;

public final class AptCacheForSourceQuery {
    private static Map<URL, URL> emittedAptFolders = new HashMap<URL, URL>();

    private AptCacheForSourceQuery() {
    }

    public static URL getAptFolder(@NonNull URL sourceRoot) {
        Parameters.notNull((CharSequence)"sourceRoot", (Object)sourceRoot);
        return AptCacheForSourceQuery.getDefaultAptFolder(sourceRoot);
    }

    public static URL getSourceFolder(@NonNull URL aptFolder) {
        Parameters.notNull((CharSequence)"aptFolder", (Object)aptFolder);
        return AptCacheForSourceQuery.getDefaultSourceFolder(aptFolder);
    }

    public static URL getClassFolder(@NonNull URL aptFolder) {
        Parameters.notNull((CharSequence)"aptFolder", (Object)aptFolder);
        return AptCacheForSourceQuery.getDefaultCacheFolder(aptFolder);
    }

    private static URL getDefaultAptFolder(URL sourceRoot) {
        try {
            if (emittedAptFolders.containsKey(sourceRoot)) {
                return sourceRoot;
            }
            File aptFolder = JavaIndex.getAptFolder(sourceRoot, true);
            URL result = Utilities.toURI((File)aptFolder).toURL();
            emittedAptFolders.put(result, sourceRoot);
            return result;
        }
        catch (MalformedURLException e) {
            Exceptions.printStackTrace((Throwable)e);
            return null;
        }
        catch (IOException e) {
            Exceptions.printStackTrace((Throwable)e);
            return null;
        }
    }

    private static URL getDefaultSourceFolder(URL aptFolder) {
        return emittedAptFolders.get(aptFolder);
    }

    private static URL getDefaultCacheFolder(URL aptFolder) {
        URL sourceRoot = emittedAptFolders.get(aptFolder);
        if (sourceRoot != null) {
            try {
                File result = JavaIndex.getClassFolder(sourceRoot);
                return Utilities.toURI((File)result).toURL();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return null;
    }
}

