/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.action;

import org.netbeans.api.db.explorer.node.BaseNode;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.action.BaseAction;
import org.netbeans.modules.db.explorer.action.RefreshAction;
import org.netbeans.modules.db.explorer.dlg.CreateTableDialog;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;

public class CreateTableAction
extends BaseAction {
    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length != 1) {
            return false;
        }
        boolean enabled = false;
        DatabaseConnection dbconn = (DatabaseConnection)activatedNodes[0].getLookup().lookup(DatabaseConnection.class);
        if (dbconn != null) {
            enabled = DatabaseConnection.isVitalConnection(dbconn.getConnection(), dbconn);
        }
        return enabled;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(CreateTableAction.class);
    }

    public void performAction(Node[] activatedNodes) {
        final BaseNode node = (BaseNode)((Object)activatedNodes[0].getLookup().lookup(BaseNode.class));
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                CreateTableAction.this.perform(node);
            }
        });
    }

    private void perform(BaseNode node) {
        String schema = CreateTableAction.findSchemaWorkingName(node.getLookup());
        boolean tableCreated = CreateTableDialog.showDialogAndCreate(node, schema);
        if (tableCreated) {
            ((RefreshAction)SystemAction.get(RefreshAction.class)).performAction(new Node[]{node});
        }
    }

    public String getName() {
        return NbBundle.getMessage(CreateTableAction.class, (String)"CreateTable");
    }
}

