/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.db.explorer;

import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.db.explorer.ConnectionListener;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.modules.db.explorer.ConnectionList;
import org.netbeans.modules.db.explorer.action.ConnectUsingDriverAction;
import org.netbeans.modules.db.runtime.DatabaseRuntimeManager;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;

public final class ConnectionManager {
    private static final Logger LOGGER = Logger.getLogger(ConnectionManager.class.getName());
    private static ConnectionManager DEFAULT;

    public static synchronized ConnectionManager getDefault() {
        if (DEFAULT == null) {
            DatabaseRuntimeManager.getDefault().getRuntimes();
            DEFAULT = new ConnectionManager();
        }
        return DEFAULT;
    }

    public DatabaseConnection[] getConnections() {
        org.netbeans.modules.db.explorer.DatabaseConnection[] conns = ConnectionList.getDefault().getConnections();
        DatabaseConnection[] dbconns = new DatabaseConnection[conns.length];
        for (int i = 0; i < conns.length; ++i) {
            dbconns[i] = conns[i].getDatabaseConnection();
        }
        return dbconns;
    }

    public DatabaseConnection getConnection(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        org.netbeans.modules.db.explorer.DatabaseConnection[] conns = ConnectionList.getDefault().getConnections();
        for (int i = 0; i < conns.length; ++i) {
            DatabaseConnection dbconn = conns[i].getDatabaseConnection();
            if (!name.equals(dbconn.getName())) continue;
            return dbconn;
        }
        return null;
    }

    public void addConnection(DatabaseConnection dbconn) throws DatabaseException {
        if (dbconn == null) {
            throw new NullPointerException();
        }
        ConnectionList.getDefault().add(dbconn.getDelegate());
    }

    public boolean connect(DatabaseConnection dbconn) throws DatabaseException {
        if (dbconn == null) {
            throw new NullPointerException();
        }
        if (!ConnectionList.getDefault().contains(dbconn.getDelegate())) {
            throw new IllegalStateException("This connection is not added to the ConnectionManager.");
        }
        if (ConnectionManager.isEmpty(dbconn.getUser()) || ConnectionManager.isEmpty(dbconn.getDatabaseURL())) {
            return false;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("This method can not be called on the event dispatch thread.");
        }
        if (org.netbeans.modules.db.explorer.DatabaseConnection.isVitalConnection(dbconn.getJDBCConnection(), null)) {
            return true;
        }
        dbconn.getDelegate().connectSync();
        dbconn.getDelegate().getConnector().finishConnect(null, dbconn.getDelegate(), dbconn.getDelegate().getConnection());
        dbconn.getDelegate().fireConnectionComplete();
        return true;
    }

    private static boolean isEmpty(String value) {
        return value == null || value.trim().length() == 0;
    }

    public void removeConnection(DatabaseConnection dbconn) throws DatabaseException {
        if (dbconn == null) {
            throw new NullPointerException();
        }
        ConnectionList.getDefault().remove(dbconn.getDelegate());
    }

    public void showAddConnectionDialog(JDBCDriver driver) {
        this.showAddConnectionDialog(driver, null, null, null);
    }

    public void showAddConnectionDialog(JDBCDriver driver, String databaseUrl) {
        this.showAddConnectionDialog(driver, databaseUrl, null, null);
    }

    public void showAddConnectionDialog(final JDBCDriver driver, final String databaseUrl, final String user, final String password) {
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                new ConnectUsingDriverAction.NewConnectionDialogDisplayer().showDialog(driver, databaseUrl, user, password);
            }
        });
    }

    public DatabaseConnection showAddConnectionDialogFromEventThread(JDBCDriver driver) {
        return this.showAddConnectionDialogFromEventThread(driver, null, null, null);
    }

    public DatabaseConnection showAddConnectionDialogFromEventThread(JDBCDriver driver, String databaseUrl) {
        return this.showAddConnectionDialogFromEventThread(driver, databaseUrl, null, null);
    }

    public DatabaseConnection showAddConnectionDialogFromEventThread(JDBCDriver driver, String databaseUrl, String user, String password) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("The current thread is not the event dispatching thread.");
        }
        org.netbeans.modules.db.explorer.DatabaseConnection internalDBConn = new ConnectUsingDriverAction.NewConnectionDialogDisplayer().showDialog(driver, databaseUrl, user, password);
        if (internalDBConn != null) {
            return internalDBConn.getDatabaseConnection();
        }
        return null;
    }

    public void showConnectionDialog(DatabaseConnection dbconn) {
        if (dbconn == null) {
            throw new NullPointerException();
        }
        if (!ConnectionList.getDefault().contains(dbconn.getDelegate())) {
            throw new IllegalStateException("This connection is not added to the ConnectionManager.");
        }
        dbconn.getDelegate().showConnectionDialog();
    }

    public void disconnect(DatabaseConnection dbconn) {
        if (dbconn == null) {
            throw new NullPointerException();
        }
        if (!ConnectionList.getDefault().contains(dbconn.getDelegate())) {
            throw new IllegalStateException("This connection is not added to the ConnectionManager.");
        }
        try {
            dbconn.getDelegate().disconnect();
        }
        catch (DatabaseException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
    }

    public void selectConnectionInExplorer(DatabaseConnection dbconn) {
        if (dbconn == null) {
            throw new NullPointerException();
        }
        if (!ConnectionList.getDefault().contains(dbconn.getDelegate())) {
            throw new IllegalStateException("This connection is not added to the ConnectionManager.");
        }
        dbconn.getDelegate().selectInExplorer();
    }

    public void refreshConnectionInExplorer(DatabaseConnection dbconn) {
        if (dbconn == null) {
            throw new NullPointerException();
        }
        if (!ConnectionList.getDefault().contains(dbconn.getDelegate())) {
            throw new IllegalStateException("This connection is not added to the ConnectionManager.");
        }
        try {
            dbconn.getDelegate().refreshInExplorer();
        }
        catch (DatabaseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void addConnectionListener(ConnectionListener listener) {
        ConnectionList.getDefault().addConnectionListener(listener);
    }

    public void removeConnectionListener(ConnectionListener listener) {
        ConnectionList.getDefault().removeConnectionListener(listener);
    }
}

