/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.plugins;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.server.rest.repr.BadInputException;

public abstract class ParameterList {
    private final Map<String, Object> data;

    public ParameterList(Map<String, Object> data) {
        this.data = data;
    }

    public Map<String, Object> asMap() {
        return Collections.unmodifiableMap(this.data);
    }

    private <T> T[] getList(String name, AbstractGraphDatabase graphDb, Converter<T> converter) throws BadInputException {
        Object value = this.data.get(name);
        if (value == null) {
            return null;
        }
        ArrayList<T> result = new ArrayList<T>();
        if (value instanceof Object[]) {
            for (Object element : (Object[])value) {
                result.add(converter.convert(graphDb, element));
            }
        } else if (value instanceof Iterable) {
            for (Object element : (Iterable)value) {
                result.add(converter.convert(graphDb, element));
            }
        } else {
            throw new BadInputException(name + " is not a list");
        }
        return result.toArray(converter.newArray(result.size()));
    }

    public String getString(String name) throws BadInputException {
        Object value = this.data.get(name);
        if (value == null) {
            return null;
        }
        return this.convertString(value);
    }

    public String[] getStringList(String name) throws BadInputException {
        return this.getList(name, null, new Converter<String>(){

            @Override
            String convert(AbstractGraphDatabase graphDb, Object value) throws BadInputException {
                return ParameterList.this.convertString(value);
            }

            String[] newArray(int size) {
                return new String[size];
            }
        });
    }

    protected abstract String convertString(Object var1) throws BadInputException;

    public Integer getInteger(String name) throws BadInputException {
        Object value = this.data.get(name);
        if (value == null) {
            return null;
        }
        return this.convertInteger(value);
    }

    public Integer[] getIntegerList(String name) throws BadInputException {
        return this.getList(name, null, new Converter<Integer>(){

            @Override
            Integer convert(AbstractGraphDatabase graphDb, Object value) throws BadInputException {
                return ParameterList.this.convertInteger(value);
            }

            Integer[] newArray(int size) {
                return new Integer[size];
            }
        });
    }

    protected abstract Integer convertInteger(Object var1) throws BadInputException;

    public Long getLong(String name) throws BadInputException {
        Object value = this.data.get(name);
        if (value == null) {
            return null;
        }
        return this.convertLong(value);
    }

    public Long[] getLongList(String name) throws BadInputException {
        return this.getList(name, null, new Converter<Long>(){

            @Override
            Long convert(AbstractGraphDatabase graphDb, Object value) throws BadInputException {
                return ParameterList.this.convertLong(value);
            }

            Long[] newArray(int size) {
                return new Long[size];
            }
        });
    }

    protected abstract Long convertLong(Object var1) throws BadInputException;

    public Byte getByte(String name) throws BadInputException {
        Object value = this.data.get(name);
        if (value == null) {
            return null;
        }
        return this.convertByte(value);
    }

    public Byte[] getByteList(String name) throws BadInputException {
        return this.getList(name, null, new Converter<Byte>(){

            @Override
            Byte convert(AbstractGraphDatabase graphDb, Object value) throws BadInputException {
                return ParameterList.this.convertByte(value);
            }

            Byte[] newArray(int size) {
                return new Byte[size];
            }
        });
    }

    protected abstract Byte convertByte(Object var1) throws BadInputException;

    public Character getCharacter(String name) throws BadInputException {
        Object value = this.data.get(name);
        if (value == null) {
            return null;
        }
        return this.convertCharacter(value);
    }

    public Character[] getCharacterList(String name) throws BadInputException {
        return this.getList(name, null, new Converter<Character>(){

            @Override
            Character convert(AbstractGraphDatabase graphDb, Object value) throws BadInputException {
                return ParameterList.this.convertCharacter(value);
            }

            Character[] newArray(int size) {
                return new Character[size];
            }
        });
    }

    protected abstract Character convertCharacter(Object var1) throws BadInputException;

    public Boolean getBoolean(String name) throws BadInputException {
        Object value = this.data.get(name);
        if (value == null) {
            return null;
        }
        return this.convertBoolean(value);
    }

    public Boolean[] getBooleanList(String name) throws BadInputException {
        return this.getList(name, null, new Converter<Boolean>(){

            @Override
            Boolean convert(AbstractGraphDatabase graphDb, Object value) throws BadInputException {
                return ParameterList.this.convertBoolean(value);
            }

            Boolean[] newArray(int size) {
                return new Boolean[size];
            }
        });
    }

    protected abstract Boolean convertBoolean(Object var1) throws BadInputException;

    public Short getShort(String name) throws BadInputException {
        Object value = this.data.get(name);
        if (value == null) {
            return null;
        }
        return this.convertShort(value);
    }

    public Short[] getShortList(String name) throws BadInputException {
        return this.getList(name, null, new Converter<Short>(){

            @Override
            Short convert(AbstractGraphDatabase graphDb, Object value) throws BadInputException {
                return ParameterList.this.convertShort(value);
            }

            Short[] newArray(int size) {
                return new Short[size];
            }
        });
    }

    protected abstract Short convertShort(Object var1) throws BadInputException;

    public Float getFloat(String name) throws BadInputException {
        Object value = this.data.get(name);
        if (value == null) {
            return null;
        }
        return this.convertFloat(value);
    }

    public Float[] getFloatList(String name) throws BadInputException {
        return this.getList(name, null, new Converter<Float>(){

            @Override
            Float convert(AbstractGraphDatabase graphDb, Object value) throws BadInputException {
                return ParameterList.this.convertFloat(value);
            }

            Float[] newArray(int size) {
                return new Float[size];
            }
        });
    }

    protected abstract Float convertFloat(Object var1) throws BadInputException;

    public Double getDouble(String name) throws BadInputException {
        Object value = this.data.get(name);
        if (value == null) {
            return null;
        }
        return this.convertDouble(value);
    }

    public Double[] getDoubleList(String name) throws BadInputException {
        return this.getList(name, null, new Converter<Double>(){

            @Override
            Double convert(AbstractGraphDatabase graphDb, Object value) throws BadInputException {
                return ParameterList.this.convertDouble(value);
            }

            Double[] newArray(int size) {
                return new Double[size];
            }
        });
    }

    protected abstract Double convertDouble(Object var1) throws BadInputException;

    public Node getNode(AbstractGraphDatabase graphDb, String name) throws BadInputException {
        Object value = this.data.get(name);
        if (value == null) {
            return null;
        }
        return this.convertNode(graphDb, value);
    }

    public Node[] getNodeList(AbstractGraphDatabase graphDb, String name) throws BadInputException {
        return this.getList(name, graphDb, new Converter<Node>(){

            @Override
            Node convert(AbstractGraphDatabase graphDb, Object value) throws BadInputException {
                return ParameterList.this.convertNode(graphDb, value);
            }

            Node[] newArray(int size) {
                return new Node[size];
            }
        });
    }

    protected abstract Node convertNode(AbstractGraphDatabase var1, Object var2) throws BadInputException;

    public Relationship getRelationship(AbstractGraphDatabase graphDb, String name) throws BadInputException {
        Object value = this.data.get(name);
        if (value == null) {
            return null;
        }
        return this.convertRelationship(graphDb, value);
    }

    public Relationship[] getRelationshipList(AbstractGraphDatabase graphDb, String name) throws BadInputException {
        return this.getList(name, graphDb, new Converter<Relationship>(){

            @Override
            Relationship convert(AbstractGraphDatabase graphDb, Object value) throws BadInputException {
                return ParameterList.this.convertRelationship(graphDb, value);
            }

            Relationship[] newArray(int size) {
                return new Relationship[size];
            }
        });
    }

    protected abstract Relationship convertRelationship(AbstractGraphDatabase var1, Object var2) throws BadInputException;

    public URI getUri(String name) throws BadInputException {
        Object value = this.data.get(name);
        if (value == null) {
            return null;
        }
        return this.convertURI(value);
    }

    public URI[] getUriList(String name) throws BadInputException {
        return this.getList(name, null, new Converter<URI>(){

            @Override
            URI convert(AbstractGraphDatabase graphDb, Object value) throws BadInputException {
                return ParameterList.this.convertURI(value);
            }

            URI[] newArray(int size) {
                return new URI[size];
            }
        });
    }

    protected URI convertURI(Object value) throws BadInputException {
        try {
            return new URI(this.convertString(value));
        }
        catch (URISyntaxException e) {
            throw new BadInputException(e);
        }
    }

    public Map getMap(String name) throws BadInputException {
        Object value = this.data.get(name);
        if (value instanceof Map) {
            return (Map)value;
        }
        if (value instanceof String) {
            throw new BadInputException("Maps encoded as Strings not supported");
        }
        return null;
    }

    private static abstract class Converter<T> {
        private Converter() {
        }

        abstract T convert(AbstractGraphDatabase var1, Object var2) throws BadInputException;

        abstract T[] newArray(int var1);
    }
}

