/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gis.spatial.index.curves;

import org.neo4j.gis.spatial.index.Envelope;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurve;

public class ZOrderSpaceFillingCurve2D
extends SpaceFillingCurve {
    private static final ZOrderCurve2D rootCurve = new ZOrderCurve2D(1, 3, 0, 2);
    public static final int MAX_LEVEL = 30;

    public ZOrderSpaceFillingCurve2D(Envelope range) {
        this(range, 30);
    }

    public ZOrderSpaceFillingCurve2D(Envelope range, int maxLevel) {
        super(range, maxLevel);
        assert (maxLevel <= 30);
        assert (range.getDimension() == 2);
    }

    @Override
    SpaceFillingCurve.CurveRule rootCurve() {
        return rootCurve;
    }

    static class ZOrderCurve2D
    extends SpaceFillingCurve.CurveRule {
        private ZOrderCurve2D(int ... npointValues) {
            super(2, npointValues);
            assert (npointValues[0] == 1 && npointValues[3] == 2);
        }

        @Override
        public SpaceFillingCurve.CurveRule childAt(int npoint) {
            return this;
        }

        public String toString() {
            return "Z";
        }
    }
}

