/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.populator;

import org.neo4j.kernel.api.impl.schema.LuceneDocumentStructure;
import org.neo4j.kernel.api.impl.schema.populator.LuceneIndexPopulatingUpdater;
import org.neo4j.kernel.api.impl.schema.writer.LuceneIndexWriter;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.impl.api.index.sampling.NonUniqueIndexSampler;

public class NonUniqueLuceneIndexPopulatingUpdater
extends LuceneIndexPopulatingUpdater {
    private final NonUniqueIndexSampler sampler;

    public NonUniqueLuceneIndexPopulatingUpdater(LuceneIndexWriter writer, NonUniqueIndexSampler sampler) {
        super(writer);
        this.sampler = sampler;
    }

    @Override
    protected void added(NodePropertyUpdate update) {
        String encodedValue = LuceneDocumentStructure.encodedStringValue(update.getValueAfter());
        this.sampler.include(encodedValue);
    }

    @Override
    protected void changed(NodePropertyUpdate update) {
        String encodedValueBefore = LuceneDocumentStructure.encodedStringValue(update.getValueBefore());
        this.sampler.exclude(encodedValueBefore);
        String encodedValueAfter = LuceneDocumentStructure.encodedStringValue(update.getValueAfter());
        this.sampler.include(encodedValueAfter);
    }

    @Override
    protected void removed(NodePropertyUpdate update) {
        String removedValue = LuceneDocumentStructure.encodedStringValue(update.getValueBefore());
        this.sampler.exclude(removedValue);
    }

    public void close() {
    }
}

