/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.labelscan.reader;

import java.io.IOException;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.kernel.api.impl.index.partition.PartitionSearcher;
import org.neo4j.kernel.api.impl.labelscan.storestrategy.LabelScanStorageStrategy;
import org.neo4j.kernel.api.impl.schema.reader.IndexReaderCloseException;
import org.neo4j.storageengine.api.schema.LabelScanReader;

public class SimpleLuceneLabelScanStoreReader
implements LabelScanReader {
    private final PartitionSearcher partitionSearcher;
    private final LabelScanStorageStrategy strategy;

    public SimpleLuceneLabelScanStoreReader(PartitionSearcher partitionSearcher, LabelScanStorageStrategy strategy) {
        this.partitionSearcher = partitionSearcher;
        this.strategy = strategy;
    }

    public PrimitiveLongIterator nodesWithLabel(int labelId) {
        return this.strategy.nodesWithLabel(this.partitionSearcher.getIndexSearcher(), labelId);
    }

    public PrimitiveLongIterator labelsForNode(long nodeId) {
        return this.strategy.labelsForNode(this.partitionSearcher.getIndexSearcher(), nodeId);
    }

    public void close() {
        try {
            this.partitionSearcher.close();
        }
        catch (IOException e) {
            throw new IndexReaderCloseException(e);
        }
    }
}

