/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging.log4j;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.function.Consumer;
import org.neo4j.exceptions.UnsatisfiedDependencyException;
import org.neo4j.logging.Log;
import org.neo4j.logging.log4j.Log4jLog;
import org.neo4j.logging.shaded.log4j.Level;
import org.neo4j.logging.shaded.log4j.Marker;
import org.neo4j.logging.shaded.log4j.core.LogEvent;
import org.neo4j.logging.shaded.log4j.core.config.DefaultConfiguration;
import org.neo4j.logging.shaded.log4j.core.config.plugins.Plugin;
import org.neo4j.logging.shaded.log4j.core.config.plugins.PluginAttribute;
import org.neo4j.logging.shaded.log4j.core.config.plugins.PluginFactory;
import org.neo4j.logging.shaded.log4j.core.impl.DefaultLogEventFactory;
import org.neo4j.logging.shaded.log4j.core.layout.AbstractStringLayout;
import org.neo4j.logging.shaded.log4j.core.layout.PatternLayout;
import org.neo4j.logging.shaded.log4j.message.Message;
import org.neo4j.logging.shaded.log4j.spi.AbstractLogger;

@Plugin(name="Neo4jLogLayout", category="Core", elementType="layout", printObject=true)
public class Neo4jLogLayout
extends AbstractStringLayout {
    protected final AbstractStringLayout.Serializer eventSerializer;
    protected volatile Consumer<Log> headerLogger;
    protected volatile String headerClassName;

    protected Neo4jLogLayout(String pattern, DefaultConfiguration config) {
        super(config, StandardCharsets.UTF_8, null, null);
        this.eventSerializer = PatternLayout.newSerializerBuilder().setConfiguration(config).setAlwaysWriteExceptions(true).setDisableAnsi(false).setNoConsoleNoAnsi(false).setPattern(pattern).build();
    }

    @PluginFactory
    public static Neo4jLogLayout createLayout(@PluginAttribute(value="pattern") String pattern) {
        return new Neo4jLogLayout(pattern, new DefaultConfiguration());
    }

    @Override
    public byte[] getHeader() {
        if (this.headerLogger == null) {
            return super.getHeader();
        }
        ByteArrayLogger byteArrayLogger = new ByteArrayLogger();
        Log4jLog log = new Log4jLog(byteArrayLogger);
        try {
            this.headerLogger.accept(log);
        }
        catch (UnsatisfiedDependencyException unsatisfiedDependencyException) {
            // empty catch block
        }
        return byteArrayLogger.getBytes();
    }

    @Override
    public String toSerializable(LogEvent event) {
        return this.eventSerializer.toSerializable(event);
    }

    public void setHeaderLogger(Consumer<Log> headerLogger, String className) {
        this.headerLogger = headerLogger;
        this.headerClassName = className;
    }

    private class ByteArrayLogger
    extends AbstractLogger {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();

        private ByteArrayLogger() {
        }

        @Override
        public boolean isEnabled(Level level, Marker marker, Message message, Throwable t) {
            return true;
        }

        @Override
        public boolean isEnabled(Level level, Marker marker, CharSequence message, Throwable t) {
            return true;
        }

        @Override
        public boolean isEnabled(Level level, Marker marker, Object message, Throwable t) {
            return true;
        }

        @Override
        public boolean isEnabled(Level level, Marker marker, String message, Throwable t) {
            return true;
        }

        @Override
        public boolean isEnabled(Level level, Marker marker, String message) {
            return true;
        }

        @Override
        public boolean isEnabled(Level level, Marker marker, String message, Object ... params) {
            return true;
        }

        @Override
        public boolean isEnabled(Level level, Marker marker, String message, Object p0) {
            return true;
        }

        @Override
        public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1) {
            return true;
        }

        @Override
        public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2) {
            return true;
        }

        @Override
        public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3) {
            return true;
        }

        @Override
        public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4) {
            return true;
        }

        @Override
        public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
            return true;
        }

        @Override
        public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
            return true;
        }

        @Override
        public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
            return true;
        }

        @Override
        public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
            return true;
        }

        @Override
        public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
            return true;
        }

        @Override
        public void logMessage(String fqcn, Level level, Marker marker, Message message, Throwable t) {
            String logMsg = Neo4jLogLayout.this.toSerializable(DefaultLogEventFactory.getInstance().createEvent(Neo4jLogLayout.this.headerClassName, marker, fqcn, level, message, Collections.emptyList(), t));
            try {
                this.baos.write(logMsg.getBytes(StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public Level getLevel() {
            return null;
        }

        public byte[] getBytes() {
            return this.baos.toByteArray();
        }
    }
}

