/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging.internal;

import java.time.Clock;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import javax.annotation.Nonnull;
import org.neo4j.logging.Log;
import org.neo4j.util.Preconditions;

public class CappedLogger {
    private static final AtomicLongFieldUpdater<CappedLogger> LAST_CHECK = AtomicLongFieldUpdater.newUpdater(CappedLogger.class, "lastCheck");
    private final Log delegate;
    private final long timeLimitMillis;
    private final Clock clock;
    private volatile long lastCheck;

    public CappedLogger(Log delegate, long time, TimeUnit unit, Clock clock) {
        this.delegate = Objects.requireNonNull(delegate);
        this.clock = Objects.requireNonNull(clock);
        this.timeLimitMillis = unit.toMillis(Preconditions.requirePositive((long)time));
    }

    public void debug(@Nonnull String msg) {
        if (this.checkExpiredAndSetLastCheckTime()) {
            this.delegate.debug(msg);
        }
    }

    public void debug(@Nonnull String msg, @Nonnull Throwable cause) {
        if (this.checkExpiredAndSetLastCheckTime()) {
            this.delegate.debug(msg, cause);
        }
    }

    public void info(@Nonnull String msg, Object ... arguments) {
        if (this.checkExpiredAndSetLastCheckTime()) {
            this.delegate.info(msg, arguments);
        }
    }

    public void info(@Nonnull String msg, @Nonnull Throwable cause) {
        if (this.checkExpiredAndSetLastCheckTime()) {
            this.delegate.info(msg, cause);
        }
    }

    public void warn(@Nonnull String msg) {
        if (this.checkExpiredAndSetLastCheckTime()) {
            this.delegate.warn(msg);
        }
    }

    public void warn(@Nonnull String msg, @Nonnull Throwable cause) {
        if (this.checkExpiredAndSetLastCheckTime()) {
            this.delegate.warn(msg, cause);
        }
    }

    public void warn(@Nonnull String msg, Object ... arguments) {
        if (this.checkExpiredAndSetLastCheckTime()) {
            this.delegate.warn(msg, arguments);
        }
    }

    public void error(@Nonnull String msg) {
        if (this.checkExpiredAndSetLastCheckTime()) {
            this.delegate.error(msg);
        }
    }

    public void error(@Nonnull String msg, @Nonnull Throwable cause) {
        if (this.checkExpiredAndSetLastCheckTime()) {
            this.delegate.error(msg, cause);
        }
    }

    private boolean checkExpiredAndSetLastCheckTime() {
        long check = this.lastCheck;
        long now = this.clock.millis();
        if (check > now - this.timeLimitMillis) {
            return false;
        }
        while (!LAST_CHECK.compareAndSet(this, check, now) && (check = this.lastCheck) <= now) {
        }
        return true;
    }
}

