/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging.event;

import java.util.ArrayList;
import java.util.List;
import org.neo4j.logging.event.DebugEventPublisher;
import org.neo4j.logging.event.LoopAwareDebugEventPublisher;
import org.neo4j.logging.event.Parameters;
import org.neo4j.logging.event.Type;

public class LoopAwareCappedDebugEventPublisher
implements LoopAwareDebugEventPublisher {
    private final DebugEventPublisher delegate;
    private final int maximumNumberOfLoopsWithoutPassingOnEvent;
    private List<Event> lastLoggedLoop = null;
    private List<Event> currentLoop = new ArrayList<Event>();
    private int loopsWithNoChange = 0;

    public LoopAwareCappedDebugEventPublisher(DebugEventPublisher delegate, int maximumNumberOfLoopsWithoutPassingOnEvent) {
        this.delegate = delegate;
        this.maximumNumberOfLoopsWithoutPassingOnEvent = maximumNumberOfLoopsWithoutPassingOnEvent;
    }

    private synchronized void addEvent(Event event) {
        this.currentLoop.add(event);
        if (this.lastLoggedLoop == null) {
            event.apply(this.delegate);
        } else if (this.lastLoggedLoop.size() < this.currentLoop.size() || !this.lastLoggedLoop.get(this.currentLoop.size() - 1).equals(event)) {
            this.lastLoggedLoop = null;
            this.logWholeLoop();
        }
    }

    @Override
    public synchronized void loopComplete() {
        if (this.lastLoggedLoop == null) {
            this.lastLoggedLoop = this.currentLoop;
        } else if (!this.lastLoggedLoop.equals(this.currentLoop)) {
            this.logWholeLoop();
            this.lastLoggedLoop = this.currentLoop;
        } else if (this.loopsWithNoChange >= this.maximumNumberOfLoopsWithoutPassingOnEvent) {
            this.logWholeLoop();
        } else {
            ++this.loopsWithNoChange;
        }
        this.currentLoop = new ArrayList<Event>();
    }

    private void logWholeLoop() {
        if (this.loopsWithNoChange > 0) {
            this.delegate.publish(Type.Info, String.format("There were %d repetitions of the same loop of events which were not logged", this.loopsWithNoChange));
            this.loopsWithNoChange = 0;
        }
        this.currentLoop.forEach(storedLogEvent -> storedLogEvent.apply(this.delegate));
    }

    @Override
    public void publish(Type type, String message, Parameters parameters) {
        this.addEvent(new Event(type, message, parameters));
    }

    @Override
    public void publish(Type type, String message) {
        this.addEvent(new Event(type, message, null));
    }

    private record Event(Type type, String message, Parameters parameters) {
        void apply(DebugEventPublisher publisher) {
            if (this.parameters == null) {
                publisher.publish(this.type, this.message);
            } else {
                publisher.publish(this.type, this.message, this.parameters);
            }
        }
    }
}

