/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.format.v2_2;

import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.kernel.impl.store.format.NeoStoreFormatUtils;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.standard.BaseRecordCursor;
import org.neo4j.kernel.impl.store.standard.FixedSizeRecordStoreFormat;
import org.neo4j.kernel.impl.store.standard.StoreFormat;
import org.neo4j.kernel.impl.store.standard.StoreToolkit;

public class RelationshipStoreFormat_v2_2
extends FixedSizeRecordStoreFormat<RelationshipRecord, RelationshipRecordCursor> {
    private final RelationshipRecordFormat recordFormat = new RelationshipRecordFormat();

    public RelationshipStoreFormat_v2_2() {
        super(34, "RelationshipStore", "v0.A.5");
    }

    @Override
    public RelationshipRecordCursor createCursor(PagedFile file, StoreToolkit toolkit, int flags) {
        return new RelationshipRecordCursor(file, toolkit, this.recordFormat, flags);
    }

    @Override
    public StoreFormat.RecordFormat<RelationshipRecord> recordFormat() {
        return this.recordFormat;
    }

    public static class RelationshipRecordCursor
    extends BaseRecordCursor<RelationshipRecord, RelationshipRecordFormat> {
        public RelationshipRecordCursor(PagedFile file, StoreToolkit toolkit, RelationshipRecordFormat format, int flags) {
            super(file, toolkit, format, flags);
        }
    }

    public static class RelationshipRecordFormat
    implements StoreFormat.RecordFormat<RelationshipRecord> {
        private static final int IN_USE = 0;
        private static final int FIRST_NODE = 1;
        private static final int SECOND_NODE = 5;
        private static final int TYPE = 9;
        private static final int FIRST_PREV_REL = 13;
        private static final int FIRST_NEXT_REL = 17;
        private static final int SECOND_PREV_REL = 21;
        private static final int SECOND_NEXT_REL = 25;
        private static final int NEXT_PROP = 29;
        private static final int EXTRA = 33;
        private static final int RECORD_SIZE = 34;

        @Override
        public String recordName() {
            return "RelationshipRecord";
        }

        @Override
        public long id(RelationshipRecord record) {
            return record.getId();
        }

        @Override
        public RelationshipRecord newRecord(long id) {
            return new RelationshipRecord(id);
        }

        @Override
        public void serialize(PageCursor cursor, int offset, RelationshipRecord record) {
            if (record.inUse()) {
                long firstNode = record.getFirstNode();
                short firstNodeMod = (short)((firstNode & 0x700000000L) >> 31);
                long secondNode = record.getSecondNode();
                long secondNodeMod = (secondNode & 0x700000000L) >> 4;
                long firstPrevRel = record.getFirstPrevRel();
                long firstPrevRelMod = firstPrevRel == (long)Record.NO_NEXT_RELATIONSHIP.intValue() ? 0L : (firstPrevRel & 0x700000000L) >> 7;
                long firstNextRel = record.getFirstNextRel();
                long firstNextRelMod = firstNextRel == (long)Record.NO_NEXT_RELATIONSHIP.intValue() ? 0L : (firstNextRel & 0x700000000L) >> 10;
                long secondPrevRel = record.getSecondPrevRel();
                long secondPrevRelMod = secondPrevRel == (long)Record.NO_NEXT_RELATIONSHIP.intValue() ? 0L : (secondPrevRel & 0x700000000L) >> 13;
                long secondNextRel = record.getSecondNextRel();
                long secondNextRelMod = secondNextRel == (long)Record.NO_NEXT_RELATIONSHIP.intValue() ? 0L : (secondNextRel & 0x700000000L) >> 16;
                long nextProp = record.getNextProp();
                long nextPropMod = nextProp == (long)Record.NO_NEXT_PROPERTY.intValue() ? 0L : (nextProp & 0xF00000000L) >> 28;
                short inUseUnsignedByte = (short)((long)((record.inUse() ? Record.IN_USE : Record.NOT_IN_USE).byteValue() | firstNodeMod) | nextPropMod);
                int typeInt = (int)((long)record.getType() | secondNodeMod | firstPrevRelMod | firstNextRelMod | secondPrevRelMod | secondNextRelMod);
                long firstInStartNodeChain = record.isFirstInFirstChain() ? 1L : 0L;
                long firstInEndNodeChain = record.isFirstInSecondChain() ? 2L : 0L;
                byte extraByte = (byte)(firstInEndNodeChain | firstInStartNodeChain);
                cursor.putByte(offset + 0, (byte)inUseUnsignedByte);
                cursor.putInt(offset + 1, (int)firstNode);
                cursor.putInt(offset + 5, (int)secondNode);
                cursor.putInt(offset + 9, typeInt);
                cursor.putInt(offset + 13, (int)firstPrevRel);
                cursor.putInt(offset + 17, (int)firstNextRel);
                cursor.putInt(offset + 21, (int)secondPrevRel);
                cursor.putInt(offset + 25, (int)secondNextRel);
                cursor.putInt(offset + 29, (int)nextProp);
                cursor.putByte(offset + 33, extraByte);
            } else {
                cursor.putByte(offset + 0, (byte)0);
            }
        }

        @Override
        public void deserialize(PageCursor cursor, int offset, long id, RelationshipRecord record) {
            record.setId(id);
            long inUseByte = cursor.getByte(offset + 0);
            long firstNode = cursor.getUnsignedInt(offset + 1);
            long secondNode = cursor.getUnsignedInt(offset + 5);
            long typeInt = cursor.getInt(offset + 9);
            long firstPrevRel = cursor.getUnsignedInt(offset + 13);
            long firstNextRel = cursor.getUnsignedInt(offset + 17);
            long secondPrevRel = cursor.getUnsignedInt(offset + 21);
            long secondNextRel = cursor.getUnsignedInt(offset + 25);
            long nextProp = cursor.getUnsignedInt(offset + 29);
            byte extraByte = cursor.getByte(offset + 33);
            record.setFirstNode(NeoStoreFormatUtils.longFromIntAndMod(firstNode, (inUseByte & 0xEL) << 31));
            record.setSecondNode(NeoStoreFormatUtils.longFromIntAndMod(secondNode, (typeInt & 0x70000000L) << 4));
            record.setType((int)(typeInt & 0xFFFFL));
            record.setInUse((inUseByte & 1L) == (long)Record.IN_USE.intValue());
            record.setFirstPrevRel(NeoStoreFormatUtils.longFromIntAndMod(firstPrevRel, (typeInt & 0xE000000L) << 7));
            record.setFirstNextRel(NeoStoreFormatUtils.longFromIntAndMod(firstNextRel, (typeInt & 0x1C00000L) << 10));
            record.setSecondPrevRel(NeoStoreFormatUtils.longFromIntAndMod(secondPrevRel, (typeInt & 0x380000L) << 13));
            record.setSecondNextRel(NeoStoreFormatUtils.longFromIntAndMod(secondNextRel, (typeInt & 0x70000L) << 16));
            record.setFirstInFirstChain((extraByte & 1) != 0);
            record.setFirstInSecondChain((extraByte & 2) != 0);
            record.setNextProp(NeoStoreFormatUtils.longFromIntAndMod(nextProp, (inUseByte & 0xF0L) << 28));
        }

        @Override
        public boolean inUse(PageCursor cursor, int offset) {
            return (cursor.getByte(offset + 0) & 1) == 1;
        }
    }
}

