/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Iterator;
import java.util.Map;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.cursor.Cursor;
import org.neo4j.graphdb.Direction;
import org.neo4j.helpers.Function;
import org.neo4j.kernel.api.DataWriteOperations;
import org.neo4j.kernel.api.LegacyIndexHits;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.RelationshipTypeIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.legacyindex.LegacyIndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.AddIndexFailureException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyConstrainedException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyIndexedException;
import org.neo4j.kernel.api.exceptions.schema.ConstraintValidationKernelException;
import org.neo4j.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.DropConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.DropIndexFailureException;
import org.neo4j.kernel.api.exceptions.schema.IllegalTokenNameException;
import org.neo4j.kernel.api.exceptions.schema.IndexBrokenKernelException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.exceptions.schema.TooManyLabelsException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.api.StatementOperationParts;
import org.neo4j.kernel.impl.api.operations.CountsOperations;
import org.neo4j.kernel.impl.api.operations.EntityReadOperations;
import org.neo4j.kernel.impl.api.operations.EntityWriteOperations;
import org.neo4j.kernel.impl.api.operations.KeyReadOperations;
import org.neo4j.kernel.impl.api.operations.KeyWriteOperations;
import org.neo4j.kernel.impl.api.operations.LegacyIndexReadOperations;
import org.neo4j.kernel.impl.api.operations.LegacyIndexWriteOperations;
import org.neo4j.kernel.impl.api.operations.LockOperations;
import org.neo4j.kernel.impl.api.operations.SchemaReadOperations;
import org.neo4j.kernel.impl.api.operations.SchemaStateOperations;
import org.neo4j.kernel.impl.api.operations.SchemaWriteOperations;
import org.neo4j.kernel.impl.core.Token;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.util.register.NeoRegister;
import org.neo4j.register.Register;

public class OperationsFacade
implements ReadOperations,
DataWriteOperations,
org.neo4j.kernel.api.SchemaWriteOperations {
    final KernelStatement statement;
    private final StatementOperationParts operations;

    OperationsFacade(KernelStatement statement, StatementOperationParts operations) {
        this.statement = statement;
        this.operations = operations;
    }

    final KeyReadOperations tokenRead() {
        return this.operations.keyReadOperations();
    }

    final KeyWriteOperations tokenWrite() {
        return this.operations.keyWriteOperations();
    }

    final EntityReadOperations dataRead() {
        return this.operations.entityReadOperations();
    }

    final EntityWriteOperations dataWrite() {
        return this.operations.entityWriteOperations();
    }

    final LegacyIndexWriteOperations legacyIndexWrite() {
        return this.operations.legacyIndexWriteOperations();
    }

    final LegacyIndexReadOperations legacyIndexRead() {
        return this.operations.legacyIndexReadOperations();
    }

    final SchemaReadOperations schemaRead() {
        return this.operations.schemaReadOperations();
    }

    final SchemaWriteOperations schemaWrite() {
        return this.operations.schemaWriteOperations();
    }

    final SchemaStateOperations schemaState() {
        return this.operations.schemaStateOperations();
    }

    final LockOperations locking() {
        return this.operations.locking();
    }

    final CountsOperations counting() {
        return this.operations.counting();
    }

    @Override
    public PrimitiveLongIterator nodesGetAll() {
        this.statement.assertOpen();
        return this.dataRead().nodesGetAll(this.statement);
    }

    @Override
    public PrimitiveLongIterator relationshipsGetAll() {
        this.statement.assertOpen();
        return this.dataRead().relationshipsGetAll(this.statement);
    }

    @Override
    public PrimitiveLongIterator nodesGetForLabel(int labelId) {
        this.statement.assertOpen();
        if (labelId == -1) {
            return PrimitiveLongCollections.emptyIterator();
        }
        return this.dataRead().nodesGetForLabel(this.statement, labelId);
    }

    @Override
    public PrimitiveLongIterator nodesGetFromIndexLookup(IndexDescriptor index, Object value) throws IndexNotFoundKernelException {
        this.statement.assertOpen();
        return this.dataRead().nodesGetFromIndexLookup(this.statement, index, value);
    }

    @Override
    public long nodeGetUniqueFromIndexLookup(IndexDescriptor index, Object value) throws IndexNotFoundKernelException, IndexBrokenKernelException {
        this.statement.assertOpen();
        return this.dataRead().nodeGetUniqueFromIndexLookup(this.statement, index, value);
    }

    @Override
    public boolean nodeExists(long nodeId) {
        this.statement.assertOpen();
        return this.dataRead().nodeExists(this.statement, nodeId);
    }

    @Override
    public boolean relationshipExists(long relId) {
        this.statement.assertOpen();
        return this.dataRead().relationshipExists(this.statement, relId);
    }

    @Override
    public boolean nodeHasLabel(long nodeId, int labelId) throws EntityNotFoundException {
        this.statement.assertOpen();
        return labelId != -1 && this.dataRead().nodeHasLabel(this.statement, nodeId, labelId);
    }

    @Override
    public PrimitiveIntIterator nodeGetLabels(long nodeId) throws EntityNotFoundException {
        this.statement.assertOpen();
        return this.dataRead().nodeGetLabels(this.statement, nodeId);
    }

    @Override
    public Property nodeGetProperty(long nodeId, int propertyKeyId) throws EntityNotFoundException {
        this.statement.assertOpen();
        if (propertyKeyId == -1) {
            return Property.noNodeProperty(nodeId, propertyKeyId);
        }
        return this.dataRead().nodeGetProperty(this.statement, nodeId, propertyKeyId);
    }

    @Override
    public PrimitiveLongIterator nodeGetRelationships(long nodeId, Direction direction, int[] relTypes) throws EntityNotFoundException {
        this.statement.assertOpen();
        return this.dataRead().nodeGetRelationships(this.statement, nodeId, direction, relTypes);
    }

    @Override
    public PrimitiveLongIterator nodeGetRelationships(long nodeId, Direction direction) throws EntityNotFoundException {
        this.statement.assertOpen();
        return this.dataRead().nodeGetRelationships(this.statement, nodeId, direction);
    }

    @Override
    public int nodeGetDegree(long nodeId, Direction direction, int relType) throws EntityNotFoundException {
        this.statement.assertOpen();
        return this.dataRead().nodeGetDegree(this.statement, nodeId, direction, relType);
    }

    @Override
    public int nodeGetDegree(long nodeId, Direction direction) throws EntityNotFoundException {
        this.statement.assertOpen();
        return this.dataRead().nodeGetDegree(this.statement, nodeId, direction);
    }

    @Override
    public PrimitiveIntIterator nodeGetRelationshipTypes(long nodeId) throws EntityNotFoundException {
        this.statement.assertOpen();
        return this.dataRead().nodeGetRelationshipTypes(this.statement, nodeId);
    }

    @Override
    public Property relationshipGetProperty(long relationshipId, int propertyKeyId) throws EntityNotFoundException {
        this.statement.assertOpen();
        if (propertyKeyId == -1) {
            return Property.noRelationshipProperty(relationshipId, propertyKeyId);
        }
        return this.dataRead().relationshipGetProperty(this.statement, relationshipId, propertyKeyId);
    }

    @Override
    public Property graphGetProperty(int propertyKeyId) {
        this.statement.assertOpen();
        if (propertyKeyId == -1) {
            return Property.noGraphProperty(propertyKeyId);
        }
        return this.dataRead().graphGetProperty(this.statement, propertyKeyId);
    }

    @Override
    public PrimitiveLongIterator nodeGetAllPropertiesKeys(long nodeId) throws EntityNotFoundException {
        this.statement.assertOpen();
        return this.dataRead().nodeGetPropertyKeys(this.statement, nodeId);
    }

    @Override
    public Iterator<DefinedProperty> nodeGetAllProperties(long nodeId) throws EntityNotFoundException {
        this.statement.assertOpen();
        return this.dataRead().nodeGetAllProperties(this.statement, nodeId);
    }

    @Override
    public PrimitiveLongIterator relationshipGetAllPropertiesKeys(long nodeId) throws EntityNotFoundException {
        this.statement.assertOpen();
        return this.dataRead().relationshipGetPropertyKeys(this.statement, nodeId);
    }

    @Override
    public Iterator<DefinedProperty> relationshipGetAllProperties(long relationshipId) throws EntityNotFoundException {
        this.statement.assertOpen();
        return this.dataRead().relationshipGetAllProperties(this.statement, relationshipId);
    }

    @Override
    public Iterator<DefinedProperty> graphGetAllProperties() {
        this.statement.assertOpen();
        return this.dataRead().graphGetAllProperties(this.statement);
    }

    @Override
    public <EXCEPTION extends Exception> void relationshipVisit(long relId, RelationshipVisitor<EXCEPTION> visitor) throws EntityNotFoundException, EXCEPTION {
        this.statement.assertOpen();
        this.dataRead().relationshipVisit(this.statement, relId, visitor);
    }

    @Override
    public Cursor expand(Cursor inputCursor, NeoRegister.Node.In nodeId, Register.Object.In<int[]> types, Register.Object.In<Direction> expandDirection, NeoRegister.Relationship.Out relId, NeoRegister.RelType.Out relType, Register.Object.Out<Direction> direction, NeoRegister.Node.Out startNodeId, NeoRegister.Node.Out neighborNodeId) {
        this.statement.assertOpen();
        return this.dataRead().expand(this.statement, inputCursor, nodeId, types, expandDirection, relId, relType, direction, startNodeId, neighborNodeId);
    }

    @Override
    public Cursor nodeGetRelationships(long nodeId, Direction direction, RelationshipVisitor<? extends RuntimeException> visitor) throws EntityNotFoundException {
        this.statement.assertOpen();
        return this.dataRead().nodeGetRelationships(this.statement, nodeId, direction, visitor);
    }

    @Override
    public Cursor nodeGetRelationships(long nodeId, Direction direction, int[] types, RelationshipVisitor<? extends RuntimeException> visitor) throws EntityNotFoundException {
        this.statement.assertOpen();
        return this.dataRead().nodeGetRelationships(this.statement, nodeId, direction, types, visitor);
    }

    @Override
    public IndexDescriptor indexesGetForLabelAndPropertyKey(int labelId, int propertyKeyId) throws SchemaRuleNotFoundException {
        this.statement.assertOpen();
        IndexDescriptor descriptor = this.schemaRead().indexesGetForLabelAndPropertyKey(this.statement, labelId, propertyKeyId);
        if (descriptor == null) {
            throw new SchemaRuleNotFoundException(labelId, propertyKeyId, "not found");
        }
        return descriptor;
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetForLabel(int labelId) {
        this.statement.assertOpen();
        return this.schemaRead().indexesGetForLabel(this.statement, labelId);
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetAll() {
        this.statement.assertOpen();
        return this.schemaRead().indexesGetAll(this.statement);
    }

    @Override
    public IndexDescriptor uniqueIndexGetForLabelAndPropertyKey(int labelId, int propertyKeyId) throws SchemaRuleNotFoundException {
        IndexDescriptor result = null;
        Iterator<IndexDescriptor> indexes = this.uniqueIndexesGetForLabel(labelId);
        while (indexes.hasNext()) {
            IndexDescriptor index = indexes.next();
            if (index.getPropertyKeyId() != propertyKeyId) continue;
            if (null == result) {
                result = index;
                continue;
            }
            throw new SchemaRuleNotFoundException(labelId, propertyKeyId, "duplicate uniqueness index");
        }
        if (null == result) {
            throw new SchemaRuleNotFoundException(labelId, propertyKeyId, "uniqueness index not found");
        }
        return result;
    }

    @Override
    public Iterator<IndexDescriptor> uniqueIndexesGetForLabel(int labelId) {
        this.statement.assertOpen();
        return this.schemaRead().uniqueIndexesGetForLabel(this.statement, labelId);
    }

    @Override
    public Long indexGetOwningUniquenessConstraintId(IndexDescriptor index) throws SchemaRuleNotFoundException {
        this.statement.assertOpen();
        return this.schemaRead().indexGetOwningUniquenessConstraintId(this.statement, index);
    }

    @Override
    public Iterator<IndexDescriptor> uniqueIndexesGetAll() {
        this.statement.assertOpen();
        return this.schemaRead().uniqueIndexesGetAll(this.statement);
    }

    @Override
    public InternalIndexState indexGetState(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        this.statement.assertOpen();
        return this.schemaRead().indexGetState(this.statement, descriptor);
    }

    @Override
    public double indexUniqueValuesSelectivity(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        this.statement.assertOpen();
        return this.schemaRead().indexUniqueValuesPercentage(this.statement, descriptor);
    }

    @Override
    public String indexGetFailure(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        this.statement.assertOpen();
        return this.schemaRead().indexGetFailure(this.statement, descriptor);
    }

    @Override
    public Iterator<UniquenessConstraint> constraintsGetForLabelAndPropertyKey(int labelId, int propertyKeyId) {
        this.statement.assertOpen();
        return this.schemaRead().constraintsGetForLabelAndPropertyKey(this.statement, labelId, propertyKeyId);
    }

    @Override
    public Iterator<UniquenessConstraint> constraintsGetForLabel(int labelId) {
        this.statement.assertOpen();
        return this.schemaRead().constraintsGetForLabel(this.statement, labelId);
    }

    @Override
    public Iterator<UniquenessConstraint> constraintsGetAll() {
        this.statement.assertOpen();
        return this.schemaRead().constraintsGetAll(this.statement);
    }

    @Override
    public int labelGetForName(String labelName) {
        this.statement.assertOpen();
        return this.tokenRead().labelGetForName(this.statement, labelName);
    }

    @Override
    public String labelGetName(int labelId) throws LabelNotFoundKernelException {
        this.statement.assertOpen();
        return this.tokenRead().labelGetName(this.statement, labelId);
    }

    @Override
    public int propertyKeyGetForName(String propertyKeyName) {
        this.statement.assertOpen();
        return this.tokenRead().propertyKeyGetForName(this.statement, propertyKeyName);
    }

    @Override
    public String propertyKeyGetName(int propertyKeyId) throws PropertyKeyIdNotFoundKernelException {
        this.statement.assertOpen();
        return this.tokenRead().propertyKeyGetName(this.statement, propertyKeyId);
    }

    @Override
    public Iterator<Token> propertyKeyGetAllTokens() {
        this.statement.assertOpen();
        return this.tokenRead().propertyKeyGetAllTokens(this.statement);
    }

    @Override
    public Iterator<Token> labelsGetAllTokens() {
        this.statement.assertOpen();
        return this.tokenRead().labelsGetAllTokens(this.statement);
    }

    @Override
    public int relationshipTypeGetForName(String relationshipTypeName) {
        this.statement.assertOpen();
        return this.tokenRead().relationshipTypeGetForName(this.statement, relationshipTypeName);
    }

    @Override
    public String relationshipTypeGetName(int relationshipTypeId) throws RelationshipTypeIdNotFoundKernelException {
        this.statement.assertOpen();
        return this.tokenRead().relationshipTypeGetName(this.statement, relationshipTypeId);
    }

    @Override
    public int labelGetOrCreateForName(String labelName) throws IllegalTokenNameException, TooManyLabelsException {
        this.statement.assertOpen();
        return this.tokenWrite().labelGetOrCreateForName(this.statement, labelName);
    }

    @Override
    public int propertyKeyGetOrCreateForName(String propertyKeyName) throws IllegalTokenNameException {
        this.statement.assertOpen();
        return this.tokenWrite().propertyKeyGetOrCreateForName(this.statement, propertyKeyName);
    }

    @Override
    public int relationshipTypeGetOrCreateForName(String relationshipTypeName) throws IllegalTokenNameException {
        this.statement.assertOpen();
        return this.tokenWrite().relationshipTypeGetOrCreateForName(this.statement, relationshipTypeName);
    }

    @Override
    public void labelCreateForName(String labelName, int id) throws IllegalTokenNameException, TooManyLabelsException {
        this.statement.assertOpen();
        this.tokenWrite().labelCreateForName(this.statement, labelName, id);
    }

    @Override
    public void propertyKeyCreateForName(String propertyKeyName, int id) throws IllegalTokenNameException {
        this.statement.assertOpen();
        this.tokenWrite().propertyKeyCreateForName(this.statement, propertyKeyName, id);
    }

    @Override
    public void relationshipTypeCreateForName(String relationshipTypeName, int id) throws IllegalTokenNameException {
        this.statement.assertOpen();
        this.tokenWrite().relationshipTypeCreateForName(this.statement, relationshipTypeName, id);
    }

    @Override
    public <K, V> V schemaStateGetOrCreate(K key, Function<K, V> creator) {
        return this.schemaState().schemaStateGetOrCreate(this.statement, key, creator);
    }

    @Override
    public void schemaStateFlush() {
        this.schemaState().schemaStateFlush(this.statement);
    }

    @Override
    public long nodeCreate() {
        this.statement.assertOpen();
        return this.dataWrite().nodeCreate(this.statement);
    }

    @Override
    public void nodeDelete(long nodeId) throws EntityNotFoundException {
        this.statement.assertOpen();
        this.dataWrite().nodeDelete(this.statement, nodeId);
    }

    @Override
    public long relationshipCreate(int relationshipTypeId, long startNodeId, long endNodeId) throws RelationshipTypeIdNotFoundKernelException, EntityNotFoundException {
        this.statement.assertOpen();
        return this.dataWrite().relationshipCreate(this.statement, relationshipTypeId, startNodeId, endNodeId);
    }

    @Override
    public void relationshipDelete(long relationshipId) throws EntityNotFoundException {
        this.statement.assertOpen();
        this.dataWrite().relationshipDelete(this.statement, relationshipId);
    }

    @Override
    public boolean nodeAddLabel(long nodeId, int labelId) throws EntityNotFoundException, ConstraintValidationKernelException {
        this.statement.assertOpen();
        return this.dataWrite().nodeAddLabel(this.statement, nodeId, labelId);
    }

    @Override
    public boolean nodeRemoveLabel(long nodeId, int labelId) throws EntityNotFoundException {
        this.statement.assertOpen();
        return this.dataWrite().nodeRemoveLabel(this.statement, nodeId, labelId);
    }

    @Override
    public Property nodeSetProperty(long nodeId, DefinedProperty property) throws EntityNotFoundException, ConstraintValidationKernelException {
        this.statement.assertOpen();
        return this.dataWrite().nodeSetProperty(this.statement, nodeId, property);
    }

    @Override
    public Property relationshipSetProperty(long relationshipId, DefinedProperty property) throws EntityNotFoundException {
        this.statement.assertOpen();
        return this.dataWrite().relationshipSetProperty(this.statement, relationshipId, property);
    }

    @Override
    public Property graphSetProperty(DefinedProperty property) {
        this.statement.assertOpen();
        return this.dataWrite().graphSetProperty(this.statement, property);
    }

    @Override
    public Property nodeRemoveProperty(long nodeId, int propertyKeyId) throws EntityNotFoundException {
        this.statement.assertOpen();
        return this.dataWrite().nodeRemoveProperty(this.statement, nodeId, propertyKeyId);
    }

    @Override
    public Property relationshipRemoveProperty(long relationshipId, int propertyKeyId) throws EntityNotFoundException {
        this.statement.assertOpen();
        return this.dataWrite().relationshipRemoveProperty(this.statement, relationshipId, propertyKeyId);
    }

    @Override
    public Property graphRemoveProperty(int propertyKeyId) {
        this.statement.assertOpen();
        return this.dataWrite().graphRemoveProperty(this.statement, propertyKeyId);
    }

    @Override
    public IndexDescriptor indexCreate(int labelId, int propertyKeyId) throws AddIndexFailureException, AlreadyIndexedException, AlreadyConstrainedException {
        this.statement.assertOpen();
        return this.schemaWrite().indexCreate(this.statement, labelId, propertyKeyId);
    }

    @Override
    public void indexDrop(IndexDescriptor descriptor) throws DropIndexFailureException {
        this.statement.assertOpen();
        this.schemaWrite().indexDrop(this.statement, descriptor);
    }

    @Override
    public UniquenessConstraint uniquenessConstraintCreate(int labelId, int propertyKeyId) throws CreateConstraintFailureException, AlreadyConstrainedException, AlreadyIndexedException {
        this.statement.assertOpen();
        return this.schemaWrite().uniquenessConstraintCreate(this.statement, labelId, propertyKeyId);
    }

    @Override
    public void constraintDrop(UniquenessConstraint constraint) throws DropConstraintFailureException {
        this.statement.assertOpen();
        this.schemaWrite().constraintDrop(this.statement, constraint);
    }

    @Override
    public void uniqueIndexDrop(IndexDescriptor descriptor) throws DropIndexFailureException {
        this.statement.assertOpen();
        this.schemaWrite().uniqueIndexDrop(this.statement, descriptor);
    }

    @Override
    public void acquireExclusive(Locks.ResourceType type, long ... id) {
        this.statement.assertOpen();
        this.locking().acquireExclusive(this.statement, type, id);
    }

    @Override
    public void acquireShared(Locks.ResourceType type, long ... id) {
        this.statement.assertOpen();
        this.locking().acquireShared(this.statement, type, id);
    }

    @Override
    public void releaseExclusive(Locks.ResourceType type, long ... id) {
        this.statement.assertOpen();
        this.locking().releaseExclusive(this.statement, type, id);
    }

    @Override
    public void releaseShared(Locks.ResourceType type, long ... id) {
        this.statement.assertOpen();
        this.locking().releaseShared(this.statement, type, id);
    }

    @Override
    public LegacyIndexHits nodeLegacyIndexGet(String indexName, String key, Object value) throws LegacyIndexNotFoundKernelException {
        this.statement.assertOpen();
        return this.legacyIndexRead().nodeLegacyIndexGet(this.statement, indexName, key, value);
    }

    @Override
    public LegacyIndexHits nodeLegacyIndexQuery(String indexName, String key, Object queryOrQueryObject) throws LegacyIndexNotFoundKernelException {
        this.statement.assertOpen();
        return this.legacyIndexRead().nodeLegacyIndexQuery(this.statement, indexName, key, queryOrQueryObject);
    }

    @Override
    public LegacyIndexHits nodeLegacyIndexQuery(String indexName, Object queryOrQueryObject) throws LegacyIndexNotFoundKernelException {
        this.statement.assertOpen();
        return this.legacyIndexRead().nodeLegacyIndexQuery(this.statement, indexName, queryOrQueryObject);
    }

    @Override
    public LegacyIndexHits relationshipLegacyIndexGet(String indexName, String key, Object value, long startNode, long endNode) throws LegacyIndexNotFoundKernelException {
        this.statement.assertOpen();
        return this.legacyIndexRead().relationshipLegacyIndexGet(this.statement, indexName, key, value, startNode, endNode);
    }

    @Override
    public LegacyIndexHits relationshipLegacyIndexQuery(String indexName, String key, Object queryOrQueryObject, long startNode, long endNode) throws LegacyIndexNotFoundKernelException {
        this.statement.assertOpen();
        return this.legacyIndexRead().relationshipLegacyIndexQuery(this.statement, indexName, key, queryOrQueryObject, startNode, endNode);
    }

    @Override
    public LegacyIndexHits relationshipLegacyIndexQuery(String indexName, Object queryOrQueryObject, long startNode, long endNode) throws LegacyIndexNotFoundKernelException {
        this.statement.assertOpen();
        return this.legacyIndexRead().relationshipLegacyIndexQuery(this.statement, indexName, queryOrQueryObject, startNode, endNode);
    }

    @Override
    public void nodeLegacyIndexCreateLazily(String indexName, Map<String, String> customConfig) {
        this.statement.assertOpen();
        this.legacyIndexWrite().nodeLegacyIndexCreateLazily(this.statement, indexName, customConfig);
    }

    @Override
    public void nodeLegacyIndexCreate(String indexName, Map<String, String> customConfig) {
        this.statement.assertOpen();
        this.legacyIndexWrite().nodeLegacyIndexCreate(this.statement, indexName, customConfig);
    }

    @Override
    public void relationshipLegacyIndexCreateLazily(String indexName, Map<String, String> customConfig) {
        this.statement.assertOpen();
        this.legacyIndexWrite().relationshipLegacyIndexCreateLazily(this.statement, indexName, customConfig);
    }

    @Override
    public void relationshipLegacyIndexCreate(String indexName, Map<String, String> customConfig) {
        this.statement.assertOpen();
        this.legacyIndexWrite().relationshipLegacyIndexCreate(this.statement, indexName, customConfig);
    }

    @Override
    public void nodeAddToLegacyIndex(String indexName, long node, String key, Object value) throws EntityNotFoundException, LegacyIndexNotFoundKernelException {
        this.statement.assertOpen();
        this.legacyIndexWrite().nodeAddToLegacyIndex(this.statement, indexName, node, key, value);
    }

    @Override
    public void nodeRemoveFromLegacyIndex(String indexName, long node, String key, Object value) throws LegacyIndexNotFoundKernelException {
        this.statement.assertOpen();
        this.legacyIndexWrite().nodeRemoveFromLegacyIndex(this.statement, indexName, node, key, value);
    }

    @Override
    public void nodeRemoveFromLegacyIndex(String indexName, long node, String key) throws LegacyIndexNotFoundKernelException {
        this.statement.assertOpen();
        this.legacyIndexWrite().nodeRemoveFromLegacyIndex(this.statement, indexName, node, key);
    }

    @Override
    public void nodeRemoveFromLegacyIndex(String indexName, long node) throws LegacyIndexNotFoundKernelException {
        this.statement.assertOpen();
        this.legacyIndexWrite().nodeRemoveFromLegacyIndex(this.statement, indexName, node);
    }

    @Override
    public void relationshipAddToLegacyIndex(String indexName, long relationship, String key, Object value) throws EntityNotFoundException, LegacyIndexNotFoundKernelException {
        this.statement.assertOpen();
        this.legacyIndexWrite().relationshipAddToLegacyIndex(this.statement, indexName, relationship, key, value);
    }

    @Override
    public void relationshipRemoveFromLegacyIndex(String indexName, long relationship, String key, Object value) throws EntityNotFoundException, LegacyIndexNotFoundKernelException {
        this.statement.assertOpen();
        this.legacyIndexWrite().relationshipRemoveFromLegacyIndex(this.statement, indexName, relationship, key, value);
    }

    @Override
    public void relationshipRemoveFromLegacyIndex(String indexName, long relationship, String key) throws LegacyIndexNotFoundKernelException, EntityNotFoundException {
        this.statement.assertOpen();
        this.legacyIndexWrite().relationshipRemoveFromLegacyIndex(this.statement, indexName, relationship, key);
    }

    @Override
    public void relationshipRemoveFromLegacyIndex(String indexName, long relationship) throws LegacyIndexNotFoundKernelException, EntityNotFoundException {
        this.statement.assertOpen();
        this.legacyIndexWrite().relationshipRemoveFromLegacyIndex(this.statement, indexName, relationship);
    }

    @Override
    public void nodeLegacyIndexDrop(String indexName) throws LegacyIndexNotFoundKernelException {
        this.statement.assertOpen();
        this.legacyIndexWrite().nodeLegacyIndexDrop(this.statement, indexName);
    }

    @Override
    public void relationshipLegacyIndexDrop(String indexName) throws LegacyIndexNotFoundKernelException {
        this.statement.assertOpen();
        this.legacyIndexWrite().relationshipLegacyIndexDrop(this.statement, indexName);
    }

    @Override
    public Map<String, String> nodeLegacyIndexGetConfiguration(String indexName) throws LegacyIndexNotFoundKernelException {
        this.statement.assertOpen();
        return this.legacyIndexRead().nodeLegacyIndexGetConfiguration(this.statement, indexName);
    }

    @Override
    public Map<String, String> relationshipLegacyIndexGetConfiguration(String indexName) throws LegacyIndexNotFoundKernelException {
        this.statement.assertOpen();
        return this.legacyIndexRead().relationshipLegacyIndexGetConfiguration(this.statement, indexName);
    }

    @Override
    public String nodeLegacyIndexSetConfiguration(String indexName, String key, String value) throws LegacyIndexNotFoundKernelException {
        this.statement.assertOpen();
        return this.legacyIndexWrite().nodeLegacyIndexSetConfiguration(this.statement, indexName, key, value);
    }

    @Override
    public String relationshipLegacyIndexSetConfiguration(String indexName, String key, String value) throws LegacyIndexNotFoundKernelException {
        this.statement.assertOpen();
        return this.legacyIndexWrite().relationshipLegacyIndexSetConfiguration(this.statement, indexName, key, value);
    }

    @Override
    public String nodeLegacyIndexRemoveConfiguration(String indexName, String key) throws LegacyIndexNotFoundKernelException {
        this.statement.assertOpen();
        return this.legacyIndexWrite().nodeLegacyIndexRemoveConfiguration(this.statement, indexName, key);
    }

    @Override
    public String relationshipLegacyIndexRemoveConfiguration(String indexName, String key) throws LegacyIndexNotFoundKernelException {
        this.statement.assertOpen();
        return this.legacyIndexWrite().relationshipLegacyIndexRemoveConfiguration(this.statement, indexName, key);
    }

    @Override
    public String[] nodeLegacyIndexesGetAll() {
        this.statement.assertOpen();
        return this.legacyIndexRead().nodeLegacyIndexesGetAll(this.statement);
    }

    @Override
    public String[] relationshipLegacyIndexesGetAll() {
        this.statement.assertOpen();
        return this.legacyIndexRead().relationshipLegacyIndexesGetAll(this.statement);
    }

    @Override
    public long countsForNode(int labelId) {
        this.statement.assertOpen();
        return this.counting().countsForNode(this.statement, labelId);
    }

    @Override
    public long countsForRelationship(int startLabelId, int typeId, int endLabelId) {
        this.statement.assertOpen();
        return this.counting().countsForRelationship(this.statement, startLabelId, typeId, endLabelId);
    }
}

