/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import java.util.List;
import org.neo4j.helpers.Triplet;

public class AsciiDocListGenerator {
    private static final String IFDEF_HTMLOUTPUT = "ifndef::nonhtmloutput[]\n";
    private static final String IFDEF_NONHTMLOUTPUT = "ifdef::nonhtmloutput[]\n";
    private static final String ENDIF = "endif::nonhtmloutput[]\n";
    private String listId;
    private String title;
    private boolean shortenDescription;

    public AsciiDocListGenerator(String listId, String title, boolean shortenDescription) {
        this.listId = listId;
        this.title = title;
        this.shortenDescription = shortenDescription;
    }

    public String generateListAndTableCombo(List<Triplet<String, String, String>> items) {
        StringBuilder sb = new StringBuilder(200 * items.size());
        StringBuilder print = new StringBuilder(100 * items.size());
        if (this.listId != null) {
            sb.append("[[").append(this.listId).append("]]\n");
        }
        if (this.title != null) {
            sb.append('.').append(this.title).append('\n');
        }
        sb.append(IFDEF_HTMLOUTPUT).append('\n').append("[options=\"header\"]\n").append("|===\n").append("|Name|Description\n");
        print.append(IFDEF_NONHTMLOUTPUT).append('\n');
        for (Triplet<String, String, String> item : items) {
            int pos;
            String id = item.first();
            String name = item.second();
            String description = item.third();
            if (this.shortenDescription && (pos = description.indexOf(". ")) > 10) {
                description = description.substring(0, pos + 1);
            }
            sb.append("|<<").append(id).append(',').append(name).append(">>|").append(description);
            print.append("* <<").append(id).append(',').append(name).append(">>: ").append(description);
            if (!description.endsWith(".")) {
                sb.append('.');
                print.append('.');
            }
            sb.append('\n');
            print.append('\n');
        }
        sb.append("|===\n").append(ENDIF);
        print.append(ENDIF).append('\n');
        sb.append(print.toString());
        return sb.toString();
    }
}

