/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.properties;

interface ArrayValue {
    public int length();

    public static final class NumberArray
    implements IntegralArray,
    FloatingPointArray {
        private final Number[] value;

        static IntegralArray asIntegral(Number[] value) {
            return new NumberArray(value);
        }

        static FloatingPointArray asFloatingPoint(Number[] value) {
            return new NumberArray(value);
        }

        private NumberArray(Number[] value) {
            this.value = value;
        }

        @Override
        public int length() {
            return this.value.length;
        }

        @Override
        public long longValue(int index) {
            return this.value[index].longValue();
        }

        @Override
        public double doubleValue(int index) {
            return this.value[index].doubleValue();
        }
    }

    public static final class DoubleArray
    implements FloatingPointArray {
        private final double[] value;

        DoubleArray(double[] value) {
            this.value = value;
        }

        @Override
        public int length() {
            return this.value.length;
        }

        @Override
        public double doubleValue(int index) {
            return this.value[index];
        }
    }

    public static final class FloatArray
    implements FloatingPointArray {
        private final float[] value;

        FloatArray(float[] value) {
            this.value = value;
        }

        @Override
        public int length() {
            return this.value.length;
        }

        @Override
        public double doubleValue(int index) {
            return this.value[index];
        }
    }

    public static final class LongArray
    implements IntegralArray {
        private final long[] value;

        LongArray(long[] value) {
            this.value = value;
        }

        @Override
        public int length() {
            return this.value.length;
        }

        @Override
        public long longValue(int index) {
            return this.value[index];
        }
    }

    public static final class IntArray
    implements IntegralArray {
        private final int[] value;

        IntArray(int[] value) {
            this.value = value;
        }

        @Override
        public int length() {
            return this.value.length;
        }

        @Override
        public long longValue(int index) {
            return this.value[index];
        }
    }

    public static final class ShortArray
    implements IntegralArray {
        private final short[] value;

        ShortArray(short[] value) {
            this.value = value;
        }

        @Override
        public int length() {
            return this.value.length;
        }

        @Override
        public long longValue(int index) {
            return this.value[index];
        }
    }

    public static final class ByteArray
    implements IntegralArray {
        private final byte[] value;

        ByteArray(byte[] value) {
            this.value = value;
        }

        @Override
        public int length() {
            return this.value.length;
        }

        @Override
        public long longValue(int index) {
            return this.value[index];
        }
    }

    public static interface FloatingPointArray
    extends ArrayValue {
        public double doubleValue(int var1);
    }

    public static interface IntegralArray
    extends ArrayValue {
        public long longValue(int var1);
    }
}

