/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.schema;

import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.exceptions.schema.SchemaKernelException;

public class SchemaRuleNotFoundException
extends SchemaKernelException {
    private static final String RULE_NOT_FOUND_MESSAGE_TEMPLATE = "Index rule(s) for label '%s' and property '%s': %s.";
    private final int labelId;
    private final int propertyKeyId;
    private final String reason;

    public SchemaRuleNotFoundException(int labelId, int propertyKeyId, String reason) {
        super(Status.Schema.NoSuchSchemaRule, String.format(RULE_NOT_FOUND_MESSAGE_TEMPLATE, labelId, propertyKeyId, reason));
        this.labelId = labelId;
        this.propertyKeyId = propertyKeyId;
        this.reason = reason;
    }

    @Override
    public String getUserMessage(TokenNameLookup tokenNameLookup) {
        return String.format(RULE_NOT_FOUND_MESSAGE_TEMPLATE, tokenNameLookup.labelGetName(this.labelId), tokenNameLookup.propertyKeyGetName(this.propertyKeyId), this.reason);
    }
}

