/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Expander;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipExpander;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.traversal.BranchState;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.collection.ArrayIterator;
import org.neo4j.helpers.collection.FilteringIterator;
import org.neo4j.helpers.collection.IteratorWrapper;
import org.neo4j.helpers.collection.NestingIterator;
import org.neo4j.kernel.Expansion;
import org.neo4j.kernel.ExtendedPath;
import org.neo4j.kernel.impl.util.SingleNodePath;

public abstract class StandardExpander
implements Expander,
PathExpander {
    public static final StandardExpander DEFAULT = new AllExpander(Direction.BOTH){

        @Override
        public StandardExpander add(RelationshipType type, Direction direction) {
            return 1.create(type, direction);
        }
    };
    public static final StandardExpander EMPTY = new RegularExpander(Collections.emptyMap());

    private StandardExpander() {
    }

    public final Expansion<Relationship> expand(Node node) {
        return new RelationshipExpansion(this, new SingleNodePath(node), BranchState.NO_STATE);
    }

    public final Expansion<Relationship> expand(Path path, BranchState state) {
        return new RelationshipExpansion(this, path, state);
    }

    static <T> T[] append(T[] array, T item) {
        Object[] result = (Object[])Array.newInstance(array.getClass().getComponentType(), array.length + 1);
        System.arraycopy(array, 0, result, 0, array.length);
        result[array.length] = item;
        return result;
    }

    static boolean matchDirection(Direction dir, Node start, Relationship rel) {
        switch (dir) {
            case INCOMING: {
                return rel.getEndNode().equals(start);
            }
            case OUTGOING: {
                return rel.getStartNode().equals(start);
            }
            case BOTH: {
                return true;
            }
        }
        return true;
    }

    abstract Iterator<Relationship> doExpand(Path var1, BranchState var2);

    public final String toString() {
        StringBuilder result = new StringBuilder("Expander[");
        this.buildString(result);
        result.append("]");
        return result.toString();
    }

    abstract void buildString(StringBuilder var1);

    @Override
    public final StandardExpander add(RelationshipType type) {
        return this.add(type, Direction.BOTH);
    }

    @Override
    public abstract StandardExpander add(RelationshipType var1, Direction var2);

    @Override
    public abstract StandardExpander remove(RelationshipType var1);

    public abstract StandardExpander reverse();

    @Override
    public abstract StandardExpander reversed();

    @Override
    public StandardExpander addNodeFilter(Predicate<? super Node> filter) {
        return new FilteringExpander(this, new NodeFilter(filter));
    }

    @Override
    public final Expander addRelationsipFilter(Predicate<? super Relationship> filter) {
        return this.addRelationshipFilter((Predicate)filter);
    }

    @Override
    public StandardExpander addRelationshipFilter(Predicate<? super Relationship> filter) {
        return new FilteringExpander(this, new RelationshipFilter(filter));
    }

    static StandardExpander wrap(RelationshipExpander expander) {
        return new WrappingRelationshipExpander(expander);
    }

    static StandardExpander wrap(PathExpander expander) {
        return new WrappingExpander(expander);
    }

    public static PathExpander toPathExpander(RelationshipExpander expander) {
        return expander instanceof PathExpander ? (PathExpander)((Object)expander) : StandardExpander.wrap(expander);
    }

    public static StandardExpander create(Direction direction) {
        return new AllExpander(direction);
    }

    public static StandardExpander create(RelationshipType type, Direction dir) {
        EnumMap<Direction, RelationshipType[]> types = new EnumMap<Direction, RelationshipType[]>(Direction.class);
        types.put(dir, new RelationshipType[]{type});
        return new RegularExpander(types);
    }

    static StandardExpander create(RelationshipType type1, Direction dir1, RelationshipType type2, Direction dir2) {
        Map<Direction, Collection<RelationshipType>> tempMap = StandardExpander.temporaryTypeMap();
        tempMap.get((Object)dir1).add(type1);
        tempMap.get((Object)dir2).add(type2);
        return new RegularExpander(StandardExpander.toTypeMap(tempMap));
    }

    private static Map<Direction, RelationshipType[]> toTypeMap(Map<Direction, Collection<RelationshipType>> tempMap) {
        Collection<RelationshipType> both = tempMap.get((Object)Direction.BOTH);
        tempMap.get((Object)Direction.OUTGOING).removeAll(both);
        tempMap.get((Object)Direction.INCOMING).removeAll(both);
        EnumMap<Direction, RelationshipType[]> map = new EnumMap<Direction, RelationshipType[]>(Direction.class);
        for (Map.Entry<Direction, Collection<RelationshipType>> entry : tempMap.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            map.put(entry.getKey(), entry.getValue().toArray(new RelationshipType[entry.getValue().size()]));
        }
        return map;
    }

    private static Map<Direction, Collection<RelationshipType>> temporaryTypeMap() {
        EnumMap<Direction, Collection<RelationshipType>> map = new EnumMap<Direction, Collection<RelationshipType>>(Direction.class);
        for (Direction direction : Direction.values()) {
            map.put(direction, new ArrayList());
        }
        return map;
    }

    private static Map<Direction, Collection<RelationshipType>> temporaryTypeMapFrom(Map<Direction, RelationshipType[]> typeMap) {
        EnumMap<Direction, Collection<RelationshipType>> map = new EnumMap<Direction, Collection<RelationshipType>>(Direction.class);
        for (Direction direction : Direction.values()) {
            ArrayList<RelationshipType> types = new ArrayList<RelationshipType>();
            map.put(direction, types);
            RelationshipType[] existing = typeMap.get((Object)direction);
            if (existing == null) continue;
            types.addAll(Arrays.asList(existing));
        }
        return map;
    }

    public static StandardExpander create(RelationshipType type1, Direction dir1, RelationshipType type2, Direction dir2, Object ... more) {
        Map<Direction, Collection<RelationshipType>> tempMap = StandardExpander.temporaryTypeMap();
        tempMap.get((Object)dir1).add(type1);
        tempMap.get((Object)dir2).add(type2);
        for (int i = 0; i < more.length; ++i) {
            RelationshipType type = (RelationshipType)more[i++];
            Direction direction = (Direction)((Object)more[i]);
            tempMap.get((Object)direction).add(type);
        }
        return new RegularExpander(StandardExpander.toTypeMap(tempMap));
    }

    private static final class PathFilter
    extends Filter {
        private final Predicate<? super Path> predicate;

        PathFilter(Predicate<? super Path> predicate) {
            this.predicate = predicate;
        }

        public String toString() {
            return this.predicate.toString();
        }

        @Override
        boolean exclude(Path path) {
            return !this.predicate.accept(path);
        }
    }

    private static final class RelationshipFilter
    extends Filter {
        private final Predicate<? super Relationship> predicate;

        RelationshipFilter(Predicate<? super Relationship> predicate) {
            this.predicate = predicate;
        }

        public String toString() {
            return this.predicate.toString();
        }

        @Override
        boolean exclude(Path path) {
            return !this.predicate.accept(path.lastRelationship());
        }
    }

    private static final class NodeFilter
    extends Filter {
        private final Predicate<? super Node> predicate;

        NodeFilter(Predicate<? super Node> predicate) {
            this.predicate = predicate;
        }

        public String toString() {
            return this.predicate.toString();
        }

        @Override
        boolean exclude(Path path) {
            return !this.predicate.accept(path.lastRelationship().getOtherNode(path.endNode()));
        }
    }

    private static abstract class Filter {
        private Filter() {
        }

        abstract boolean exclude(Path var1);
    }

    private static final class WrappingRelationshipExpander
    extends StandardExpander {
        private static final String IMMUTABLE = "Immutable Expander ";
        private final RelationshipExpander expander;

        WrappingRelationshipExpander(RelationshipExpander expander) {
            this.expander = expander;
        }

        @Override
        void buildString(StringBuilder result) {
            result.append(this.expander);
        }

        @Override
        Iterator<Relationship> doExpand(Path path, BranchState state) {
            return this.expander.expand(path.endNode()).iterator();
        }

        @Override
        public StandardExpander add(RelationshipType type, Direction direction) {
            throw new UnsupportedOperationException(IMMUTABLE + this.expander);
        }

        @Override
        public StandardExpander remove(RelationshipType type) {
            throw new UnsupportedOperationException(IMMUTABLE + this.expander);
        }

        @Override
        public StandardExpander reversed() {
            return this.reverse();
        }

        @Override
        public StandardExpander reverse() {
            throw new UnsupportedOperationException(IMMUTABLE + this.expander);
        }
    }

    private static final class WrappingExpander
    extends StandardExpander {
        private static final String IMMUTABLE = "Immutable Expander ";
        private final PathExpander expander;

        WrappingExpander(PathExpander expander) {
            this.expander = expander;
        }

        @Override
        void buildString(StringBuilder result) {
            result.append(this.expander);
        }

        @Override
        Iterator<Relationship> doExpand(Path path, BranchState state) {
            return this.expander.expand(path, state).iterator();
        }

        @Override
        public StandardExpander add(RelationshipType type, Direction direction) {
            throw new UnsupportedOperationException(IMMUTABLE + this.expander);
        }

        @Override
        public StandardExpander remove(RelationshipType type) {
            throw new UnsupportedOperationException(IMMUTABLE + this.expander);
        }

        @Override
        public StandardExpander reversed() {
            return this.reverse();
        }

        @Override
        public StandardExpander reverse() {
            throw new UnsupportedOperationException(IMMUTABLE + this.expander);
        }
    }

    private static final class FilteringExpander
    extends StandardExpander {
        private final StandardExpander expander;
        private final Filter[] filters;

        FilteringExpander(StandardExpander expander, Filter ... filters) {
            this.expander = expander;
            this.filters = filters;
        }

        @Override
        void buildString(StringBuilder result) {
            this.expander.buildString(result);
            result.append("; filter:");
            for (Filter filter : this.filters) {
                result.append(" ");
                result.append(filter);
            }
        }

        @Override
        Iterator<Relationship> doExpand(final Path path, BranchState state) {
            return new FilteringIterator<Relationship>(this.expander.doExpand(path, state), new Predicate<Relationship>(){

                @Override
                public boolean accept(Relationship item) {
                    Path extendedPath = ExtendedPath.extend(path, item);
                    for (Filter filter : FilteringExpander.this.filters) {
                        if (!filter.exclude(extendedPath)) continue;
                        return false;
                    }
                    return true;
                }
            });
        }

        @Override
        public StandardExpander addNodeFilter(Predicate<? super Node> filter) {
            return new FilteringExpander(this.expander, FilteringExpander.append(this.filters, new NodeFilter(filter)));
        }

        @Override
        public StandardExpander addRelationshipFilter(Predicate<? super Relationship> filter) {
            return new FilteringExpander(this.expander, FilteringExpander.append(this.filters, new RelationshipFilter(filter)));
        }

        @Override
        public StandardExpander add(RelationshipType type, Direction direction) {
            return new FilteringExpander(this.expander.add(type, direction), this.filters);
        }

        @Override
        public StandardExpander remove(RelationshipType type) {
            return new FilteringExpander(this.expander.remove(type), this.filters);
        }

        @Override
        public StandardExpander reversed() {
            return this.reverse();
        }

        @Override
        public StandardExpander reverse() {
            return new FilteringExpander(this.expander.reversed(), this.filters);
        }
    }

    static class RegularExpander
    extends StandardExpander {
        final Map<Direction, RelationshipType[]> typesMap;
        final DirectionAndTypes[] directions;

        RegularExpander(Map<Direction, RelationshipType[]> types) {
            this.typesMap = types;
            this.directions = new DirectionAndTypes[types.size()];
            int i = 0;
            for (Map.Entry<Direction, RelationshipType[]> entry : types.entrySet()) {
                this.directions[i++] = new DirectionAndTypes(entry.getKey(), entry.getValue());
            }
        }

        @Override
        void buildString(StringBuilder result) {
            result.append(this.typesMap.toString());
        }

        @Override
        Iterator<Relationship> doExpand(Path path, BranchState state) {
            final Node node = path.endNode();
            if (this.directions.length == 1) {
                DirectionAndTypes direction = this.directions[0];
                return node.getRelationships(direction.direction, direction.types).iterator();
            }
            return new NestingIterator<Relationship, DirectionAndTypes>(new ArrayIterator<DirectionAndTypes>(this.directions)){

                @Override
                protected Iterator<Relationship> createNestedIterator(DirectionAndTypes item) {
                    return node.getRelationships(item.direction, item.types).iterator();
                }
            };
        }

        StandardExpander createNew(Map<Direction, RelationshipType[]> types) {
            if (types.isEmpty()) {
                return new AllExpander(Direction.BOTH);
            }
            return new RegularExpander(types);
        }

        @Override
        public StandardExpander add(RelationshipType type, Direction direction) {
            Map tempMap = StandardExpander.temporaryTypeMapFrom(this.typesMap);
            ((Collection)tempMap.get((Object)direction)).add(type);
            return this.createNew(StandardExpander.toTypeMap(tempMap));
        }

        @Override
        public StandardExpander remove(RelationshipType type) {
            Map tempMap = StandardExpander.temporaryTypeMapFrom(this.typesMap);
            for (Direction direction : Direction.values()) {
                ((Collection)tempMap.get((Object)direction)).remove(type);
            }
            return this.createNew(StandardExpander.toTypeMap(tempMap));
        }

        @Override
        public StandardExpander reversed() {
            return this.reverse();
        }

        @Override
        public StandardExpander reverse() {
            Map tempMap = StandardExpander.temporaryTypeMapFrom(this.typesMap);
            Collection out = (Collection)tempMap.get((Object)Direction.OUTGOING);
            Collection in = (Collection)tempMap.get((Object)Direction.INCOMING);
            tempMap.put(Direction.OUTGOING, in);
            tempMap.put(Direction.INCOMING, out);
            return this.createNew(StandardExpander.toTypeMap(tempMap));
        }
    }

    private static class DirectionAndTypes {
        final Direction direction;
        final RelationshipType[] types;

        DirectionAndTypes(Direction direction, RelationshipType[] types) {
            this.direction = direction;
            this.types = types;
        }
    }

    private static final class ExcludingExpander
    extends StandardExpander {
        private final Exclusion defaultExclusion;
        private final Map<String, Exclusion> exclusion;

        ExcludingExpander(Exclusion defaultExclusion, Map<String, Exclusion> exclusion) {
            this.defaultExclusion = defaultExclusion;
            this.exclusion = exclusion;
        }

        @Override
        void buildString(StringBuilder result) {
            result.append((Object)this.defaultExclusion);
            result.append("*");
            for (Map.Entry<String, Exclusion> entry : this.exclusion.entrySet()) {
                result.append(",");
                result.append((Object)entry.getValue());
                result.append(entry.getKey());
            }
        }

        @Override
        Iterator<Relationship> doExpand(Path path, BranchState state) {
            final Node node = path.endNode();
            return new FilteringIterator<Relationship>(node.getRelationships().iterator(), new Predicate<Relationship>(){

                @Override
                public boolean accept(Relationship rel) {
                    Exclusion exclude = (Exclusion)((Object)ExcludingExpander.this.exclusion.get(rel.getType().name()));
                    exclude = exclude == null ? ExcludingExpander.this.defaultExclusion : exclude;
                    return exclude.accept(node, rel);
                }
            });
        }

        @Override
        public StandardExpander add(RelationshipType type, Direction direction) {
            HashMap<String, Exclusion> newExclusion;
            Exclusion excluded = this.exclusion.get(type.name());
            if ((excluded == null ? this.defaultExclusion : excluded).includes(direction)) {
                return this;
            }
            excluded = Exclusion.include(direction);
            if (excluded == this.defaultExclusion) {
                if (this.exclusion.size() == 1) {
                    return new AllExpander(this.defaultExclusion.direction);
                }
                newExclusion = new HashMap<String, Exclusion>(this.exclusion);
                newExclusion.remove(type.name());
            } else {
                newExclusion = new HashMap<String, Exclusion>(this.exclusion);
                newExclusion.put(type.name(), excluded);
            }
            return new ExcludingExpander(this.defaultExclusion, newExclusion);
        }

        @Override
        public StandardExpander remove(RelationshipType type) {
            Exclusion excluded = this.exclusion.get(type.name());
            if (excluded == Exclusion.ALL) {
                return this;
            }
            HashMap<String, Exclusion> newExclusion = new HashMap<String, Exclusion>(this.exclusion);
            newExclusion.put(type.name(), Exclusion.ALL);
            return new ExcludingExpander(this.defaultExclusion, newExclusion);
        }

        @Override
        public StandardExpander reversed() {
            return this.reverse();
        }

        @Override
        public StandardExpander reverse() {
            HashMap<String, Exclusion> newExclusion = new HashMap<String, Exclusion>();
            for (Map.Entry<String, Exclusion> entry : this.exclusion.entrySet()) {
                newExclusion.put(entry.getKey(), entry.getValue().reversed());
            }
            return new ExcludingExpander(this.defaultExclusion.reversed(), newExclusion);
        }
    }

    private static enum Exclusion {
        ALL(null, "!"){

            @Override
            public boolean accept(Node start, Relationship rel) {
                return false;
            }
        }
        ,
        INCOMING(Direction.OUTGOING){

            @Override
            Exclusion reversed() {
                return OUTGOING;
            }
        }
        ,
        OUTGOING(Direction.INCOMING){

            @Override
            Exclusion reversed() {
                return INCOMING;
            }
        }
        ,
        NONE(Direction.BOTH, ""){

            @Override
            boolean includes(Direction direction) {
                return true;
            }
        };

        private final String string;
        private final Direction direction;

        private Exclusion(Direction direction, String string2) {
            this.direction = direction;
            this.string = string2;
        }

        private Exclusion(Direction direction) {
            this.direction = direction;
            this.string = "!" + this.name() + ":";
        }

        public final String toString() {
            return this.string;
        }

        boolean accept(Node start, Relationship rel) {
            return StandardExpander.matchDirection(this.direction, start, rel);
        }

        Exclusion reversed() {
            return this;
        }

        boolean includes(Direction dir) {
            return this.direction == dir;
        }

        static Exclusion include(Direction direction) {
            switch (direction) {
                case INCOMING: {
                    return OUTGOING;
                }
                case OUTGOING: {
                    return INCOMING;
                }
            }
            return NONE;
        }
    }

    private static class AllExpander
    extends StandardExpander {
        private final Direction direction;

        AllExpander(Direction direction) {
            this.direction = direction;
        }

        @Override
        void buildString(StringBuilder result) {
            if (this.direction != Direction.BOTH) {
                result.append((Object)this.direction);
                result.append(":");
            }
            result.append("*");
        }

        @Override
        Iterator<Relationship> doExpand(Path path, BranchState state) {
            return path.endNode().getRelationships(this.direction).iterator();
        }

        @Override
        public StandardExpander add(RelationshipType type, Direction dir) {
            return this;
        }

        @Override
        public StandardExpander remove(RelationshipType type) {
            HashMap<String, Exclusion> exclude = new HashMap<String, Exclusion>();
            exclude.put(type.name(), Exclusion.ALL);
            return new ExcludingExpander(Exclusion.include(this.direction), exclude);
        }

        @Override
        public StandardExpander reversed() {
            return this.reverse();
        }

        @Override
        public StandardExpander reverse() {
            return new AllExpander(this.direction.reverse());
        }
    }

    private static final class PairExpansion
    extends StandardExpansion<Pair<Relationship, Node>> {
        PairExpansion(StandardExpander expander, Path path, BranchState state) {
            super(expander, path, state);
        }

        public String toString() {
            return this.stringRepresentation("pairs");
        }

        @Override
        StandardExpansion<Pair<Relationship, Node>> createNew(StandardExpander expander) {
            return new PairExpansion(expander, this.path, this.state);
        }

        @Override
        public StandardExpansion<Pair<Relationship, Node>> pairs() {
            return this;
        }

        @Override
        public Iterator<Pair<Relationship, Node>> iterator() {
            final Node node = this.path.endNode();
            return new IteratorWrapper<Pair<Relationship, Node>, Relationship>(this.expander.doExpand(this.path, this.state)){

                @Override
                protected Pair<Relationship, Node> underlyingObjectToObject(Relationship rel) {
                    return Pair.of(rel, rel.getOtherNode(node));
                }
            };
        }
    }

    private static final class NodeExpansion
    extends StandardExpansion<Node> {
        NodeExpansion(StandardExpander expander, Path path, BranchState state) {
            super(expander, path, state);
        }

        public String toString() {
            return this.stringRepresentation("nodes");
        }

        @Override
        StandardExpansion<Node> createNew(StandardExpander expander) {
            return new NodeExpansion(expander, this.path, this.state);
        }

        @Override
        public StandardExpansion<Node> nodes() {
            return this;
        }

        @Override
        public Iterator<Node> iterator() {
            final Node node = this.path.endNode();
            return new IteratorWrapper<Node, Relationship>(this.expander.doExpand(this.path, this.state)){

                @Override
                protected Node underlyingObjectToObject(Relationship rel) {
                    return rel.getOtherNode(node);
                }
            };
        }
    }

    private static final class RelationshipExpansion
    extends StandardExpansion<Relationship> {
        RelationshipExpansion(StandardExpander expander, Path path, BranchState state) {
            super(expander, path, state);
        }

        public String toString() {
            return this.stringRepresentation("relationships");
        }

        @Override
        StandardExpansion<Relationship> createNew(StandardExpander expander) {
            return new RelationshipExpansion(expander, this.path, this.state);
        }

        @Override
        public StandardExpansion<Relationship> relationships() {
            return this;
        }

        @Override
        public Iterator<Relationship> iterator() {
            return this.expander.doExpand(this.path, this.state);
        }
    }

    static abstract class StandardExpansion<T>
    implements Expansion<T> {
        final StandardExpander expander;
        final Path path;
        final BranchState state;

        StandardExpansion(StandardExpander expander, Path path, BranchState state) {
            this.expander = expander;
            this.path = path;
            this.state = state;
        }

        String stringRepresentation(String nodesORrelationships) {
            return "Expansion[" + this.path + ".expand( " + this.expander + " )." + nodesORrelationships + "()]";
        }

        abstract StandardExpansion<T> createNew(StandardExpander var1);

        @Override
        public StandardExpansion<T> including(RelationshipType type) {
            return this.createNew(this.expander.add(type));
        }

        @Override
        public StandardExpansion<T> including(RelationshipType type, Direction direction) {
            return this.createNew(this.expander.add(type, direction));
        }

        @Override
        public StandardExpansion<T> excluding(RelationshipType type) {
            return this.createNew(this.expander.remove(type));
        }

        @Override
        public StandardExpander expander() {
            return this.expander;
        }

        @Override
        public StandardExpansion<T> filterNodes(Predicate<? super Node> filter) {
            return this.createNew((StandardExpander)this.expander.addNodeFilter((Predicate)filter));
        }

        @Override
        public StandardExpansion<T> filterRelationships(Predicate<? super Relationship> filter) {
            return this.createNew((StandardExpander)this.expander.addRelationshipFilter((Predicate)filter));
        }

        @Override
        public T getSingle() {
            Iterator expanded = this.iterator();
            if (expanded.hasNext()) {
                Object result = expanded.next();
                if (expanded.hasNext()) {
                    throw new NotFoundException("More than one relationship found for " + this);
                }
                return result;
            }
            return null;
        }

        @Override
        public boolean isEmpty() {
            return !this.expander.doExpand(this.path, this.state).hasNext();
        }

        public StandardExpansion<Node> nodes() {
            return new NodeExpansion(this.expander, this.path, this.state);
        }

        public StandardExpansion<Relationship> relationships() {
            return new RelationshipExpansion(this.expander, this.path, this.state);
        }

        public StandardExpansion<Pair<Relationship, Node>> pairs() {
            return new PairExpansion(this.expander, this.path, this.state);
        }
    }
}

