/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.indexcommand;

import java.io.Serializable;
import org.eclipse.collections.api.block.function.primitive.IntToIntFunction;
import org.eclipse.collections.api.factory.primitive.ObjectIntMaps;
import org.eclipse.collections.api.map.primitive.MutableObjectIntMap;
import org.neo4j.common.EntityType;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.Direction;
import org.neo4j.internal.indexcommand.IndexUpdatesState;
import org.neo4j.internal.indexcommand.TransactionToIndexUpdateVisitor;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.IOUtils;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.Degrees;
import org.neo4j.storageengine.api.RelationshipSelection;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.StorageRelationshipScanCursor;
import org.neo4j.storageengine.api.TokenIndexEntryUpdate;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.storageengine.api.txstate.RelationshipModifications;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;
import org.neo4j.storageengine.util.SingleDegree;

public final class NodeBasedTransactionToIndexUpdateVisitor
extends TransactionToIndexUpdateVisitor {
    private final StorageRelationshipScanCursor relationshipCursor;
    private final IndexDescriptor relationshipTypeIndex;

    public NodeBasedTransactionToIndexUpdateVisitor(TxStateVisitor next, IndexUpdatesState indexUpdatesState, StorageReader storageReader, CursorContext cursorContext, StoreCursors storeCursors, MemoryTracker memoryTracker) {
        super(next, indexUpdatesState, storageReader, cursorContext, storeCursors, memoryTracker);
        this.relationshipCursor = storageReader.allocateRelationshipScanCursor(cursorContext, storeCursors, memoryTracker);
        this.relationshipTypeIndex = NodeBasedTransactionToIndexUpdateVisitor.getTokenIndex(storageReader, EntityType.RELATIONSHIP);
    }

    public void visitRelationshipModifications(RelationshipModifications modifications) throws ConstraintValidationException {
        super.visitRelationshipModifications(modifications);
        if (this.relationshipTypeIndex == null) {
            return;
        }
        this.collectPerNodeTypeModifications(modifications).forEachKeyValue(this::processChange);
    }

    private void processChange(NodeTypeKey nodeType, int delta) {
        if (this.shouldAddToIndex(nodeType.nodeId, nodeType.type, delta)) {
            this.indexUpdatesState.addTokenUpdate(TokenIndexEntryUpdate.tokenChange((long)nodeType.nodeId, (IndexDescriptor)this.relationshipTypeIndex, (int[])NO_TOKENS, (int[])new int[]{nodeType.type}));
        } else if (this.shouldRemoveFromIndex(nodeType.nodeId, nodeType.type, delta)) {
            this.indexUpdatesState.addTokenUpdate(TokenIndexEntryUpdate.tokenChange((long)nodeType.nodeId, (IndexDescriptor)this.relationshipTypeIndex, (int[])new int[]{nodeType.type}, (int[])NO_TOKENS));
        }
    }

    private boolean shouldAddToIndex(long nodeId, int relType, int delta) {
        if (delta <= 0) {
            return false;
        }
        this.nodeCursor.single(nodeId);
        if (!this.nodeCursor.next()) {
            return true;
        }
        SingleDegree degree = new SingleDegree(1);
        this.nodeCursor.degrees(RelationshipSelection.selection((int)relType, (Direction)Direction.OUTGOING), (Degrees.Mutator)degree);
        return degree.getTotal() == 0;
    }

    private boolean shouldRemoveFromIndex(long nodeId, int relType, int delta) {
        if (delta >= 0) {
            return false;
        }
        this.nodeCursor.single(nodeId);
        if (!this.nodeCursor.next()) {
            return false;
        }
        int removedCount = Math.abs(delta);
        SingleDegree degree = new SingleDegree(removedCount + 1);
        this.nodeCursor.degrees(RelationshipSelection.selection((int)relType, (Direction)Direction.OUTGOING), (Degrees.Mutator)degree);
        return degree.getTotal() <= removedCount;
    }

    private MutableObjectIntMap<NodeTypeKey> collectPerNodeTypeModifications(RelationshipModifications modifications) {
        MutableObjectIntMap changes = ObjectIntMaps.mutable.empty();
        modifications.creations().forEach((id, type, startNode, en, ap, cp, rp) -> changes.updateValue((Object)new NodeTypeKey(startNode, type), 0, (IntToIntFunction & Serializable)i -> i + 1));
        modifications.deletions().forEach((id, type, startNode, en, ap, cp, rp) -> changes.updateValue((Object)new NodeTypeKey(startNode, this.findTypeToRemove(id, type)), 0, (IntToIntFunction & Serializable)i -> i - 1));
        return changes;
    }

    @Override
    public void close() throws KernelException {
        IOUtils.closeAllUnchecked((AutoCloseable[])new AutoCloseable[]{() -> super.close(), this.relationshipCursor});
    }

    private int findTypeToRemove(long id, int type) {
        if (type == -1) {
            this.relationshipCursor.single(id);
            if (!this.relationshipCursor.next()) {
                throw new IllegalStateException("Relationship being deleted should exist along with its nodes. Relationship[" + id + "]");
            }
            return this.relationshipCursor.type();
        }
        return type;
    }

    private record NodeTypeKey(long nodeId, int type) {
    }
}

