/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.indexcommand;

import java.io.IOException;
import org.neo4j.internal.indexcommand.IndexCommandSerialization;
import org.neo4j.internal.indexcommand.IndexCommandSerializationImpl;
import org.neo4j.internal.indexcommand.IndexUpdateCommand;
import org.neo4j.internal.indexcommand.TokenIndexUpdateCommand;
import org.neo4j.internal.indexcommand.ValueIndexUpdateCommand;
import org.neo4j.internal.indexcommand.encode.PeekableChannel;
import org.neo4j.internal.indexcommand.encode.PositiveNumberEncoder;
import org.neo4j.internal.indexcommand.encode.ValueStream;
import org.neo4j.io.fs.ReadableChannel;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.storageengine.api.UpdateMode;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Value;

public class IndexCommandSerializationImplV1
implements IndexCommandSerializationImpl {
    @Override
    public void writeCommand(WritableChannel channel, IndexUpdateCommand<?> command) throws IOException {
        IndexCommandSerializationImplV1.write(channel, command);
    }

    @Override
    public IndexUpdateCommand<?> readCommand(IndexCommandSerialization serialization, ReadableChannel channel) throws IOException {
        return IndexCommandSerializationImplV1.read(serialization, channel);
    }

    private static void write(WritableChannel out, IndexUpdateCommand<?> command) throws IOException {
        boolean tokenIndex = IndexCommandSerializationImplV1.isTokenIndex(command);
        IndexCommandSerializationImplV1.writeHeader(out, command, tokenIndex);
        PositiveNumberEncoder.writeNumber(out, command.getIndexId());
        IndexCommandSerializationImplV1.writeEntityId(out, command.getEntityId());
        if (tokenIndex) {
            IndexCommandSerializationImplV1.writeTokenPart(out, (TokenIndexUpdateCommand)command);
        } else {
            IndexCommandSerializationImplV1.writeValuePart(out, (ValueIndexUpdateCommand)command);
        }
    }

    private static IndexUpdateCommand<?> read(IndexCommandSerialization serialization, ReadableChannel in) throws IOException {
        byte header = in.get();
        boolean tokenIndex = IndexCommandSerializationImplV1.isTokenIndex(header);
        UpdateMode updateMode = IndexCommandSerializationImplV1.readUpdateMode(header);
        long indexId = PositiveNumberEncoder.readNumber(in);
        long entityId = IndexCommandSerializationImplV1.readEntityId(in);
        if (tokenIndex) {
            return IndexCommandSerializationImplV1.readTokenPart(serialization, in, updateMode, indexId, entityId);
        }
        return IndexCommandSerializationImplV1.readValuePart(serialization, in, updateMode, indexId, entityId);
    }

    private static boolean isTokenIndex(byte header) {
        return (header & 0x80) == 0;
    }

    private static UpdateMode readUpdateMode(byte header) {
        int modeOrdinal = header >> 5 & 3;
        return switch (modeOrdinal) {
            case 0 -> UpdateMode.ADDED;
            case 1 -> UpdateMode.CHANGED;
            case 2 -> UpdateMode.REMOVED;
            default -> throw new IllegalArgumentException("Weird header: " + header);
        };
    }

    private static void writeValuePart(WritableChannel out, ValueIndexUpdateCommand command) throws IOException {
        switch (command.getUpdateMode()) {
            case ADDED: 
            case REMOVED: {
                IndexCommandSerializationImplV1.writeValueArray(out, command.getAfter());
                break;
            }
            case CHANGED: {
                IndexCommandSerializationImplV1.writeValueArray(out, command.getBefore());
                IndexCommandSerializationImplV1.writeValueArray(out, command.getAfter());
            }
        }
    }

    private static ValueIndexUpdateCommand readValuePart(IndexCommandSerialization serialization, ReadableChannel in, UpdateMode updateMode, long indexId, long entityId) throws IOException {
        return switch (updateMode) {
            default -> throw new MatchException(null, null);
            case UpdateMode.ADDED, UpdateMode.REMOVED -> {
                Value[] values = IndexCommandSerializationImplV1.readValueArray(in);
                yield new ValueIndexUpdateCommand(serialization, updateMode, indexId, entityId, null, values);
            }
            case UpdateMode.CHANGED -> {
                Value[] before = IndexCommandSerializationImplV1.readValueArray(in);
                Value[] values = IndexCommandSerializationImplV1.readValueArray(in);
                yield new ValueIndexUpdateCommand(serialization, updateMode, indexId, entityId, before, values);
            }
        };
    }

    private static void writeValueArray(WritableChannel out, Value[] values) throws IOException {
        PositiveNumberEncoder.writeNumber(out, values.length);
        for (Value value : values) {
            ValueStream.write(out, (AnyValue)value);
        }
    }

    private static Value[] readValueArray(ReadableChannel in) throws IOException {
        int length = (int)PositiveNumberEncoder.readNumber(in);
        Value[] values = new Value[length];
        PeekableChannel peekableChannel = new PeekableChannel(in);
        for (int i = 0; i < length; ++i) {
            values[i] = ValueStream.readValue(peekableChannel);
        }
        return values;
    }

    private static void writeTokenPart(WritableChannel out, TokenIndexUpdateCommand command) throws IOException {
        switch (command.getUpdateMode()) {
            case ADDED: 
            case REMOVED: {
                IndexCommandSerializationImplV1.writeTokenArray(out, command.getAfter());
                break;
            }
            case CHANGED: {
                IndexCommandSerializationImplV1.writeTokenArray(out, command.getBefore());
                IndexCommandSerializationImplV1.writeTokenArray(out, command.getAfter());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static TokenIndexUpdateCommand readTokenPart(IndexCommandSerialization serialization, ReadableChannel in, UpdateMode updateMode, long indexId, long entityId) throws IOException {
        switch (updateMode) {
            default: {
                throw new MatchException(null, null);
            }
            case CHANGED: {
                int[] before = IndexCommandSerializationImplV1.readTokenArray(in);
                int[] values = IndexCommandSerializationImplV1.readTokenArray(in);
                return new TokenIndexUpdateCommand(serialization, indexId, entityId, before, values);
            }
            case ADDED: 
            case REMOVED: 
        }
        throw new IllegalArgumentException("TokenIndexUpdateCommand can only have update mode CHANGED");
    }

    private static int[] readTokenArray(ReadableChannel in) throws IOException {
        int length = (int)PositiveNumberEncoder.readNumber(in);
        int[] tokens = new int[length];
        for (int i = 0; i < length; ++i) {
            tokens[i] = (int)PositiveNumberEncoder.readNumber(in);
        }
        return tokens;
    }

    private static void writeTokenArray(WritableChannel out, int[] tokens) throws IOException {
        PositiveNumberEncoder.writeNumber(out, tokens.length);
        for (int token : tokens) {
            PositiveNumberEncoder.writeNumber(out, token);
        }
    }

    private static void writeHeader(WritableChannel out, IndexUpdateCommand<?> command, boolean tokenIndex) throws IOException {
        byte header = 0;
        if (!tokenIndex) {
            header = -128;
        }
        header = (byte)(header | (byte)(command.getUpdateMode().ordinal() << 5));
        out.put(header);
    }

    private static boolean isTokenIndex(IndexUpdateCommand<?> command) {
        return command instanceof TokenIndexUpdateCommand;
    }

    public static void writeEntityId(WritableChannel out, long entityId) throws IOException {
        out.putLong(entityId);
    }

    public static long readEntityId(ReadableChannel in) throws IOException {
        return in.getLong();
    }
}

