/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.pipes;

import java.io.Serializable;
import java.util.function.LongPredicate;
import org.neo4j.cypher.internal.expressions.SemanticDirection;
import org.neo4j.cypher.internal.logical.plans.FindShortestPaths;
import org.neo4j.cypher.internal.logical.plans.TraversalPathMode;
import org.neo4j.cypher.internal.planner.spi.ReadTokenContext;
import org.neo4j.cypher.internal.runtime.ClosingIterator;
import org.neo4j.cypher.internal.runtime.ClosingIterator$;
import org.neo4j.cypher.internal.runtime.CypherRow;
import org.neo4j.cypher.internal.runtime.IsNoValue$;
import org.neo4j.cypher.internal.runtime.ReadableRow;
import org.neo4j.cypher.internal.runtime.interpreted.commands.convert.DirectionConverter$;
import org.neo4j.cypher.internal.runtime.interpreted.commands.predicates.Predicate;
import org.neo4j.cypher.internal.runtime.interpreted.commands.predicates.True;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.Pipe;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.PipeWithSource;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.QueryState;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.RelationshipTypes;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.ShortestPathPipe$;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.TraversalPredicates;
import org.neo4j.cypher.operations.CypherTypeValueMapper;
import org.neo4j.exceptions.CypherTypeException;
import org.neo4j.exceptions.ShortestPathCommonEndNodesForbiddenException;
import org.neo4j.graphdb.Direction;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.helpers.traversal.ShortestPathBFS;
import org.neo4j.internal.kernel.api.helpers.traversal.ShortestPathBFSFactory;
import org.neo4j.lang.AutoCloseablePlus;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.values.AnyValue;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.RelationshipReference;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualValues;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple15;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\rud\u0001B#G\u0001VC\u0001\u0002\u001c\u0001\u0003\u0016\u0004%\t!\u001c\u0005\tc\u0002\u0011\t\u0012)A\u0005]\"A!\u000f\u0001BK\u0002\u0013\u00051\u000f\u0003\u0005}\u0001\tE\t\u0015!\u0003u\u0011!i\bA!f\u0001\n\u0003\u0019\b\u0002\u0003@\u0001\u0005#\u0005\u000b\u0011\u0002;\t\u0011}\u0004!Q3A\u0005\u0002MD\u0011\"!\u0001\u0001\u0005#\u0005\u000b\u0011\u0002;\t\u0013\u0005\r\u0001A!f\u0001\n\u0003\u0019\b\"CA\u0003\u0001\tE\t\u0015!\u0003u\u0011)\t9\u0001\u0001BK\u0002\u0013\u0005\u0011\u0011\u0002\u0005\u000b\u0003#\u0001!\u0011#Q\u0001\n\u0005-\u0001BCA\n\u0001\tU\r\u0011\"\u0001\u0002\u0016!Q\u00111\u0005\u0001\u0003\u0012\u0003\u0006I!a\u0006\t\u0015\u0005\u0015\u0002A!f\u0001\n\u0003\t9\u0003\u0003\u0006\u00020\u0001\u0011\t\u0012)A\u0005\u0003SA!\"!\r\u0001\u0005+\u0007I\u0011AA\u001a\u0011)\tY\u0005\u0001B\tB\u0003%\u0011Q\u0007\u0005\u000b\u0003\u001b\u0002!Q3A\u0005\u0002\u0005=\u0003BCA,\u0001\tE\t\u0015!\u0003\u0002R!Q\u0011\u0011\f\u0001\u0003\u0016\u0004%\t!a\u0017\t\u0015\u0005-\u0005A!E!\u0002\u0013\ti\u0006\u0003\u0006\u0002\u000e\u0002\u0011)\u001a!C\u0001\u0003\u001fB!\"a$\u0001\u0005#\u0005\u000b\u0011BA)\u0011)\t\t\n\u0001BK\u0002\u0013\u0005\u00111\u0013\u0005\u000b\u0003C\u0003!\u0011#Q\u0001\n\u0005U\u0005BCAR\u0001\tU\r\u0011\"\u0001\u0002P!Q\u0011Q\u0015\u0001\u0003\u0012\u0003\u0006I!!\u0015\t\u0015\u0005\u001d\u0006A!f\u0001\n\u0003\tI\u000b\u0003\u0006\u00024\u0002\u0011\t\u0012)A\u0005\u0003WC!\"!.\u0001\u0005\u000b\u0007I\u0011AA\\\u0011)\tI\r\u0001B\u0001B\u0003%\u0011\u0011\u0018\u0005\b\u0003\u0017\u0004A\u0011AAg\u0011\u001d\t\u0019\u0010\u0001C)\u0003kD\u0011Ba\u0005\u0001\u0003\u0003%\tA!\u0006\t\u0013\te\u0002!%A\u0005\u0002\tm\u0002\"\u0003B)\u0001E\u0005I\u0011\u0001B*\u0011%\u00119\u0006AI\u0001\n\u0003\u0011\u0019\u0006C\u0005\u0003Z\u0001\t\n\u0011\"\u0001\u0003T!I!1\f\u0001\u0012\u0002\u0013\u0005!1\u000b\u0005\n\u0005;\u0002\u0011\u0013!C\u0001\u0005?B\u0011Ba\u0019\u0001#\u0003%\tA!\u001a\t\u0013\t%\u0004!%A\u0005\u0002\t-\u0004\"\u0003B8\u0001E\u0005I\u0011\u0001B9\u0011%\u0011)\bAI\u0001\n\u0003\u00119\bC\u0005\u0003|\u0001\t\n\u0011\"\u0001\u0003~!I!\u0011\u0011\u0001\u0012\u0002\u0013\u0005!q\u000f\u0005\n\u0005\u0007\u0003\u0011\u0013!C\u0001\u0005\u000bC\u0011B!#\u0001#\u0003%\tAa\u001e\t\u0013\t-\u0005!%A\u0005\u0002\t5\u0005\"\u0003BI\u0001\u0005\u0005I\u0011\tBJ\u0011%\u0011\u0019\u000bAA\u0001\n\u0003\u0011)\u000bC\u0005\u0003(\u0002\t\t\u0011\"\u0001\u0003*\"I!Q\u0017\u0001\u0002\u0002\u0013\u0005#q\u0017\u0005\n\u0005\u000b\u0004\u0011\u0011!C\u0001\u0005\u000fD\u0011Ba3\u0001\u0003\u0003%\tE!4\t\u0013\tE\u0007!!A\u0005B\tM\u0007\"\u0003Bk\u0001\u0005\u0005I\u0011\tBl\u0011%\u0011I\u000eAA\u0001\n\u0003\u0012YnB\u0005\u0003`\u001a\u000b\t\u0011#\u0001\u0003b\u001aAQIRA\u0001\u0012\u0003\u0011\u0019\u000fC\u0004\u0002Lv\"\tA!>\t\u0013\tUW(!A\u0005F\t]\u0007\"\u0003B|{\u0005\u0005I\u0011\u0011B}\u0011%\u0019i\"PI\u0001\n\u0003\u0019y\u0002C\u0005\u0004Bu\n\t\u0011\"!\u0004D!I1\u0011K\u001f\u0012\u0002\u0013\u000511\u000b\u0005\n\u0007gj\u0014\u0011!C\u0005\u0007k\u0012\u0001c\u00155peR,7\u000f\u001e)bi\"\u0004\u0016\u000e]3\u000b\u0005\u001dC\u0015!\u00029ja\u0016\u001c(BA%K\u0003-Ig\u000e^3saJ,G/\u001a3\u000b\u0005-c\u0015a\u0002:v]RLW.\u001a\u0006\u0003\u001b:\u000b\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u001fB\u000baaY=qQ\u0016\u0014(BA)S\u0003\u0015qWm\u001c\u001bk\u0015\u0005\u0019\u0016aA8sO\u000e\u00011\u0003\u0002\u0001W5\u0002\u0004\"a\u0016-\u000e\u0003\u0019K!!\u0017$\u0003\u001dAK\u0007/Z,ji\"\u001cv.\u001e:dKB\u00111LX\u0007\u00029*\tQ,A\u0003tG\u0006d\u0017-\u0003\u0002`9\n9\u0001K]8ek\u000e$\bCA1j\u001d\t\u0011wM\u0004\u0002dM6\tAM\u0003\u0002f)\u00061AH]8pizJ\u0011!X\u0005\u0003Qr\u000bq\u0001]1dW\u0006<W-\u0003\u0002kW\na1+\u001a:jC2L'0\u00192mK*\u0011\u0001\u000eX\u0001\u0007g>,(oY3\u0016\u00039\u0004\"aV8\n\u0005A4%\u0001\u0002)ja\u0016\fqa]8ve\u000e,\u0007%\u0001\bt_V\u00148-\u001a(pI\u0016t\u0015-\\3\u0016\u0003Q\u0004\"!^=\u000f\u0005Y<\bCA2]\u0013\tAH,\u0001\u0004Qe\u0016$WMZ\u0005\u0003un\u0014aa\u0015;sS:<'B\u0001=]\u0003=\u0019x.\u001e:dK:{G-\u001a(b[\u0016\u0004\u0013A\u0004;be\u001e,GOT8eK:\u000bW.Z\u0001\u0010i\u0006\u0014x-\u001a;O_\u0012,g*Y7fA\u0005A\u0001/\u0019;i\u001d\u0006lW-A\u0005qCRDg*Y7fA\u0005A!/\u001a7t\u001d\u0006lW-A\u0005sK2\u001ch*Y7fA\u0005)A/\u001f9fgV\u0011\u00111\u0002\t\u0004/\u00065\u0011bAA\b\r\n\t\"+\u001a7bi&|gn\u001d5jaRK\b/Z:\u0002\rQL\b/Z:!\u0003%!\u0017N]3di&|g.\u0006\u0002\u0002\u0018A!\u0011\u0011DA\u0010\u001b\t\tYBC\u0002\u0002\u001e1\u000b1\"\u001a=qe\u0016\u001c8/[8og&!\u0011\u0011EA\u000e\u0005E\u0019V-\\1oi&\u001cG)\u001b:fGRLwN\\\u0001\u000bI&\u0014Xm\u0019;j_:\u0004\u0013!\u00044jYR,'/\u001b8h'R,\u0007/\u0006\u0002\u0002*A\u0019q+a\u000b\n\u0007\u00055bIA\nUe\u00064XM]:bYB\u0013X\rZ5dCR,7/\u0001\bgS2$XM]5oON#X\r\u001d\u0011\u0002\u001dA\fG\u000f\u001b)sK\u0012L7-\u0019;fgV\u0011\u0011Q\u0007\t\u0006C\u0006]\u00121H\u0005\u0004\u0003sY'aA*fcB!\u0011QHA$\u001b\t\tyD\u0003\u0003\u0002B\u0005\r\u0013A\u00039sK\u0012L7-\u0019;fg*\u0019\u0011Q\t%\u0002\u0011\r|W.\\1oINLA!!\u0013\u0002@\tI\u0001K]3eS\u000e\fG/Z\u0001\u0010a\u0006$\b\u000e\u0015:fI&\u001c\u0017\r^3tA\u0005I\"/\u001a;ve:|e.Z*i_J$Xm\u001d;QCRDwJ\u001c7z+\t\t\t\u0006E\u0002\\\u0003'J1!!\u0016]\u0005\u001d\u0011un\u001c7fC:\f!D]3ukJtwJ\\3TQ>\u0014H/Z:u!\u0006$\bn\u00148ms\u0002\nAb]1nK:{G-Z'pI\u0016,\"!!\u0018\u0011\t\u0005}\u0013Q\u0011\b\u0005\u0003C\nyH\u0004\u0003\u0002d\u0005ed\u0002BA3\u0003krA!a\u001a\u0002t9!\u0011\u0011NA9\u001d\u0011\tY'a\u001c\u000f\u0007\r\fi'C\u0001T\u0013\t\t&+\u0003\u0002P!&\u0011QJT\u0005\u0004\u0003ob\u0015a\u00027pO&\u001c\u0017\r\\\u0005\u0005\u0003w\ni(A\u0003qY\u0006t7OC\u0002\u0002x1KA!!!\u0002\u0004\u0006\tb)\u001b8e'\"|'\u000f^3tiB\u000bG\u000f[:\u000b\t\u0005m\u0014QP\u0005\u0005\u0003\u000f\u000bII\u0001\u0007TC6,gj\u001c3f\u001b>$WM\u0003\u0003\u0002\u0002\u0006\r\u0015!D:b[\u0016tu\u000eZ3N_\u0012,\u0007%A\bbY2|wOW3s_2+gn\u001a;i\u0003A\tG\u000e\\8x5\u0016\u0014x\u000eT3oORD\u0007%\u0001\u0005nCb$U\r\u001d;i+\t\t)\nE\u0003\\\u0003/\u000bY*C\u0002\u0002\u001ar\u0013aa\u00149uS>t\u0007cA.\u0002\u001e&\u0019\u0011q\u0014/\u0003\u0007%sG/A\u0005nCb$U\r\u001d;iA\u0005ya.Z3e\u001f:d\u0017p\u00148f!\u0006$\b.\u0001\toK\u0016$wJ\u001c7z\u001f:,\u0007+\u0019;iA\u0005iAO]1wKJ\u001c\u0018\r\\'pI\u0016,\"!a+\u0011\t\u00055\u0016qV\u0007\u0003\u0003\u0007KA!!-\u0002\u0004\n\tBK]1wKJ\u001c\u0018\r\u001c)bi\"lu\u000eZ3\u0002\u001dQ\u0014\u0018M^3sg\u0006dWj\u001c3fA\u0005\u0011\u0011\u000eZ\u000b\u0003\u0003s\u0003B!a/\u0002F6\u0011\u0011Q\u0018\u0006\u0005\u0003\u007f\u000b\t-A\u0006biR\u0014\u0018NY;uS>t'bAAb\u0019\u0006!Q\u000f^5m\u0013\u0011\t9-!0\u0003\u0005%#\u0017aA5eA\u00051A(\u001b8jiz\"\u0002%a4\u0002V\u0006]\u0017\u0011\\An\u0003;\fy.!9\u0002d\u0006\u0015\u0018q]Au\u0003W\fi/a<\u0002rR!\u0011\u0011[Aj!\t9\u0006\u0001C\u0005\u00026\u0006\u0002\n\u00111\u0001\u0002:\")A.\ta\u0001]\")!/\ta\u0001i\")Q0\ta\u0001i\")q0\ta\u0001i\"1\u00111A\u0011A\u0002QDq!a\u0002\"\u0001\u0004\tY\u0001C\u0004\u0002\u0014\u0005\u0002\r!a\u0006\t\u000f\u0005\u0015\u0012\u00051\u0001\u0002*!9\u0011\u0011G\u0011A\u0002\u0005U\u0002bBA'C\u0001\u0007\u0011\u0011\u000b\u0005\b\u00033\n\u0003\u0019AA/\u0011\u001d\ti)\ta\u0001\u0003#Bq!!%\"\u0001\u0004\t)\nC\u0004\u0002$\u0006\u0002\r!!\u0015\t\u000f\u0005\u001d\u0016\u00051\u0001\u0002,\u0006)\u0012N\u001c;fe:\fGn\u0011:fCR,'+Z:vYR\u001cHCBA|\u0005\u000b\u0011I\u0001\u0005\u0004\u0002z\u0006m\u0018q`\u0007\u0002\u0015&\u0019\u0011Q &\u0003\u001f\rcwn]5oO&#XM]1u_J\u0004B!!?\u0003\u0002%\u0019!1\u0001&\u0003\u0013\rK\b\u000f[3s%><\bb\u0002B\u0004E\u0001\u0007\u0011q_\u0001\u0006S:\u0004X\u000f\u001e\u0005\b\u0005\u0017\u0011\u0003\u0019\u0001B\u0007\u0003\u0015\u0019H/\u0019;f!\r9&qB\u0005\u0004\u0005#1%AC)vKJL8\u000b^1uK\u0006!1m\u001c9z)\u0001\u00129Ba\u0007\u0003\u001e\t}!\u0011\u0005B\u0012\u0005K\u00119C!\u000b\u0003,\t5\"q\u0006B\u0019\u0005g\u0011)Da\u000e\u0015\t\u0005E'\u0011\u0004\u0005\b\u0003k\u001b\u0003\u0019AA]\u0011\u001da7\u0005%AA\u00029DqA]\u0012\u0011\u0002\u0003\u0007A\u000fC\u0004~GA\u0005\t\u0019\u0001;\t\u000f}\u001c\u0003\u0013!a\u0001i\"A\u00111A\u0012\u0011\u0002\u0003\u0007A\u000fC\u0005\u0002\b\r\u0002\n\u00111\u0001\u0002\f!I\u00111C\u0012\u0011\u0002\u0003\u0007\u0011q\u0003\u0005\n\u0003K\u0019\u0003\u0013!a\u0001\u0003SA\u0011\"!\r$!\u0003\u0005\r!!\u000e\t\u0013\u000553\u0005%AA\u0002\u0005E\u0003\"CA-GA\u0005\t\u0019AA/\u0011%\tii\tI\u0001\u0002\u0004\t\t\u0006C\u0005\u0002\u0012\u000e\u0002\n\u00111\u0001\u0002\u0016\"I\u00111U\u0012\u0011\u0002\u0003\u0007\u0011\u0011\u000b\u0005\n\u0003O\u001b\u0003\u0013!a\u0001\u0003W\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003>)\u001aaNa\u0010,\u0005\t\u0005\u0003\u0003\u0002B\"\u0005\u001bj!A!\u0012\u000b\t\t\u001d#\u0011J\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa\u0013]\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005\u001f\u0012)EA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0003V)\u001aAOa\u0010\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\"\u0014AD2paf$C-\u001a4bk2$H%N\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00137+\t\u0011\tG\u000b\u0003\u0002\f\t}\u0012AD2paf$C-\u001a4bk2$HeN\u000b\u0003\u0005ORC!a\u0006\u0003@\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012BTC\u0001B7U\u0011\tICa\u0010\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%sU\u0011!1\u000f\u0016\u0005\u0003k\u0011y$A\bd_BLH\u0005Z3gCVdG\u000fJ\u00191+\t\u0011IH\u000b\u0003\u0002R\t}\u0012aD2paf$C-\u001a4bk2$H%M\u0019\u0016\u0005\t}$\u0006BA/\u0005\u007f\tqbY8qs\u0012\"WMZ1vYR$\u0013GM\u0001\u0010G>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132gU\u0011!q\u0011\u0016\u0005\u0003+\u0013y$A\bd_BLH\u0005Z3gCVdG\u000fJ\u00195\u0003=\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*TC\u0001BHU\u0011\tYKa\u0010\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\u0011)\n\u0005\u0003\u0003\u0018\n\u0005VB\u0001BM\u0015\u0011\u0011YJ!(\u0002\t1\fgn\u001a\u0006\u0003\u0005?\u000bAA[1wC&\u0019!P!'\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005m\u0015A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0005W\u0013\t\fE\u0002\\\u0005[K1Aa,]\u0005\r\te.\u001f\u0005\n\u0005g+\u0014\u0011!a\u0001\u00037\u000b1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001B]!\u0019\u0011YL!1\u0003,6\u0011!Q\u0018\u0006\u0004\u0005\u007fc\u0016AC2pY2,7\r^5p]&!!1\u0019B_\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005E#\u0011\u001a\u0005\n\u0005g;\u0014\u0011!a\u0001\u0005W\u000b!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!!Q\u0013Bh\u0011%\u0011\u0019\fOA\u0001\u0002\u0004\tY*\u0001\u0005iCND7i\u001c3f)\t\tY*\u0001\u0005u_N#(/\u001b8h)\t\u0011)*\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003#\u0012i\u000eC\u0005\u00034n\n\t\u00111\u0001\u0003,\u0006\u00012\u000b[8si\u0016\u001cH\u000fU1uQBK\u0007/\u001a\t\u0003/v\u001aR!\u0010Bs\u0005W\u00042a\u0017Bt\u0013\r\u0011I\u000f\u0018\u0002\u0007\u0003:L(+\u001a4\u0011\t\t5(1_\u0007\u0003\u0005_TAA!=\u0003\u001e\u0006\u0011\u0011n\\\u0005\u0004U\n=HC\u0001Bq\u0003\u0015\t\u0007\u000f\u001d7z)\u0001\u0012YPa@\u0004\u0002\r\r1QAB\u0004\u0007\u0013\u0019Ya!\u0004\u0004\u0010\rE11CB\u000b\u0007/\u0019Iba\u0007\u0015\t\u0005E'Q \u0005\n\u0003k\u0003\u0005\u0013!a\u0001\u0003sCQ\u0001\u001c!A\u00029DQA\u001d!A\u0002QDQ! !A\u0002QDQa !A\u0002QDa!a\u0001A\u0001\u0004!\bbBA\u0004\u0001\u0002\u0007\u00111\u0002\u0005\b\u0003'\u0001\u0005\u0019AA\f\u0011\u001d\t)\u0003\u0011a\u0001\u0003SAq!!\rA\u0001\u0004\t)\u0004C\u0004\u0002N\u0001\u0003\r!!\u0015\t\u000f\u0005e\u0003\t1\u0001\u0002^!9\u0011Q\u0012!A\u0002\u0005E\u0003bBAI\u0001\u0002\u0007\u0011Q\u0013\u0005\b\u0003G\u0003\u0005\u0019AA)\u0011\u001d\t9\u000b\u0011a\u0001\u0003W\u000b\u0001#\u00199qYf$C-\u001a4bk2$H%\r\u001c\u0015A\r\u000521EB\u0013\u0007O\u0019Ica\u000b\u0004.\r=2\u0011GB\u001a\u0007k\u00199d!\u000f\u0004<\ru2q\b\u0016\u0005\u0003s\u0013y\u0004C\u0003m\u0003\u0002\u0007a\u000eC\u0003s\u0003\u0002\u0007A\u000fC\u0003~\u0003\u0002\u0007A\u000fC\u0003\u0000\u0003\u0002\u0007A\u000f\u0003\u0004\u0002\u0004\u0005\u0003\r\u0001\u001e\u0005\b\u0003\u000f\t\u0005\u0019AA\u0006\u0011\u001d\t\u0019\"\u0011a\u0001\u0003/Aq!!\nB\u0001\u0004\tI\u0003C\u0004\u00022\u0005\u0003\r!!\u000e\t\u000f\u00055\u0013\t1\u0001\u0002R!9\u0011\u0011L!A\u0002\u0005u\u0003bBAG\u0003\u0002\u0007\u0011\u0011\u000b\u0005\b\u0003#\u000b\u0005\u0019AAK\u0011\u001d\t\u0019+\u0011a\u0001\u0003#Bq!a*B\u0001\u0004\tY+A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\r\u00153Q\n\t\u00067\u0006]5q\t\t\u001d7\u000e%c\u000e\u001e;ui\u0006-\u0011qCA\u0015\u0003k\t\t&!\u0018\u0002R\u0005U\u0015\u0011KAV\u0013\r\u0019Y\u0005\u0018\u0002\b)V\u0004H.Z\u00196\u0011%\u0019yEQA\u0001\u0002\u0004\t\t.A\u0002yIA\nA\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\nd\u0007\u0006\u0011\u0004\"\rU3qKB-\u00077\u001aifa\u0018\u0004b\r\r4QMB4\u0007S\u001aYg!\u001c\u0004p\rE\u0004\"\u00027D\u0001\u0004q\u0007\"\u0002:D\u0001\u0004!\b\"B?D\u0001\u0004!\b\"B@D\u0001\u0004!\bBBA\u0002\u0007\u0002\u0007A\u000fC\u0004\u0002\b\r\u0003\r!a\u0003\t\u000f\u0005M1\t1\u0001\u0002\u0018!9\u0011QE\"A\u0002\u0005%\u0002bBA\u0019\u0007\u0002\u0007\u0011Q\u0007\u0005\b\u0003\u001b\u001a\u0005\u0019AA)\u0011\u001d\tIf\u0011a\u0001\u0003;Bq!!$D\u0001\u0004\t\t\u0006C\u0004\u0002\u0012\u000e\u0003\r!!&\t\u000f\u0005\r6\t1\u0001\u0002R!9\u0011qU\"A\u0002\u0005-\u0016\u0001D<sSR,'+\u001a9mC\u000e,GCAB<!\u0011\u00119j!\u001f\n\t\rm$\u0011\u0014\u0002\u0007\u001f\nTWm\u0019;")
public class ShortestPathPipe
extends PipeWithSource
implements Product,
Serializable {
    private final Pipe source;
    private final String sourceNodeName;
    private final String targetNodeName;
    private final String pathName;
    private final String relsName;
    private final RelationshipTypes types;
    private final SemanticDirection direction;
    private final TraversalPredicates filteringStep;
    private final Seq<Predicate> pathPredicates;
    private final boolean returnOneShortestPathOnly;
    private final FindShortestPaths.SameNodeMode sameNodeMode;
    private final boolean allowZeroLength;
    private final Option<Object> maxDepth;
    private final boolean needOnlyOnePath;
    private final TraversalPathMode traversalMode;
    private final int id;

    public static int $lessinit$greater$default$16(Pipe source, String sourceNodeName, String targetNodeName, String pathName, String relsName, RelationshipTypes types, SemanticDirection direction, TraversalPredicates filteringStep, Seq pathPredicates, boolean returnOneShortestPathOnly, FindShortestPaths.SameNodeMode sameNodeMode, boolean allowZeroLength, Option maxDepth, boolean needOnlyOnePath, TraversalPathMode traversalMode) {
        return ShortestPathPipe$.MODULE$.$lessinit$greater$default$16(source, sourceNodeName, targetNodeName, pathName, relsName, types, direction, filteringStep, (Seq<Predicate>)pathPredicates, returnOneShortestPathOnly, sameNodeMode, allowZeroLength, (Option<Object>)maxDepth, needOnlyOnePath, traversalMode);
    }

    public static Option<Tuple15<Pipe, String, String, String, String, RelationshipTypes, SemanticDirection, TraversalPredicates, Seq<Predicate>, Object, FindShortestPaths.SameNodeMode, Object, Option<Object>, Object, TraversalPathMode>> unapply(ShortestPathPipe x$0) {
        return ShortestPathPipe$.MODULE$.unapply(x$0);
    }

    public static int apply$default$16(Pipe source, String sourceNodeName, String targetNodeName, String pathName, String relsName, RelationshipTypes types, SemanticDirection direction, TraversalPredicates filteringStep, Seq pathPredicates, boolean returnOneShortestPathOnly, FindShortestPaths.SameNodeMode sameNodeMode, boolean allowZeroLength, Option maxDepth, boolean needOnlyOnePath, TraversalPathMode traversalMode) {
        return ShortestPathPipe$.MODULE$.apply$default$16(source, sourceNodeName, targetNodeName, pathName, relsName, types, direction, filteringStep, (Seq<Predicate>)pathPredicates, returnOneShortestPathOnly, sameNodeMode, allowZeroLength, (Option<Object>)maxDepth, needOnlyOnePath, traversalMode);
    }

    public static ShortestPathPipe apply(Pipe source, String sourceNodeName, String targetNodeName, String pathName, String relsName, RelationshipTypes types, SemanticDirection direction, TraversalPredicates filteringStep, Seq<Predicate> pathPredicates, boolean returnOneShortestPathOnly, FindShortestPaths.SameNodeMode sameNodeMode, boolean allowZeroLength, Option<Object> maxDepth, boolean needOnlyOnePath, TraversalPathMode traversalMode, int id) {
        return ShortestPathPipe$.MODULE$.apply(source, sourceNodeName, targetNodeName, pathName, relsName, types, direction, filteringStep, pathPredicates, returnOneShortestPathOnly, sameNodeMode, allowZeroLength, maxDepth, needOnlyOnePath, traversalMode, id);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public Pipe source() {
        return this.source;
    }

    public String sourceNodeName() {
        return this.sourceNodeName;
    }

    public String targetNodeName() {
        return this.targetNodeName;
    }

    public String pathName() {
        return this.pathName;
    }

    public String relsName() {
        return this.relsName;
    }

    public RelationshipTypes types() {
        return this.types;
    }

    public SemanticDirection direction() {
        return this.direction;
    }

    public TraversalPredicates filteringStep() {
        return this.filteringStep;
    }

    public Seq<Predicate> pathPredicates() {
        return this.pathPredicates;
    }

    public boolean returnOneShortestPathOnly() {
        return this.returnOneShortestPathOnly;
    }

    public FindShortestPaths.SameNodeMode sameNodeMode() {
        return this.sameNodeMode;
    }

    public boolean allowZeroLength() {
        return this.allowZeroLength;
    }

    public Option<Object> maxDepth() {
        return this.maxDepth;
    }

    public boolean needOnlyOnePath() {
        return this.needOnlyOnePath;
    }

    public TraversalPathMode traversalMode() {
        return this.traversalMode;
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public ClosingIterator<CypherRow> internalCreateResults(ClosingIterator<CypherRow> input, QueryState state) {
        FindShortestPaths.SameNodeMode sameNodeMode = this.sameNodeMode();
        FindShortestPaths.DisallowSameNode$ disallowSameNode$ = FindShortestPaths.DisallowSameNode$.MODULE$;
        if (!(sameNodeMode != null ? !sameNodeMode.equals(disallowSameNode$) : disallowSameNode$ != null)) {
            String string = this.sourceNodeName();
            String string2 = this.targetNodeName();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                throw ShortestPathCommonEndNodesForbiddenException.shortestPathCommonEndNodes();
            }
        }
        MemoryTracker memoryTracker = state.memoryTrackerForOperatorProvider().memoryTrackerForOperator(this.id());
        NodeCursor nodeCursor = state.query().nodeCursor();
        state.query().resources().trace((AutoCloseablePlus)nodeCursor);
        RelationshipTraversalCursor traversalCursor = state.query().traversalCursor();
        state.query().resources().trace((AutoCloseablePlus)traversalCursor);
        Predicate pathPredicate = (Predicate)this.pathPredicates().foldLeft((Object)new True(), (Function2 & Serializable)(x$1, x$2) -> x$1.andWith((Predicate)x$2));
        ClosingIterator output = input.flatMap((Function1 & Serializable)row -> {
            AnyValue anyValue;
            AnyValue anyValue2;
            Tuple2 tuple2 = new Tuple2((Object)row.getByName(this.sourceNodeName()), (Object)row.getByName(this.targetNodeName()));
            if (tuple2 != null) {
                AnyValue sourceNode = (AnyValue)tuple2._1();
                AnyValue targetNode = (AnyValue)tuple2._2();
                if (sourceNode instanceof VirtualNodeValue) {
                    VirtualNodeValue virtualNodeValue = (VirtualNodeValue)sourceNode;
                    if (targetNode instanceof VirtualNodeValue) {
                        VirtualNodeValue virtualNodeValue2 = (VirtualNodeValue)targetNode;
                        if (this.filteringStep().filterNode((ReadableRow)row, state, virtualNodeValue) && this.filteringStep().filterNode((ReadableRow)row, state, virtualNodeValue2)) {
                            if (this.sameNodeMode().shouldReturnEmptyResult(virtualNodeValue.id(), virtualNodeValue2.id(), this.allowZeroLength())) {
                                return ClosingIterator$.MODULE$.empty();
                            }
                            TraversalPathMode traversalPathMode = this.traversalMode();
                            TraversalPathMode.Walk$ walk$ = TraversalPathMode.Walk$.MODULE$;
                            ShortestPathBFS bfs = ShortestPathBFSFactory.create((long)virtualNodeValue.id(), (long)virtualNodeValue2.id(), (int[])this.types().types((ReadTokenContext)state.query()), (Direction)DirectionConverter$.MODULE$.toGraphDb(this.direction()), (int)BoxesRunTime.unboxToInt((Object)this.maxDepth().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> Integer.MAX_VALUE)), (Read)state.query().transactionalContext().dataRead(), (NodeCursor)nodeCursor, (RelationshipTraversalCursor)traversalCursor, (MemoryTracker)memoryTracker, (LongPredicate)this.filteringStep().asNodeIdPredicate((ReadableRow)row, state), this.filteringStep().asRelCursorPredicate((ReadableRow)row, state), (boolean)this.returnOneShortestPathOnly(), (boolean)this.allowZeroLength(), (boolean)this.needOnlyOnePath(), (!(traversalPathMode != null ? !traversalPathMode.equals(walk$) : walk$ != null) ? 1 : 0) != 0, null);
                            java.util.Iterator shortestPaths = bfs.shortestPathIterator();
                            ClosingIterator outputRows = ClosingIterator$.MODULE$.asClosingIterator(shortestPaths).map((Function1 & Serializable)path -> {
                                ListValue rels = VirtualValues.list((AnyValue[])((AnyValue[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.longArrayOps(path.relationshipIds()), (Function1 & Serializable)x$1 -> ShortestPathPipe.$anonfun$internalCreateResults$5(BoxesRunTime.unboxToLong((Object)x$1)), ClassTag$.MODULE$.apply(RelationshipReference.class))));
                                return this.rowFactory().copyWith((ReadableRow)row, this.pathName(), (AnyValue)path, this.relsName(), (AnyValue)rels);
                            }).filter((Function1 & Serializable)r -> BoxesRunTime.boxToBoolean((boolean)pathPredicate.isTrue((ReadableRow)r, state))).closing((AutoCloseable)bfs);
                            if (this.returnOneShortestPathOnly()) {
                                if (outputRows.hasNext()) {
                                    return ClosingIterator$.MODULE$.single(outputRows.next());
                                }
                                return ClosingIterator$.MODULE$.empty();
                            }
                            return outputRows;
                        }
                        return ClosingIterator$.MODULE$.empty();
                    }
                }
            }
            if (tuple2 != null && (anyValue2 = (AnyValue)tuple2._1()) != null && IsNoValue$.MODULE$.unapply(anyValue2) ? true : tuple2 != null && (anyValue = (AnyValue)tuple2._2()) != null && IsNoValue$.MODULE$.unapply(anyValue)) {
                return ClosingIterator$.MODULE$.empty();
            }
            if (tuple2 != null) {
                AnyValue value = (AnyValue)tuple2._1();
                if (tuple2._2() instanceof VirtualNodeValue) {
                    throw CypherTypeException.expectedNodeButGot((String)value.prettyPrint(), (String)value.getTypeName(), (String)CypherTypeValueMapper.valueType((AnyValue)value));
                }
            }
            if (tuple2 != null) {
                AnyValue value = (AnyValue)tuple2._2();
                throw CypherTypeException.expectedNodeButGot((String)value.prettyPrint(), (String)value.getTypeName(), (String)CypherTypeValueMapper.valueType((AnyValue)value));
            }
            throw new MatchError((Object)tuple2);
        });
        return output.closing((AutoCloseable)traversalCursor).closing((AutoCloseable)nodeCursor);
    }

    public ShortestPathPipe copy(Pipe source, String sourceNodeName, String targetNodeName, String pathName, String relsName, RelationshipTypes types, SemanticDirection direction, TraversalPredicates filteringStep, Seq<Predicate> pathPredicates, boolean returnOneShortestPathOnly, FindShortestPaths.SameNodeMode sameNodeMode, boolean allowZeroLength, Option<Object> maxDepth, boolean needOnlyOnePath, TraversalPathMode traversalMode, int id) {
        return new ShortestPathPipe(source, sourceNodeName, targetNodeName, pathName, relsName, types, direction, filteringStep, pathPredicates, returnOneShortestPathOnly, sameNodeMode, allowZeroLength, maxDepth, needOnlyOnePath, traversalMode, id);
    }

    public Pipe copy$default$1() {
        return this.source();
    }

    public boolean copy$default$10() {
        return this.returnOneShortestPathOnly();
    }

    public FindShortestPaths.SameNodeMode copy$default$11() {
        return this.sameNodeMode();
    }

    public boolean copy$default$12() {
        return this.allowZeroLength();
    }

    public Option<Object> copy$default$13() {
        return this.maxDepth();
    }

    public boolean copy$default$14() {
        return this.needOnlyOnePath();
    }

    public TraversalPathMode copy$default$15() {
        return this.traversalMode();
    }

    public String copy$default$2() {
        return this.sourceNodeName();
    }

    public String copy$default$3() {
        return this.targetNodeName();
    }

    public String copy$default$4() {
        return this.pathName();
    }

    public String copy$default$5() {
        return this.relsName();
    }

    public RelationshipTypes copy$default$6() {
        return this.types();
    }

    public SemanticDirection copy$default$7() {
        return this.direction();
    }

    public TraversalPredicates copy$default$8() {
        return this.filteringStep();
    }

    public Seq<Predicate> copy$default$9() {
        return this.pathPredicates();
    }

    public String productPrefix() {
        return "ShortestPathPipe";
    }

    public int productArity() {
        return 15;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.source();
            }
            case 1: {
                return this.sourceNodeName();
            }
            case 2: {
                return this.targetNodeName();
            }
            case 3: {
                return this.pathName();
            }
            case 4: {
                return this.relsName();
            }
            case 5: {
                return this.types();
            }
            case 6: {
                return this.direction();
            }
            case 7: {
                return this.filteringStep();
            }
            case 8: {
                return this.pathPredicates();
            }
            case 9: {
                return BoxesRunTime.boxToBoolean((boolean)this.returnOneShortestPathOnly());
            }
            case 10: {
                return this.sameNodeMode();
            }
            case 11: {
                return BoxesRunTime.boxToBoolean((boolean)this.allowZeroLength());
            }
            case 12: {
                return this.maxDepth();
            }
            case 13: {
                return BoxesRunTime.boxToBoolean((boolean)this.needOnlyOnePath());
            }
            case 14: {
                return this.traversalMode();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ShortestPathPipe;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "source";
            }
            case 1: {
                return "sourceNodeName";
            }
            case 2: {
                return "targetNodeName";
            }
            case 3: {
                return "pathName";
            }
            case 4: {
                return "relsName";
            }
            case 5: {
                return "types";
            }
            case 6: {
                return "direction";
            }
            case 7: {
                return "filteringStep";
            }
            case 8: {
                return "pathPredicates";
            }
            case 9: {
                return "returnOneShortestPathOnly";
            }
            case 10: {
                return "sameNodeMode";
            }
            case 11: {
                return "allowZeroLength";
            }
            case 12: {
                return "maxDepth";
            }
            case 13: {
                return "needOnlyOnePath";
            }
            case 14: {
                return "traversalMode";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.source()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.sourceNodeName()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.targetNodeName()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.pathName()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.relsName()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.types()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.direction()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.filteringStep()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.pathPredicates()));
        n = Statics.mix((int)n, (int)(this.returnOneShortestPathOnly() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.sameNodeMode()));
        n = Statics.mix((int)n, (int)(this.allowZeroLength() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.maxDepth()));
        n = Statics.mix((int)n, (int)(this.needOnlyOnePath() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.traversalMode()));
        return Statics.finalizeHash((int)n, (int)15);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ShortestPathPipe)) return false;
        boolean bl = true;
        if (!bl) return false;
        ShortestPathPipe shortestPathPipe = (ShortestPathPipe)x$1;
        if (this.returnOneShortestPathOnly() != shortestPathPipe.returnOneShortestPathOnly()) return false;
        if (this.allowZeroLength() != shortestPathPipe.allowZeroLength()) return false;
        if (this.needOnlyOnePath() != shortestPathPipe.needOnlyOnePath()) return false;
        Pipe pipe = this.source();
        Pipe pipe2 = shortestPathPipe.source();
        if (pipe == null) {
            if (pipe2 != null) {
                return false;
            }
        } else if (!pipe.equals(pipe2)) return false;
        String string = this.sourceNodeName();
        String string2 = shortestPathPipe.sourceNodeName();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = this.targetNodeName();
        String string4 = shortestPathPipe.targetNodeName();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        String string5 = this.pathName();
        String string6 = shortestPathPipe.pathName();
        if (string5 == null) {
            if (string6 != null) {
                return false;
            }
        } else if (!string5.equals(string6)) return false;
        String string7 = this.relsName();
        String string8 = shortestPathPipe.relsName();
        if (string7 == null) {
            if (string8 != null) {
                return false;
            }
        } else if (!string7.equals(string8)) return false;
        RelationshipTypes relationshipTypes = this.types();
        RelationshipTypes relationshipTypes2 = shortestPathPipe.types();
        if (relationshipTypes == null) {
            if (relationshipTypes2 != null) {
                return false;
            }
        } else if (!relationshipTypes.equals(relationshipTypes2)) return false;
        SemanticDirection semanticDirection = this.direction();
        SemanticDirection semanticDirection2 = shortestPathPipe.direction();
        if (semanticDirection == null) {
            if (semanticDirection2 != null) {
                return false;
            }
        } else if (!semanticDirection.equals(semanticDirection2)) return false;
        TraversalPredicates traversalPredicates = this.filteringStep();
        TraversalPredicates traversalPredicates2 = shortestPathPipe.filteringStep();
        if (traversalPredicates == null) {
            if (traversalPredicates2 != null) {
                return false;
            }
        } else if (!traversalPredicates.equals(traversalPredicates2)) return false;
        Seq<Predicate> seq = this.pathPredicates();
        Seq<Predicate> seq2 = shortestPathPipe.pathPredicates();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        FindShortestPaths.SameNodeMode sameNodeMode = this.sameNodeMode();
        FindShortestPaths.SameNodeMode sameNodeMode2 = shortestPathPipe.sameNodeMode();
        if (sameNodeMode == null) {
            if (sameNodeMode2 != null) {
                return false;
            }
        } else if (!sameNodeMode.equals(sameNodeMode2)) return false;
        Option<Object> option = this.maxDepth();
        Option<Object> option2 = shortestPathPipe.maxDepth();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        TraversalPathMode traversalPathMode = this.traversalMode();
        TraversalPathMode traversalPathMode2 = shortestPathPipe.traversalMode();
        if (traversalPathMode == null) {
            if (traversalPathMode2 != null) {
                return false;
            }
        } else if (!traversalPathMode.equals(traversalPathMode2)) return false;
        if (!shortestPathPipe.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ RelationshipReference $anonfun$internalCreateResults$5(long x$1) {
        return VirtualValues.relationship((long)x$1);
    }

    public ShortestPathPipe(Pipe source, String sourceNodeName, String targetNodeName, String pathName, String relsName, RelationshipTypes types, SemanticDirection direction, TraversalPredicates filteringStep, Seq<Predicate> pathPredicates, boolean returnOneShortestPathOnly, FindShortestPaths.SameNodeMode sameNodeMode, boolean allowZeroLength, Option<Object> maxDepth, boolean needOnlyOnePath, TraversalPathMode traversalMode, int id) {
        this.source = source;
        this.sourceNodeName = sourceNodeName;
        this.targetNodeName = targetNodeName;
        this.pathName = pathName;
        this.relsName = relsName;
        this.types = types;
        this.direction = direction;
        this.filteringStep = filteringStep;
        this.pathPredicates = pathPredicates;
        this.returnOneShortestPathOnly = returnOneShortestPathOnly;
        this.sameNodeMode = sameNodeMode;
        this.allowZeroLength = allowZeroLength;
        this.maxDepth = maxDepth;
        this.needOnlyOnePath = needOnlyOnePath;
        this.traversalMode = traversalMode;
        this.id = id;
        super(source);
        Product.$init$((Product)this);
    }
}

