/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.commands;

import java.io.Serializable;
import org.neo4j.cypher.internal.ast.semantics.TokenTable;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.cypher.internal.expressions.LogicalVariable;
import org.neo4j.cypher.internal.expressions.RelTypeName;
import org.neo4j.cypher.internal.logical.plans.Expand;
import org.neo4j.cypher.internal.logical.plans.NFA;
import org.neo4j.cypher.internal.runtime.CypherRow;
import org.neo4j.cypher.internal.runtime.ReadableRow;
import org.neo4j.cypher.internal.runtime.ast.ExpressionVariable;
import org.neo4j.cypher.internal.runtime.ast.ExpressionVariable$;
import org.neo4j.cypher.internal.runtime.ast.TraversalEndpoint;
import org.neo4j.cypher.internal.runtime.ast.TraversalEndpoint$;
import org.neo4j.cypher.internal.runtime.interpreted.commands.CommandNFA;
import org.neo4j.cypher.internal.runtime.interpreted.commands.CommandNFA$;
import org.neo4j.cypher.internal.runtime.interpreted.commands.CommandNFA$CompoundPredicate$;
import org.neo4j.cypher.internal.runtime.interpreted.commands.CommandNFA$RelationshipExpansionTransition$;
import org.neo4j.cypher.internal.runtime.interpreted.commands.predicates.Predicate;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.QueryState;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.RelationshipTypes;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.RelationshipTypes$;
import org.neo4j.internal.kernel.api.RelationshipTraversalEntities;
import org.neo4j.internal.kernel.api.helpers.traversal.SlotOrName;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.values.AnyValue;
import org.neo4j.values.virtual.VirtualRelationshipValue;
import org.neo4j.values.virtual.VirtualValues;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOps;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;

public final class CommandNFA$
implements Serializable {
    public static final CommandNFA$ MODULE$ = new CommandNFA$();

    public CommandNFA fromLogicalNFA(NFA logicalNFA, Function1<Expression, Predicate> predicateToCommand, Function1<LogicalVariable, SlotOrName> getSlotOrName, TokenTable st) {
        ObjectRef startState = ObjectRef.create(null);
        ObjectRef finalState = ObjectRef.create(null);
        Map stateLookup = logicalNFA.states().iterator().map((Function1 & Serializable)logicalState -> {
            CommandNFA.State commandState;
            block1: {
                commandState = new CommandNFA.State(logicalState.id(), (SlotOrName)getSlotOrName.apply((Object)logicalState.variable()), (Option<Function3<CypherRow, QueryState, AnyValue, Object>>)logicalState.variablePredicate().map((Function1 & Serializable)varPredicate -> CommandNFA$.convertNodePredicate$1(varPredicate, predicateToCommand)), null, null, null);
                NFA.State state = logicalNFA.startState();
                NFA.State state2 = logicalState;
                if (!(state != null ? !state.equals(state2) : state2 != null)) {
                    Predef$.MODULE$.assert((CommandNFA.State)startState$1.elem == null, (Function0 & Serializable)() -> "There should only be one start state in an NFA");
                    startState$1.elem = commandState;
                }
                NFA.State state3 = logicalNFA.finalState();
                NFA.State state4 = logicalState;
                if (state3 != null ? !state3.equals(state4) : state4 != null) break block1;
                Predef$.MODULE$.assert((CommandNFA.State)finalState$1.elem == null, (Function0 & Serializable)() -> "There should only be one final state in an NFA");
                finalState$1.elem = commandState;
            }
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)logicalState.id())), (Object)commandState);
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        logicalNFA.states().foreach((Function1 & Serializable)logicalState -> {
            CommandNFA$.$anonfun$fromLogicalNFA$9(logicalNFA, stateLookup, st, getSlotOrName, predicateToCommand, logicalState);
            return BoxedUnit.UNIT;
        });
        return new CommandNFA((Set<CommandNFA.State>)stateLookup.values().toSet(), (CommandNFA.State)startState.elem, (CommandNFA.State)finalState.elem);
    }

    public Function1<LogicalVariable, SlotOrName> fromLogicalNFA$default$3() {
        return (Function1 & Serializable)x -> SlotOrName.None$.MODULE$;
    }

    public CommandNFA apply(Set<CommandNFA.State> states, CommandNFA.State startState, CommandNFA.State finalState) {
        return new CommandNFA(states, startState, finalState);
    }

    public Option<Tuple3<Set<CommandNFA.State>, CommandNFA.State, CommandNFA.State>> unapply(CommandNFA x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple3(x$0.states(), (Object)x$0.startState(), (Object)x$0.finalState()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(CommandNFA$.class);
    }

    public static final /* synthetic */ boolean $anonfun$fromLogicalNFA$1(int offset$1, Predicate predicate$3, CypherRow row, QueryState state, AnyValue entity) {
        state.expressionVariables()[offset$1] = entity;
        return predicate$3.isTrue((ReadableRow)row, state);
    }

    private static final Function3 convertNodePredicate$1(Expand.VariablePredicate varPredicate, Function1 predicateToCommand$1) {
        Predicate predicate = (Predicate)predicateToCommand$1.apply((Object)varPredicate.predicate());
        int offset = ExpressionVariable$.MODULE$.cast(varPredicate.variable()).offset();
        return (Function3 & Serializable)(row, state, entity) -> BoxesRunTime.boxToBoolean((boolean)CommandNFA$.$anonfun$fromLogicalNFA$1(offset, predicate, row, state, entity));
    }

    public static final /* synthetic */ void $anonfun$fromLogicalNFA$3(QueryState state$2, RelationshipTraversalEntities rel$1, TraversalEndpoint.AllocatedTraversalEndpoint x0$1) {
        TraversalEndpoint.AllocatedTraversalEndpoint allocatedTraversalEndpoint = x0$1;
        if (allocatedTraversalEndpoint != null) {
            long l;
            int offset = allocatedTraversalEndpoint.exprVarOffset();
            TraversalEndpoint.Endpoint end = allocatedTraversalEndpoint.endpoint();
            AnyValue[] anyValueArray = state$2.expressionVariables();
            TraversalEndpoint.Endpoint endpoint = end;
            if (TraversalEndpoint.Endpoint$.From$.MODULE$.equals(endpoint)) {
                l = rel$1.originNodeReference();
            } else if (TraversalEndpoint.Endpoint$.To$.MODULE$.equals(endpoint)) {
                l = rel$1.otherNodeReference();
            } else {
                throw new MatchError((Object)endpoint);
            }
            anyValueArray[offset] = VirtualValues.node((long)l);
            return;
        }
        throw new MatchError((Object)allocatedTraversalEndpoint);
    }

    public static final /* synthetic */ boolean $anonfun$fromLogicalNFA$2(int offset$2, Seq traversalEndpoints$1, Predicate predicate$4, CypherRow row, QueryState state, RelationshipTraversalEntities rel) {
        state.expressionVariables()[offset$2] = ValueUtils.fromRelationshipCursor((RelationshipTraversalEntities)rel);
        traversalEndpoints$1.foreach((Function1 & Serializable)x0$1 -> {
            CommandNFA$.$anonfun$fromLogicalNFA$3(state, rel, x0$1);
            return BoxedUnit.UNIT;
        });
        return predicate$4.isTrue((ReadableRow)row, state);
    }

    private static final Function3 convertRelPredicate$1(Expand.VariablePredicate varPredicate, Function1 predicateToCommand$1) {
        Predicate predicate = (Predicate)predicateToCommand$1.apply((Object)varPredicate.predicate());
        int offset = ExpressionVariable$.MODULE$.cast(varPredicate.variable()).offset();
        Seq traversalEndpoints = TraversalEndpoint$.MODULE$.extract(varPredicate.predicate());
        return (Function3 & Serializable)(row, state, rel) -> BoxesRunTime.boxToBoolean((boolean)CommandNFA$.$anonfun$fromLogicalNFA$2(offset, traversalEndpoints, predicate, row, state, rel));
    }

    private static final CommandNFA.RelationshipExpansionTransition compileStubbedRelationshipExpansion$1(NFA.RelationshipExpansionPredicate logicalPredicate, CommandNFA.State end, TokenTable st, Function1 getSlotOrName$1, Function1 predicateToCommand$1) {
        Option commandRelPred = logicalPredicate.relPred().map((Function1 & Serializable)varPredicate -> CommandNFA$.convertRelPredicate$1(varPredicate, predicateToCommand$1));
        Seq types = logicalPredicate.types();
        RelationshipTypes relTypes = types.isEmpty() ? null : RelationshipTypes$.MODULE$.apply((RelTypeName[])types.toArray(ClassTag$.MODULE$.apply(RelTypeName.class)), st);
        return CommandNFA$RelationshipExpansionTransition$.MODULE$.apply((Option<Function3<CypherRow, QueryState, RelationshipTraversalEntities, Object>>)commandRelPred, (SlotOrName)getSlotOrName$1.apply((Object)logicalPredicate.relationshipVariable()), relTypes, logicalPredicate.dir(), end);
    }

    public static final /* synthetic */ void $anonfun$fromLogicalNFA$9(NFA logicalNFA$1, Map stateLookup$2, TokenTable st$1, Function1 getSlotOrName$1, Function1 predicateToCommand$1, NFA.State logicalState) {
        Iterable transitions = (Iterable)logicalNFA$1.transitions().getOrElse((Object)BoxesRunTime.boxToInteger((int)logicalState.id()), (Function0 & Serializable)() -> (Seq)package$.MODULE$.Seq().empty());
        ArrayBuffer njs = ArrayBuffer$.MODULE$.empty();
        ArrayBuffer res = ArrayBuffer$.MODULE$.empty();
        ArrayBuffer mres = ArrayBuffer$.MODULE$.empty();
        transitions.foreach((Function1 & Serializable)x0$1 -> {
            NFA.Transition transition = x0$1;
            if (transition instanceof NFA.NodeJuxtapositionTransition) {
                NFA.NodeJuxtapositionTransition nodeJuxtapositionTransition = (NFA.NodeJuxtapositionTransition)transition;
                int endId = nodeJuxtapositionTransition.endId();
                NFA.State end = (NFA.State)logicalNFA$1.states().apply(endId);
                return (ArrayBuffer)njs.append((Object)new CommandNFA.NodeJuxtapositionTransition((CommandNFA.State)stateLookup$2.apply((Object)BoxesRunTime.boxToInteger((int)end.id()))));
            }
            if (transition instanceof NFA.RelationshipExpansionTransition) {
                NFA.RelationshipExpansionTransition relationshipExpansionTransition = (NFA.RelationshipExpansionTransition)transition;
                NFA.RelationshipExpansionPredicate rp2 = relationshipExpansionTransition.predicate();
                int endId = relationshipExpansionTransition.endId();
                if (rp2 != null) {
                    NFA.RelationshipExpansionPredicate relationshipExpansionPredicate = rp2;
                    NFA.State end = (NFA.State)logicalNFA$1.states().apply(endId);
                    return (ArrayBuffer)res.append((Object)CommandNFA$.compileStubbedRelationshipExpansion$1(relationshipExpansionPredicate, (CommandNFA.State)stateLookup$2.apply((Object)BoxesRunTime.boxToInteger((int)end.id())), st$1, getSlotOrName$1, predicateToCommand$1));
                }
            }
            if (transition instanceof NFA.MultiRelationshipExpansionTransition) {
                NFA.MultiRelationshipExpansionTransition multiRelationshipExpansionTransition = (NFA.MultiRelationshipExpansionTransition)transition;
                Seq relPredicates = multiRelationshipExpansionTransition.relPredicates();
                Seq nodePredicates = multiRelationshipExpansionTransition.nodePredicates();
                Option compoundPredicate = multiRelationshipExpansionTransition.compoundPredicate();
                int endId = multiRelationshipExpansionTransition.endId();
                NFA.State end = (NFA.State)logicalNFA$1.states().apply(endId);
                Seq commandRelPreds = (Seq)relPredicates.map((Function1 & Serializable)rp -> new CommandNFA.RelationshipQualifiers((Option<Function3<CypherRow, QueryState, RelationshipTraversalEntities, Object>>)rp.relPred().map((Function1 & Serializable)varPredicate -> CommandNFA$.convertRelPredicate$1(varPredicate, predicateToCommand$1)), (SlotOrName)getSlotOrName$1.apply((Object)rp.relationshipVariable()), rp.types().isEmpty() ? null : RelationshipTypes$.MODULE$.apply((RelTypeName[])rp.types().toArray(ClassTag$.MODULE$.apply(RelTypeName.class)), st$1), rp.dir()));
                Seq commandNodePreds = (Seq)nodePredicates.map((Function1 & Serializable)np -> new CommandNFA.NodeQualifiers((Option<Function3<CypherRow, QueryState, AnyValue, Object>>)np.nodePred().map((Function1 & Serializable)varPredicate -> CommandNFA$.convertNodePredicate$1(varPredicate, predicateToCommand$1)), (SlotOrName)getSlotOrName$1.apply((Object)np.nodeVariable())));
                CommandNFA.CompoundPredicate commandCompoundPred = (CommandNFA.CompoundPredicate)compoundPredicate.map((Function1 & Serializable)expr -> {
                    Predicate predicate = (Predicate)predicateToCommand$1.apply(expr);
                    Option startVar = ExpressionVariable$.MODULE$.castOpt(logicalState.variable());
                    Option endVar = ExpressionVariable$.MODULE$.castOpt(end.variable());
                    Seq relVars = (Seq)((IterableOps)relPredicates.map((Function1 & Serializable)x$8 -> x$8.relationshipVariable())).map((Function1 & Serializable)variable -> ExpressionVariable$.MODULE$.castOpt(variable));
                    Seq nodeVars = (Seq)((IterableOps)nodePredicates.map((Function1 & Serializable)x$9 -> x$9.nodeVariable())).map((Function1 & Serializable)variable -> ExpressionVariable$.MODULE$.castOpt(variable));
                    return new CommandNFA.CompoundPredicate(startVar, endVar, relVars, nodeVars, predicate){
                        private final Option startVar$1;
                        private final Option endVar$1;
                        private final Seq relVars$1;
                        private final Seq nodeVars$1;
                        private final Predicate predicate$5;

                        public boolean test(CypherRow row, QueryState state, long startNode, VirtualRelationshipValue[] rels, long[] interiorNodes, long endNode) {
                            anon.1.setVar$1(this.startVar$1, (AnyValue)VirtualValues.node((long)startNode), state);
                            anon.1.setVar$1(this.endVar$1, (AnyValue)VirtualValues.node((long)endNode), state);
                            for (int i = 0; i < interiorNodes.length; ++i) {
                                anon.1.setVar$1((Option)this.relVars$1.apply(i), (AnyValue)rels[i], state);
                                anon.1.setVar$1((Option)this.nodeVars$1.apply(i), (AnyValue)VirtualValues.node((long)interiorNodes[i]), state);
                            }
                            anon.1.setVar$1((Option)this.relVars$1.last(), (AnyValue)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])rels)), state);
                            return this.predicate$5.isTrue((ReadableRow)row, state);
                        }

                        private static final void setVar$1(Option optExprVar, AnyValue value, QueryState state$3) {
                            Option option = optExprVar;
                            if (option instanceof Some) {
                                Some some = (Some)option;
                                ExpressionVariable ev = (ExpressionVariable)some.value();
                                state$3.expressionVariables()[ev.offset()] = value;
                                return;
                            }
                            if (None$.MODULE$.equals(option)) {
                                return;
                            }
                            throw new MatchError((Object)option);
                        }
                        {
                            this.startVar$1 = startVar$1;
                            this.endVar$1 = endVar$1;
                            this.relVars$1 = relVars$1;
                            this.nodeVars$1 = nodeVars$1;
                            this.predicate$5 = predicate$5;
                        }
                    };
                }).getOrElse((Function0 & Serializable)() -> CommandNFA$CompoundPredicate$.MODULE$.ALWAYS_TRUE());
                CommandNFA.MultiRelationshipExpansionTransition mre = new CommandNFA.MultiRelationshipExpansionTransition((Seq<CommandNFA.RelationshipQualifiers>)commandRelPreds, (Seq<CommandNFA.NodeQualifiers>)commandNodePreds, commandCompoundPred, (CommandNFA.State)stateLookup$2.apply((Object)BoxesRunTime.boxToInteger((int)end.id())));
                return (ArrayBuffer)mres.append((Object)mre);
            }
            throw new MatchError((Object)transition);
        });
        CommandNFA.State commandState = (CommandNFA.State)stateLookup$2.apply((Object)BoxesRunTime.boxToInteger((int)logicalState.id()));
        commandState.nodeTransitions_$eq((Seq<CommandNFA.NodeJuxtapositionTransition>)njs.toSeq());
        commandState.relTransitions_$eq((Seq<CommandNFA.RelationshipExpansionTransition>)res.toSeq());
        commandState.multiRelTransitions_$eq((Seq<CommandNFA.MultiRelationshipExpansionTransition>)mres.toSeq());
    }

    private CommandNFA$() {
    }
}

