/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.frontend.v3_2.phases;

import org.neo4j.cypher.internal.frontend.v3_2.Foldable$;
import org.neo4j.cypher.internal.frontend.v3_2.Foldable$FoldableAny$;
import org.neo4j.cypher.internal.frontend.v3_2.ast.FunctionInvocation;
import org.neo4j.cypher.internal.frontend.v3_2.ast.FunctionName;
import org.neo4j.cypher.internal.frontend.v3_2.ast.Statement;
import org.neo4j.cypher.internal.frontend.v3_2.ast.rewriters.replaceAliasedFunctionInvocations$;
import org.neo4j.cypher.internal.frontend.v3_2.notification.DeprecatedFunctionNotification;
import org.neo4j.cypher.internal.frontend.v3_2.notification.InternalNotification;
import org.neo4j.cypher.internal.frontend.v3_2.phases.BaseContext;
import org.neo4j.cypher.internal.frontend.v3_2.phases.BaseState;
import org.neo4j.cypher.internal.frontend.v3_2.phases.CompilationPhaseTracer;
import org.neo4j.cypher.internal.frontend.v3_2.phases.Condition;
import org.neo4j.cypher.internal.frontend.v3_2.phases.InternalNotificationLogger;
import org.neo4j.cypher.internal.frontend.v3_2.phases.Phase$class;
import org.neo4j.cypher.internal.frontend.v3_2.phases.Transformer;
import org.neo4j.cypher.internal.frontend.v3_2.phases.Transformer$class;
import org.neo4j.cypher.internal.frontend.v3_2.phases.VisitorPhase;
import org.neo4j.cypher.internal.frontend.v3_2.phases.VisitorPhase$class;
import scala.Function1;
import scala.None$;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.immutable.Set;

public final class SyntaxDeprecationWarnings$
implements VisitorPhase<BaseContext, BaseState> {
    public static final SyntaxDeprecationWarnings$ MODULE$;

    static {
        new SyntaxDeprecationWarnings$();
    }

    @Override
    public Object process(Object from2, BaseContext context) {
        return VisitorPhase$class.process(this, from2, context);
    }

    @Override
    public Set<Condition> postConditions() {
        return VisitorPhase$class.postConditions(this);
    }

    @Override
    public Object transform(Object from2, BaseContext context) {
        return Phase$class.transform(this, from2, context);
    }

    @Override
    public String name() {
        return Phase$class.name(this);
    }

    @Override
    public <D extends BaseContext, TO2> Transformer<D, BaseState, TO2> andThen(Transformer<D, BaseState, TO2> other) {
        return Transformer$class.andThen(this, other);
    }

    @Override
    public Transformer<BaseContext, BaseState, BaseState> adds(Condition condition) {
        return Transformer$class.adds(this, condition);
    }

    @Override
    public void visit(BaseState state, BaseContext context) {
        Set<InternalNotification> warnings = this.findDeprecations(state.statement());
        InternalNotificationLogger internalNotificationLogger = context.notificationLogger();
        warnings.foreach((Function1)new Serializable(internalNotificationLogger){
            public static final long serialVersionUID = 0L;
            private final InternalNotificationLogger eta$0$1$1;

            public final void apply(InternalNotification notification) {
                this.eta$0$1$1.log(notification);
            }
            {
                this.eta$0$1$1 = eta$0$1$1;
            }
        });
    }

    private Set<InternalNotification> findDeprecations(Statement statement2) {
        return Foldable$FoldableAny$.MODULE$.treeFold$extension(Foldable$.MODULE$.FoldableAny(statement2), Predef$.MODULE$.Set().empty(), new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                void var7_9;
                FunctionInvocation functionInvocation;
                FunctionName functionName;
                A1 A1 = x1;
                if (A1 instanceof FunctionInvocation && (functionName = (functionInvocation = (FunctionInvocation)A1).functionName()) != null) {
                    String name = functionName.name();
                    if (replaceAliasedFunctionInvocations$.MODULE$.aliases().get((Object)name).nonEmpty()) {
                        Serializable serializable = new Serializable(this, name, functionInvocation){
                            public static final long serialVersionUID = 0L;
                            private final String name$1;
                            private final FunctionInvocation x2$1;

                            public final Tuple2<Set<InternalNotification>, None$> apply(Set<InternalNotification> seq) {
                                return new Tuple2((Object)seq.$plus((Object)new DeprecatedFunctionNotification(this.x2$1.position(), this.name$1, (String)replaceAliasedFunctionInvocations$.MODULE$.aliases().apply((Object)this.name$1))), (Object)None$.MODULE$);
                            }
                            {
                                this.name$1 = name$1;
                                this.x2$1 = x2$1;
                            }
                        };
                        return var7_9;
                    }
                }
                Object object = function1.apply(x1);
                return var7_9;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                if (!(object instanceof FunctionInvocation)) return false;
                FunctionInvocation functionInvocation = (FunctionInvocation)object;
                FunctionName functionName = functionInvocation.functionName();
                if (functionName == null) return false;
                String name = functionName.name();
                if (!replaceAliasedFunctionInvocations$.MODULE$.aliases().get((Object)name).nonEmpty()) return false;
                return true;
            }
        });
    }

    @Override
    public CompilationPhaseTracer.CompilationPhase phase() {
        return CompilationPhaseTracer.CompilationPhase.DEPRECATION_WARNINGS;
    }

    @Override
    public String description() {
        return "find deprecated Cypher constructs and generate warnings for them";
    }

    private SyntaxDeprecationWarnings$() {
        MODULE$ = this;
        Transformer$class.$init$(this);
        Phase$class.$init$(this);
        VisitorPhase$class.$init$(this);
    }
}

