/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v3_2.planner;

import org.neo4j.cypher.internal.compiler.v3_2.planner.PlannerQuery;
import org.neo4j.cypher.internal.compiler.v3_2.planner.QueryGraph;
import org.neo4j.cypher.internal.compiler.v3_2.planner.QueryHorizon;
import org.neo4j.cypher.internal.compiler.v3_2.planner.QueryProjection;
import org.neo4j.cypher.internal.compiler.v3_2.planner.RegularPlannerQuery;
import org.neo4j.cypher.internal.compiler.v3_2.planner.RegularQueryProjection;
import org.neo4j.cypher.internal.frontend.v3_2.InternalException;
import org.neo4j.cypher.internal.frontend.v3_2.InternalException$;
import org.neo4j.cypher.internal.frontend.v3_2.ast.Expression;
import org.neo4j.cypher.internal.frontend.v3_2.ast.Hint;
import org.neo4j.cypher.internal.frontend.v3_2.ast.LabelName;
import org.neo4j.cypher.internal.frontend.v3_2.ast.Variable;
import org.neo4j.cypher.internal.ir.v3_2.IdName;
import org.neo4j.cypher.internal.ir.v3_2.StrictnessMode;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;

public abstract class PlannerQuery$class {
    public static boolean readOnly(PlannerQuery $this) {
        return $this.queryGraph().readOnly() && $this.tail().forall((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(PlannerQuery x$2) {
                return x$2.readOnly();
            }
        });
    }

    public static Option preferredStrictness(PlannerQuery $this) {
        return $this.horizon().preferredStrictness().orElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlannerQuery $outer;

            public final Option<StrictnessMode> apply() {
                return this.$outer.tail().flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Option<StrictnessMode> apply(PlannerQuery x$3) {
                        return x$3.preferredStrictness();
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static PlannerQuery last(PlannerQuery $this) {
        return (PlannerQuery)$this.tail().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final PlannerQuery apply(PlannerQuery x$4) {
                return x$4.last();
            }
        }).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlannerQuery $outer;

            public final PlannerQuery apply() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static QueryGraph lastQueryGraph(PlannerQuery $this) {
        return $this.last().queryGraph();
    }

    public static QueryHorizon lastQueryHorizon(PlannerQuery $this) {
        return $this.last().horizon();
    }

    public static PlannerQuery withTail(PlannerQuery $this, PlannerQuery newTail) {
        Option<PlannerQuery> option = $this.tail();
        if (None$.MODULE$.equals(option)) {
            Some x$12 = new Some((Object)newTail);
            QueryGraph x$13 = $this.copy$default$1();
            QueryHorizon x$14 = $this.copy$default$2();
            PlannerQuery plannerQuery = $this.copy(x$13, x$14, (Option<PlannerQuery>)x$12);
            return plannerQuery;
        }
        if (option instanceof Some) {
            throw new InternalException("Attempt to set a second tail on a query graph", InternalException$.MODULE$.$lessinit$greater$default$2());
        }
        throw new MatchError(option);
    }

    public static PlannerQuery withoutHints(PlannerQuery $this, GenTraversableOnce hintsToIgnore) {
        return $this.copy($this.queryGraph().withoutHints((GenTraversableOnce<Hint>)hintsToIgnore), $this.copy$default$2(), $this.copy$default$3());
    }

    public static PlannerQuery withHorizon(PlannerQuery $this, QueryHorizon horizon) {
        QueryHorizon x$15 = horizon;
        QueryGraph x$16 = $this.copy$default$1();
        Option<PlannerQuery> x$17 = $this.copy$default$3();
        return $this.copy(x$16, x$15, x$17);
    }

    public static PlannerQuery withQueryGraph(PlannerQuery $this, QueryGraph queryGraph) {
        return $this.copy(queryGraph, $this.copy$default$2(), $this.copy$default$3());
    }

    public static boolean isCoveredByHints(PlannerQuery $this, PlannerQuery other2) {
        Set<Hint> set = other2.allHints();
        return $this.allHints().forall((Function1)new Serializable($this, set){
            public static final long serialVersionUID = 0L;
            private final Set eta$0$1$1;

            public final boolean apply(Hint elem) {
                return this.eta$0$1$1.contains((Object)elem);
            }
            {
                this.eta$0$1$1 = eta$0$1$1;
            }
        });
    }

    public static Set allHints(PlannerQuery $this) {
        Option<PlannerQuery> option;
        block4: {
            Set set;
            block3: {
                block2: {
                    option = $this.tail();
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    PlannerQuery tailPlannerQuery = (PlannerQuery)some.x();
                    set = (Set)$this.queryGraph().allHints().$plus$plus(tailPlannerQuery.allHints());
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                set = $this.queryGraph().allHints();
            }
            return set;
        }
        throw new MatchError(option);
    }

    public static int numHints(PlannerQuery $this) {
        Option<PlannerQuery> option;
        block4: {
            int n;
            block3: {
                block2: {
                    option = $this.tail();
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    PlannerQuery tailPlannerQuery = (PlannerQuery)some.x();
                    n = $this.queryGraph().numHints() + tailPlannerQuery.numHints();
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                n = $this.queryGraph().numHints();
            }
            return n;
        }
        throw new MatchError(option);
    }

    public static PlannerQuery amendQueryGraph(PlannerQuery $this, Function1 f) {
        return $this.withQueryGraph((QueryGraph)f.apply((Object)$this.queryGraph()));
    }

    public static PlannerQuery updateHorizon(PlannerQuery $this, Function1 f) {
        return $this.withHorizon((QueryHorizon)f.apply((Object)$this.horizon()));
    }

    public static PlannerQuery updateQueryProjection(PlannerQuery $this, Function1 f) {
        QueryHorizon queryHorizon = $this.horizon();
        if (queryHorizon instanceof QueryProjection) {
            QueryProjection queryProjection = (QueryProjection)queryHorizon;
            PlannerQuery plannerQuery = $this.withHorizon((QueryHorizon)f.apply((Object)queryProjection));
            return plannerQuery;
        }
        throw new InternalException("Tried updating projection when there was no projection there", InternalException$.MODULE$.$lessinit$greater$default$2());
    }

    public static PlannerQuery updateTail(PlannerQuery $this, Function1 f) {
        Option<PlannerQuery> option;
        block4: {
            PlannerQuery plannerQuery;
            block3: {
                block2: {
                    option = $this.tail();
                    if (!None$.MODULE$.equals(option)) break block2;
                    plannerQuery = $this;
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                Some some = (Some)option;
                PlannerQuery tailQuery = (PlannerQuery)some.x();
                Some x$9 = new Some(f.apply((Object)tailQuery));
                QueryGraph x$10 = $this.copy$default$1();
                QueryHorizon x$11 = $this.copy$default$2();
                plannerQuery = $this.copy(x$10, x$11, (Option<PlannerQuery>)x$9);
            }
            return plannerQuery;
        }
        throw new MatchError(option);
    }

    public static PlannerQuery updateTailOrSelf(PlannerQuery $this, Function1 f) {
        Option<PlannerQuery> option;
        block4: {
            PlannerQuery plannerQuery;
            block3: {
                block2: {
                    option = $this.tail();
                    if (!None$.MODULE$.equals(option)) break block2;
                    plannerQuery = (PlannerQuery)f.apply((Object)$this);
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                plannerQuery = $this.updateTail((Function1<PlannerQuery, PlannerQuery>)new Serializable($this, f){
                    public static final long serialVersionUID = 0L;
                    private final Function1 f$1;

                    public final PlannerQuery apply(PlannerQuery x$5) {
                        return x$5.updateTailOrSelf((Function1<PlannerQuery, PlannerQuery>)this.f$1);
                    }
                    {
                        this.f$1 = f$1;
                    }
                });
            }
            return plannerQuery;
        }
        throw new MatchError(option);
    }

    public static PlannerQuery tailOrSelf(PlannerQuery $this) {
        Option<PlannerQuery> option;
        block4: {
            PlannerQuery plannerQuery;
            block3: {
                block2: {
                    option = $this.tail();
                    if (!None$.MODULE$.equals(option)) break block2;
                    plannerQuery = $this;
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                Some some = (Some)option;
                PlannerQuery t = (PlannerQuery)some.x();
                plannerQuery = t.tailOrSelf();
            }
            return plannerQuery;
        }
        throw new MatchError(option);
    }

    public static boolean exists(PlannerQuery $this, Function1 f) {
        return BoxesRunTime.unboxToBoolean((Object)f.apply((Object)$this)) || $this.tail().exists((Function1)new Serializable($this, f){
            public static final long serialVersionUID = 0L;
            private final Function1 f$2;

            public final boolean apply(PlannerQuery x$6) {
                return x$6.exists((Function1<PlannerQuery, Object>)this.f$2);
            }
            {
                this.f$2 = f$2;
            }
        });
    }

    public static boolean all(PlannerQuery $this, Function1 f) {
        return !$this.exists((Function1<PlannerQuery, Object>)new Serializable($this, f){
            public static final long serialVersionUID = 0L;
            private final Function1 f$3;

            public final boolean apply(PlannerQuery x) {
                return !BoxesRunTime.unboxToBoolean((Object)this.f$3.apply((Object)x));
            }
            {
                this.f$3 = f$3;
            }
        });
    }

    public static PlannerQuery $plus$plus(PlannerQuery $this, PlannerQuery other2) {
        Tuple2 tuple2 = new Tuple2((Object)$this.horizon(), (Object)other2.horizon());
        if (tuple2 != null) {
            QueryHorizon a = (QueryHorizon)tuple2._1();
            QueryHorizon b = (QueryHorizon)tuple2._2();
            if (a instanceof RegularQueryProjection) {
                RegularQueryProjection regularQueryProjection = (RegularQueryProjection)a;
                if (b instanceof RegularQueryProjection) {
                    RegularQueryProjection regularQueryProjection2 = (RegularQueryProjection)b;
                    RegularQueryProjection x$18 = regularQueryProjection.$plus$plus(regularQueryProjection2);
                    QueryGraph x$19 = $this.queryGraph().$plus$plus(other2.queryGraph());
                    Option x$20 = PlannerQuery$class.either($this, $this.tail(), other2.tail());
                    RegularPlannerQuery regularPlannerQuery = new RegularPlannerQuery(x$19, x$18, (Option<PlannerQuery>)x$20);
                    return regularPlannerQuery;
                }
            }
        }
        throw new InternalException("Tried to concatenate non-regular query projections", InternalException$.MODULE$.$lessinit$greater$default$2());
    }

    private static Option either(PlannerQuery $this, Option a, Option b) {
        Tuple2 tuple2;
        block7: {
            Option option;
            block6: {
                block5: {
                    tuple2 = new Tuple2((Object)a, (Object)b);
                    if (tuple2 != null) {
                        Option option2 = (Option)tuple2._1();
                        Option option3 = (Option)tuple2._2();
                        if (option2 instanceof Some && option3 instanceof Some) {
                            throw new InternalException("Can't join two query graphs with different SKIP", InternalException$.MODULE$.$lessinit$greater$default$2());
                        }
                    }
                    if (tuple2 == null) break block5;
                    Option s = (Option)tuple2._1();
                    Option option4 = (Option)tuple2._2();
                    if (!(s instanceof Some)) break block5;
                    Some some = (Some)s;
                    if (!None$.MODULE$.equals(option4)) break block5;
                    option = some;
                    break block6;
                }
                if (tuple2 == null) break block7;
                Option option5 = (Option)tuple2._1();
                Option s = (Option)tuple2._2();
                if (!None$.MODULE$.equals(option5)) break block7;
                option = s;
            }
            return option;
        }
        throw new MatchError((Object)tuple2);
    }

    public static QueryGraph copy$default$1(PlannerQuery $this) {
        return $this.queryGraph();
    }

    public static QueryHorizon copy$default$2(PlannerQuery $this) {
        return $this.horizon();
    }

    public static Option copy$default$3(PlannerQuery $this) {
        return $this.tail();
    }

    public static PlannerQuery foldMap(PlannerQuery $this, Function2 f) {
        Option<PlannerQuery> option;
        block4: {
            PlannerQuery plannerQuery;
            block3: {
                block2: {
                    option = $this.tail();
                    if (!None$.MODULE$.equals(option)) break block2;
                    plannerQuery = $this;
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                Some some = (Some)option;
                PlannerQuery oldTail = (PlannerQuery)some.x();
                PlannerQuery newTail = (PlannerQuery)f.apply((Object)$this, (Object)oldTail);
                Some x$21 = new Some((Object)newTail.foldMap((Function2<PlannerQuery, PlannerQuery, PlannerQuery>)f));
                QueryGraph x$22 = $this.copy$default$1();
                QueryHorizon x$23 = $this.copy$default$2();
                plannerQuery = $this.copy(x$22, x$23, (Option<PlannerQuery>)x$21);
            }
            return plannerQuery;
        }
        throw new MatchError(option);
    }

    public static Object fold(PlannerQuery $this, Object in2, Function2 f) {
        return PlannerQuery$class.recurse$1($this, in2, $this, f);
    }

    public static Seq allQueryGraphs(PlannerQuery $this) {
        return (Seq)$this.allPlannerQueries().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final QueryGraph apply(PlannerQuery x$7) {
                return x$7.queryGraph();
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public static Seq allPlannerQueries(PlannerQuery $this) {
        return PlannerQuery$class.loop$1($this, (Seq)Seq$.MODULE$.empty(), (Option)new Some((Object)$this));
    }

    public static Map labelInfo(PlannerQuery $this) {
        Map map;
        Map<IdName, Set<LabelName>> labelInfo2 = $this.lastQueryGraph().selections().labelInfo();
        QueryHorizon queryHorizon = $this.lastQueryHorizon();
        if (queryHorizon instanceof QueryProjection) {
            QueryProjection queryProjection = (QueryProjection)queryHorizon;
            map = (Map)queryProjection.projections().collect((PartialFunction)new Serializable($this, labelInfo2){
                public static final long serialVersionUID = 0L;
                private final Map labelInfo$1;

                /*
                 * Enabled aggressive block sorting
                 */
                public final <A1 extends Tuple2<String, Expression>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 != null) {
                        Variable variable;
                        String name;
                        String projectedName = (String)A1._1();
                        Expression expression = (Expression)A1._2();
                        if (expression instanceof Variable && this.labelInfo$1.contains((Object)new IdName(name = (variable = (Variable)expression).name()))) {
                            object = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new IdName(projectedName)), this.labelInfo$1.apply((Object)new IdName(name)));
                            return (B1)object;
                        }
                    }
                    object = function1.apply(x1);
                    return (B1)object;
                }

                public final boolean isDefinedAt(Tuple2<String, Expression> x1) {
                    Variable variable;
                    String name;
                    Expression expression;
                    Tuple2<String, Expression> tuple2 = x1;
                    boolean bl = tuple2 != null && (expression = (Expression)tuple2._2()) instanceof Variable && this.labelInfo$1.contains((Object)new IdName(name = (variable = (Variable)expression).name()));
                    return bl;
                }
                {
                    this.labelInfo$1 = labelInfo$1;
                }
            }, Map$.MODULE$.canBuildFrom());
        } else {
            map = Predef$.MODULE$.Map().empty();
        }
        Map projectedLabelInfo = map;
        return labelInfo2.$plus$plus((GenTraversableOnce)projectedLabelInfo);
    }

    private static final Object recurse$1(PlannerQuery $this, Object acc, PlannerQuery pq, Function2 f$4) {
        Option<PlannerQuery> option;
        Object nextAcc;
        while (true) {
            PlannerQuery tailPQ;
            nextAcc = f$4.apply(acc, (Object)pq);
            option = pq.tail();
            if (!(option instanceof Some)) break;
            Some some = (Some)option;
            pq = tailPQ = (PlannerQuery)some.x();
            acc = nextAcc;
        }
        if (None$.MODULE$.equals(option)) {
            Object object = nextAcc;
            return object;
        }
        throw new MatchError(option);
    }

    private static final Seq loop$1(PlannerQuery $this, Seq acc, Option remaining) {
        Option<PlannerQuery> option;
        while (true) {
            if (None$.MODULE$.equals(option = remaining)) {
                Seq seq = acc;
                return seq;
            }
            if (!(option instanceof Some)) break;
            Some some = (Some)option;
            PlannerQuery inner = (PlannerQuery)some.x();
            remaining = inner.tail();
            acc = (Seq)acc.$colon$plus((Object)inner, Seq$.MODULE$.canBuildFrom());
        }
        throw new MatchError((Object)option);
    }

    public static void $init$(PlannerQuery $this) {
    }
}

