/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v3_2.phases;

import org.neo4j.cypher.internal.compiler.v3_2.ast.ResolvedCall;
import org.neo4j.cypher.internal.compiler.v3_2.spi.ProcedureSignature;
import org.neo4j.cypher.internal.compiler.v3_2.spi.QualifiedName;
import org.neo4j.cypher.internal.frontend.v3_2.Foldable;
import org.neo4j.cypher.internal.frontend.v3_2.Foldable$;
import org.neo4j.cypher.internal.frontend.v3_2.InternalException;
import org.neo4j.cypher.internal.frontend.v3_2.InternalException$;
import org.neo4j.cypher.internal.frontend.v3_2.ast.Statement;
import org.neo4j.cypher.internal.frontend.v3_2.ast.UnresolvedCall;
import org.neo4j.cypher.internal.frontend.v3_2.notification.InternalNotification;
import org.neo4j.cypher.internal.frontend.v3_2.notification.ProcedureWarningNotification;
import org.neo4j.cypher.internal.frontend.v3_2.phases.BaseContext;
import org.neo4j.cypher.internal.frontend.v3_2.phases.BaseState;
import org.neo4j.cypher.internal.frontend.v3_2.phases.CompilationPhaseTracer;
import org.neo4j.cypher.internal.frontend.v3_2.phases.Condition;
import org.neo4j.cypher.internal.frontend.v3_2.phases.InternalNotificationLogger;
import org.neo4j.cypher.internal.frontend.v3_2.phases.Phase;
import org.neo4j.cypher.internal.frontend.v3_2.phases.Transformer;
import org.neo4j.cypher.internal.frontend.v3_2.phases.VisitorPhase;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Set;

public final class ProcedureWarnings$
implements VisitorPhase<BaseContext, BaseState> {
    public static final ProcedureWarnings$ MODULE$;

    static {
        new ProcedureWarnings$();
    }

    public Object process(Object from2, BaseContext context) {
        return VisitorPhase.class.process((VisitorPhase)this, (Object)from2, (BaseContext)context);
    }

    public Set<Condition> postConditions() {
        return VisitorPhase.class.postConditions((VisitorPhase)this);
    }

    public Object transform(Object from2, BaseContext context) {
        return Phase.class.transform((Phase)this, (Object)from2, (BaseContext)context);
    }

    public String name() {
        return Phase.class.name((Phase)this);
    }

    public <D extends BaseContext, TO2> Transformer<D, BaseState, TO2> andThen(Transformer<D, BaseState, TO2> other2) {
        return Transformer.class.andThen((Transformer)this, other2);
    }

    public Transformer<BaseContext, BaseState, BaseState> adds(Condition condition) {
        return Transformer.class.adds((Transformer)this, (Condition)condition);
    }

    public void visit(BaseState value, BaseContext context) {
        Set<InternalNotification> warnings = this.findWarnings(value.statement());
        InternalNotificationLogger internalNotificationLogger = context.notificationLogger();
        warnings.foreach((Function1)new Serializable(internalNotificationLogger){
            public static final long serialVersionUID = 0L;
            private final InternalNotificationLogger eta$0$2$1;

            public final void apply(InternalNotification notification) {
                this.eta$0$2$1.log(notification);
            }
            {
                this.eta$0$2$1 = eta$0$2$1;
            }
        });
    }

    private Set<InternalNotification> findWarnings(Statement statement) {
        return (Set)Foldable.FoldableAny$.MODULE$.treeFold$extension(Foldable$.MODULE$.FoldableAny((Object)statement), (Object)Predef$.MODULE$.Set().empty(), (PartialFunction)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final <A1, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                void var10_12;
                ResolvedCall resolvedCall;
                ProcedureSignature procedureSignature;
                A1 A1 = x2;
                if (A1 instanceof ResolvedCall && (procedureSignature = (resolvedCall = (ResolvedCall)((Object)A1)).signature()) != null) {
                    QualifiedName name = procedureSignature.name();
                    Option<String> option = procedureSignature.warning();
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        String warning = (String)some.x();
                        Serializable serializable = new Serializable(this, name, warning, resolvedCall){
                            public static final long serialVersionUID = 0L;
                            private final QualifiedName name$2;
                            private final String warning$1;
                            private final ResolvedCall x2$2;

                            public final Tuple2<Set<InternalNotification>, None$> apply(Set<InternalNotification> seq) {
                                return new Tuple2((Object)seq.$plus((Object)new ProcedureWarningNotification(this.x2$2.position(), this.name$2.toString(), this.warning$1)), (Object)None$.MODULE$);
                            }
                            {
                                this.name$2 = name$2;
                                this.warning$1 = warning$1;
                                this.x2$2 = x2$2;
                            }
                        };
                        return var10_12;
                    }
                }
                if (A1 instanceof UnresolvedCall) {
                    throw new InternalException("Expected procedures to have been resolved already", InternalException$.MODULE$.$lessinit$greater$default$2());
                }
                Object object = function1.apply(x2);
                return var10_12;
            }

            public final boolean isDefinedAt(Object x2) {
                Option<String> option;
                ResolvedCall resolvedCall;
                ProcedureSignature procedureSignature;
                Object object = x2;
                boolean bl = object instanceof ResolvedCall && (procedureSignature = (resolvedCall = (ResolvedCall)((Object)object)).signature()) != null && (option = procedureSignature.warning()) instanceof Some ? true : object instanceof UnresolvedCall;
                return bl;
            }
        });
    }

    public CompilationPhaseTracer.CompilationPhase phase() {
        return CompilationPhaseTracer.CompilationPhase.DEPRECATION_WARNINGS;
    }

    public String description() {
        return "find calls to procedures with warnings";
    }

    private ProcedureWarnings$() {
        MODULE$ = this;
        Transformer.class.$init$((Transformer)this);
        Phase.class.$init$((Phase)this);
        VisitorPhase.class.$init$((VisitorPhase)this);
    }
}

