/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.consistency.ConsistencyCheckSettings;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Args;
import org.neo4j.helpers.Strings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.pagecache.StandalonePageCacheFactory;
import org.neo4j.kernel.impl.recovery.RecoveryRequiredChecker;
import org.neo4j.logging.FormattedLogProvider;
import org.neo4j.logging.LogProvider;

public class ConsistencyCheckTool {
    private static final String CONFIG = "config";
    private static final String VERBOSE = "v";
    private final ConsistencyCheckService consistencyCheckService;
    private final PrintStream systemError;
    private final FileSystemAbstraction fs;

    public static void main(String[] args) throws IOException {
        try {
            System.err.println("WARNING: ConsistencyCheckTool is deprecated and support for it will beremoved in a future version of Neo4j. Please use neo4j-admin check-consistency.");
            ConsistencyCheckTool.runConsistencyCheckTool(args);
        }
        catch (ToolFailureException e) {
            e.exitTool();
        }
    }

    public static ConsistencyCheckService.Result runConsistencyCheckTool(String[] args) throws ToolFailureException, IOException {
        ConsistencyCheckTool tool = new ConsistencyCheckTool(new ConsistencyCheckService(), (FileSystemAbstraction)new DefaultFileSystemAbstraction(), System.err);
        return tool.run(args);
    }

    ConsistencyCheckTool(ConsistencyCheckService consistencyCheckService, FileSystemAbstraction fs, PrintStream systemError) {
        this.consistencyCheckService = consistencyCheckService;
        this.fs = fs;
        this.systemError = systemError;
    }

    ConsistencyCheckService.Result run(String ... args) throws ToolFailureException, IOException {
        Args arguments = Args.withFlags((String[])new String[]{VERBOSE}).parse(args);
        File storeDir = this.determineStoreDirectory(arguments);
        Config tuningConfiguration = this.readConfiguration(arguments);
        boolean verbose = this.isVerbose(arguments);
        this.checkDbState(storeDir, tuningConfiguration);
        FormattedLogProvider logProvider = FormattedLogProvider.toOutputStream((OutputStream)System.out);
        try {
            return this.consistencyCheckService.runFullConsistencyCheck(storeDir, tuningConfiguration, ProgressMonitorFactory.textual((OutputStream)System.err), (LogProvider)logProvider, this.fs, verbose);
        }
        catch (ConsistencyCheckIncompleteException e) {
            throw new ToolFailureException("Check aborted due to exception", e);
        }
    }

    private boolean isVerbose(Args arguments) {
        return arguments.getBoolean(VERBOSE, Boolean.valueOf(false), Boolean.valueOf(true));
    }

    private void checkDbState(File storeDir, Config tuningConfiguration) throws ToolFailureException {
        try (PageCache pageCache = StandalonePageCacheFactory.createPageCache((FileSystemAbstraction)this.fs, (Config)tuningConfiguration);){
            if (new RecoveryRequiredChecker(this.fs, pageCache).isRecoveryRequiredAt(storeDir)) {
                throw new ToolFailureException(Strings.joinAsLines((String[])new String[]{"Active logical log detected, this might be a source of inconsistencies.", "Please recover database before running the consistency check.", "To perform recovery please start database and perform clean shutdown."}));
            }
        }
        catch (IOException e) {
            this.systemError.printf("Failure when checking for recovery state: '%s', continuing as normal.%n", e);
        }
    }

    private File determineStoreDirectory(Args arguments) throws ToolFailureException {
        List unprefixedArguments = arguments.orphans();
        if (unprefixedArguments.size() != 1) {
            throw new ToolFailureException(this.usage());
        }
        File storeDir = new File((String)unprefixedArguments.get(0));
        if (!storeDir.isDirectory()) {
            throw new ToolFailureException(Strings.joinAsLines((String[])new String[]{String.format("'%s' is not a directory", storeDir)}) + this.usage());
        }
        return storeDir;
    }

    private Config readConfiguration(Args arguments) throws ToolFailureException {
        Map specifiedConfig = MapUtil.stringMap((String[])new String[0]);
        String configFilePath = arguments.get(CONFIG, null);
        if (configFilePath != null) {
            File configFile = new File(configFilePath);
            try {
                specifiedConfig = MapUtil.load((File)configFile);
            }
            catch (IOException e) {
                throw new ToolFailureException(String.format("Could not read configuration file [%s]", configFilePath), e);
            }
        }
        return new Config(specifiedConfig, new Class[]{GraphDatabaseSettings.class, ConsistencyCheckSettings.class});
    }

    private String usage() {
        return Strings.joinAsLines((String[])new String[]{Args.jarUsage(this.getClass(), (String[])new String[]{" [-config <neo4j.conf>] [-v] <storedir>"}), "WHERE:   -config <filename>  Is the location of an optional properties file", "                             containing tuning parameters for the consistency check.", "         -v                  Produce execution output.", "         <storedir>          Is the path to the store to check."});
    }

    private static void exit() {
        System.exit(1);
    }

    public static class ToolFailureException
    extends Exception {
        ToolFailureException(String message) {
            super(message);
        }

        ToolFailureException(String message, Throwable cause) {
            super(message, cause);
        }

        public void exitTool() {
            this.printErrorMessage();
            ConsistencyCheckTool.exit();
        }

        public void printErrorMessage() {
            System.err.println(this.getMessage());
            if (this.getCause() != null) {
                this.getCause().printStackTrace(System.err);
            }
        }
    }
}

