/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.CommandFailed;
import org.neo4j.commandline.admin.IncorrectUsage;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.consistency.ConsistencyCheckSettings;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.dbms.DatabaseManagementSystemSettings;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Args;
import org.neo4j.helpers.Strings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.pagecache.StandalonePageCacheFactory;
import org.neo4j.kernel.impl.recovery.RecoveryRequiredChecker;
import org.neo4j.kernel.impl.util.Converters;
import org.neo4j.kernel.impl.util.Validator;
import org.neo4j.logging.FormattedLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.server.configuration.ConfigLoader;

public class CheckConsistencyCommand
implements AdminCommand {
    private final Path homeDir;
    private final Path configDir;
    private final OutsideWorld outsideWorld;
    private final ConsistencyCheckService consistencyCheckService;
    private final FileSystemAbstraction fileSystemAbstraction;

    public CheckConsistencyCommand(Path homeDir, Path configDir, OutsideWorld outsideWorld) {
        this(homeDir, configDir, outsideWorld, new ConsistencyCheckService());
    }

    public CheckConsistencyCommand(Path homeDir, Path configDir, OutsideWorld outsideWorld, ConsistencyCheckService consistencyCheckService) {
        this.homeDir = homeDir;
        this.configDir = configDir;
        this.outsideWorld = outsideWorld;
        this.consistencyCheckService = consistencyCheckService;
        this.fileSystemAbstraction = new DefaultFileSystemAbstraction();
    }

    public void execute(String[] args) throws IncorrectUsage, CommandFailed {
        File additionalConfigFile;
        Boolean verbose;
        String database;
        Args parsedArgs = Args.parse((String[])args);
        try {
            database = (String)parsedArgs.interpretOption("database", Converters.mandatory(), s -> s, new Validator[0]);
            verbose = parsedArgs.getBoolean("verbose");
            additionalConfigFile = (File)parsedArgs.interpretOption("additional-config", Converters.optional(), Converters.toFile(), new Validator[0]);
        }
        catch (IllegalArgumentException e) {
            throw new IncorrectUsage(e.getMessage());
        }
        Config config = CheckConsistencyCommand.loadNeo4jConfig(this.homeDir, this.configDir, database, this.loadAdditionalConfig(additionalConfigFile));
        try {
            File storeDir = (File)config.get(DatabaseManagementSystemSettings.database_path);
            this.checkDbState(storeDir, config);
            ConsistencyCheckService.Result consistencyCheckResult = this.consistencyCheckService.runFullConsistencyCheck(storeDir, config, ProgressMonitorFactory.textual((OutputStream)System.err), (LogProvider)FormattedLogProvider.toOutputStream((OutputStream)System.out), this.fileSystemAbstraction, verbose);
            if (!consistencyCheckResult.isSuccessful()) {
                throw new CommandFailed(String.format("Inconsistencies found. See '%s' for details.", this.consistencyCheckService.chooseReportPath(config, storeDir).toString()));
            }
        }
        catch (IOException | ConsistencyCheckIncompleteException e) {
            throw new CommandFailed("Consistency checking failed." + e.getMessage(), e);
        }
    }

    private Map<String, String> loadAdditionalConfig(File additionalConfigFile) {
        if (additionalConfigFile == null) {
            return new HashMap<String, String>();
        }
        try {
            return MapUtil.load((File)additionalConfigFile);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("Could not read configuration file [%s]", additionalConfigFile), e);
        }
    }

    private void checkDbState(File storeDir, Config additionalConfiguration) throws CommandFailed {
        try (PageCache pageCache = StandalonePageCacheFactory.createPageCache((FileSystemAbstraction)this.fileSystemAbstraction, (Config)additionalConfiguration);){
            if (new RecoveryRequiredChecker(this.fileSystemAbstraction, pageCache).isRecoveryRequiredAt(storeDir)) {
                throw new CommandFailed(Strings.joinAsLines((String[])new String[]{"Active logical log detected, this might be a source of inconsistencies.", "Please recover database before running the consistency check.", "To perform recovery please start database and perform clean shutdown."}));
            }
        }
        catch (IOException e) {
            this.outsideWorld.stdErrLine("Failure when checking for recovery state: '%s', continuing as normal.%n" + e.getMessage());
        }
    }

    private static Config loadNeo4jConfig(Path homeDir, Path configDir, String databaseName, Map<String, String> additionalConfig) {
        ConfigLoader configLoader = new ConfigLoader(CheckConsistencyCommand.settings());
        Config config = configLoader.loadOfflineConfig(Optional.of(homeDir.toFile()), Optional.of(configDir.resolve("neo4j.conf").toFile()), new Pair[0]);
        additionalConfig.put(DatabaseManagementSystemSettings.active_database.name(), databaseName);
        return config.with(additionalConfig, new Class[0]);
    }

    private static List<Class<?>> settings() {
        return Arrays.asList(GraphDatabaseSettings.class, DatabaseManagementSystemSettings.class, ConsistencyCheckSettings.class);
    }

    public static class Provider
    extends AdminCommand.Provider {
        public Provider() {
            super("check-consistency", new String[0]);
        }

        public Optional<String> arguments() {
            return Optional.of("--database=<database> [--additional-config=<file>] [--verbose]");
        }

        public String description() {
            return "Check the consistency of a database.";
        }

        public AdminCommand create(Path homeDir, Path configDir, OutsideWorld outsideWorld) {
            return new CheckConsistencyCommand(homeDir, configDir, outsideWorld);
        }
    }
}

