/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.codegen.source;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import org.neo4j.codegen.ByteCodes;

class FileManager
extends ForwardingJavaFileManager<StandardJavaFileManager> {
    private final Map<String, ClassFile> classes = new HashMap<String, ClassFile>();

    FileManager(StandardJavaFileManager fileManager) {
        super(fileManager);
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        ClassFile file = new ClassFile(className);
        this.classes.put(className, file);
        return file;
    }

    public Iterable<? extends ByteCodes> bytecodes() {
        return this.classes.values();
    }

    private static class ClassFile
    extends SimpleJavaFileObject
    implements ByteCodes {
        private final ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        private final String className;

        protected ClassFile(String className) {
            super(URI.create("classes:/" + className.replace('.', '/') + JavaFileObject.Kind.CLASS.extension), JavaFileObject.Kind.CLASS);
            this.className = className;
        }

        @Override
        public OutputStream openOutputStream() throws IOException {
            return this.bytes;
        }

        @Override
        public String name() {
            return this.className;
        }

        @Override
        public ByteBuffer bytes() {
            return ByteBuffer.wrap(this.bytes.toByteArray());
        }
    }
}

