/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.codegen.bytecode;

import java.util.Deque;
import java.util.LinkedList;
import java.util.function.Consumer;
import org.neo4j.codegen.ByteCodeUtils;
import org.neo4j.codegen.Expression;
import org.neo4j.codegen.FieldReference;
import org.neo4j.codegen.LocalVariable;
import org.neo4j.codegen.MethodDeclaration;
import org.neo4j.codegen.MethodEmitter;
import org.neo4j.codegen.Parameter;
import org.neo4j.codegen.TypeReference;
import org.neo4j.codegen.bytecode.Block;
import org.neo4j.codegen.bytecode.ByteCodeExpressionVisitor;
import org.neo4j.codegen.bytecode.If;
import org.neo4j.codegen.bytecode.Method;
import org.neo4j.codegen.bytecode.While;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

class MethodByteCodeEmitter
implements MethodEmitter {
    private final MethodVisitor methodVisitor;
    private final MethodDeclaration declaration;
    private final ByteCodeExpressionVisitor expressionVisitor;
    private final TypeReference base;
    private Deque<Block> stateStack = new LinkedList<Block>();

    public MethodByteCodeEmitter(ClassWriter classWriter, MethodDeclaration declaration, TypeReference base) {
        this.declaration = declaration;
        this.base = base;
        for (Parameter parameter : declaration.parameters()) {
            TypeReference type = parameter.type();
            if (!type.isInnerClass()) continue;
            classWriter.visitInnerClass(ByteCodeUtils.byteCodeName(type), ByteCodeUtils.outerName(type), type.simpleName(), type.modifiers());
        }
        this.methodVisitor = classWriter.visitMethod(1, declaration.name(), ByteCodeUtils.desc(declaration), ByteCodeUtils.signature(declaration), ByteCodeUtils.exceptions(declaration));
        this.methodVisitor.visitCode();
        this.expressionVisitor = new ByteCodeExpressionVisitor(this.methodVisitor);
        this.stateStack.push(new Method(this.methodVisitor, declaration.returnType().isVoid()));
    }

    @Override
    public void done() {
        this.methodVisitor.visitEnd();
    }

    @Override
    public void expression(Expression expression) {
        expression.accept(this.expressionVisitor);
    }

    @Override
    public void put(Expression target, FieldReference field, Expression value) {
        target.accept(this.expressionVisitor);
        value.accept(this.expressionVisitor);
        this.methodVisitor.visitFieldInsn(181, ByteCodeUtils.byteCodeName(field.owner()), field.name(), ByteCodeUtils.typeName(field.type()));
    }

    @Override
    public void returns() {
        this.methodVisitor.visitInsn(177);
    }

    @Override
    public void returns(Expression value) {
        value.accept(this.expressionVisitor);
        switch (this.declaration.returnType().simpleName()) {
            case "int": 
            case "byte": 
            case "short": 
            case "char": 
            case "boolean": {
                this.methodVisitor.visitInsn(172);
                break;
            }
            case "long": {
                this.methodVisitor.visitInsn(173);
                break;
            }
            case "float": {
                this.methodVisitor.visitInsn(174);
                break;
            }
            case "double": {
                this.methodVisitor.visitInsn(175);
                break;
            }
            default: {
                this.methodVisitor.visitInsn(176);
            }
        }
    }

    @Override
    public void assign(LocalVariable variable, Expression value) {
        value.accept(this.expressionVisitor);
        switch (variable.type().simpleName()) {
            case "int": 
            case "byte": 
            case "short": 
            case "char": 
            case "boolean": {
                this.methodVisitor.visitVarInsn(54, variable.index());
                break;
            }
            case "long": {
                this.methodVisitor.visitVarInsn(55, variable.index());
                break;
            }
            case "float": {
                this.methodVisitor.visitVarInsn(56, variable.index());
                break;
            }
            case "double": {
                this.methodVisitor.visitVarInsn(57, variable.index());
                break;
            }
            default: {
                this.methodVisitor.visitVarInsn(58, variable.index());
            }
        }
    }

    @Override
    public void beginWhile(Expression ... tests) {
        Label l0 = new Label();
        this.methodVisitor.visitLabel(l0);
        Label l1 = new Label();
        for (Expression test : tests) {
            test.accept(this.expressionVisitor);
            this.methodVisitor.visitJumpInsn(153, l1);
        }
        this.stateStack.push(new While(this.methodVisitor, l0, l1));
    }

    @Override
    public void beginIf(Expression ... tests) {
        this.beginConditional(153, tests);
    }

    @Override
    public void beginIfNot(Expression ... tests) {
        this.beginConditional(154, tests);
    }

    @Override
    public void beginIfNull(Expression ... tests) {
        this.beginConditional(199, tests);
    }

    @Override
    public void beginIfNonNull(Expression ... tests) {
        this.beginConditional(198, tests);
    }

    @Override
    public void beginBlock() {
        this.stateStack.push(() -> {});
    }

    @Override
    public void endBlock() {
        if (this.stateStack.isEmpty()) {
            throw new IllegalStateException("Unbalanced blocks");
        }
        this.stateStack.pop().endBlock();
    }

    @Override
    public <T> void tryCatchBlock(Consumer<T> body, Consumer<T> handler, LocalVariable exception, T block) {
        Label l0 = new Label();
        Label l1 = new Label();
        Label l2 = new Label();
        this.methodVisitor.visitTryCatchBlock(l0, l1, l2, ByteCodeUtils.byteCodeName(exception.type()));
        this.methodVisitor.visitLabel(l0);
        body.accept(block);
        this.methodVisitor.visitLabel(l1);
        Label l3 = new Label();
        this.methodVisitor.visitJumpInsn(167, l3);
        this.methodVisitor.visitLabel(l2);
        this.methodVisitor.visitVarInsn(58, exception.index());
        handler.accept(block);
        this.methodVisitor.visitLabel(l3);
    }

    @Override
    public void throwException(Expression exception) {
        exception.accept(this.expressionVisitor);
        this.methodVisitor.visitInsn(191);
    }

    @Override
    public void declare(LocalVariable local) {
    }

    @Override
    public void assignVariableInScope(LocalVariable local, Expression value) {
        this.assign(local, value);
    }

    private void beginConditional(int op, Expression[] tests) {
        Label l0 = new Label();
        for (Expression test : tests) {
            test.accept(this.expressionVisitor);
            this.methodVisitor.visitJumpInsn(op, l0);
        }
        this.stateStack.push(new If(this.methodVisitor, l0));
    }
}

